/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StorageResultSet<K extends MetaData, V extends Record>
implements ResultSet<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(StorageResultSet.class);
    private byte[] resultHeaderBytes = null;

    public StorageResultSet() {
        byte[] arr2 = Dolphin.getIntBytes(Integer.parseInt(this.resultSetType()));
        byte[] mergedArray = new byte[Dolphin.MAGIC_BYTES.length + arr2.length];
        System.arraycopy(Dolphin.MAGIC_BYTES, 0, mergedArray, 0, Dolphin.MAGIC_BYTES.length);
        System.arraycopy(arr2, 0, mergedArray, Dolphin.MAGIC_BYTES.length, arr2.length);
        this.resultHeaderBytes = mergedArray;
    }

    public String charset() {
        return (String)StorageConfiguration.STORAGE_RS_FILE_TYPE.getValue();
    }

    public FsPath getResultSetPath(FsPath parentDir, String fileName) {
        String path = parentDir.getPath().endsWith("/") ? parentDir.getUriString() + fileName + ".dolphin" : parentDir.getUriString() + "/" + fileName + ".dolphin";
        logger.info("Get result set path: {}", (Object)path);
        return new FsPath(path);
    }

    public byte[] getResultSetHeader() {
        return this.resultHeaderBytes;
    }

    public boolean belongToPath(String path) {
        return path.endsWith(".dolphin");
    }

    public boolean belongToResultSet(String content) {
        try {
            return Dolphin.getType(content).equals(this.resultSetType());
        }
        catch (Exception e) {
            logger.info("Wrong result set: ", (Throwable)e);
            return false;
        }
    }
}

