/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.storage.resultset.ResultSetReaderFactory;
import org.apache.linkis.storage.resultset.StorageResultSetWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetWriterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetWriterFactory.class);

    public static <K extends MetaData, V extends Record> ResultSetWriter<K, V> getResultSetWriter(ResultSet<K, V> resultSet, long maxCacheSize, FsPath storePath) {
        return new StorageResultSetWriter<K, V>(resultSet, maxCacheSize, storePath);
    }

    public static <K extends MetaData, V extends Record> ResultSetWriter<K, V> getResultSetWriter(ResultSet<K, V> resultSet, long maxCacheSize, FsPath storePath, String proxyUser) {
        StorageResultSetWriter<K, V> writer = new StorageResultSetWriter<K, V>(resultSet, maxCacheSize, storePath);
        writer.setProxyUser(proxyUser);
        return writer;
    }

    public static Record[] getRecordByWriter(ResultSetWriter<? extends MetaData, ? extends Record> writer, long limit) {
        String res = writer.toString();
        return ResultSetWriterFactory.getRecordByRes(res, limit);
    }

    public static Record[] getRecordByRes(String res, long limit) {
        ResultSetReader reader = ResultSetReaderFactory.getResultSetReader(res);
        int count = 0;
        ArrayList<Record> records = new ArrayList<Record>();
        try {
            reader.getMetaData();
            while (reader.hasNext() && (long)count < limit) {
                records.add(reader.getRecord());
                ++count;
            }
        }
        catch (IOException e) {
            logger.warn("ResultSetWriter getRecordByRes failed", (Throwable)e);
        }
        return records.toArray(new Record[0]);
    }

    public static Record getLastRecordByRes(String res) {
        ResultSetReader reader = ResultSetReaderFactory.getResultSetReader(res);
        Record record = null;
        try {
            reader.getMetaData();
            while (reader.hasNext()) {
                record = reader.getRecord();
            }
        }
        catch (IOException e) {
            logger.warn("ResultSetWriter getLastRecordByRes failed", (Throwable)e);
        }
        return record;
    }
}

