/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.IOException;
import java.io.InputStream;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.resultset.StorageResultSetReader;
import org.apache.linkis.storage.resultset.table.TableResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetReaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetReaderFactory.class);

    public static <K extends MetaData, V extends Record> ResultSetReader getResultSetReader(ResultSet<K, V> resultSet, InputStream inputStream) {
        return new StorageResultSetReader<K, V>(resultSet, inputStream);
    }

    public static <K extends MetaData, V extends Record> ResultSetReader getResultSetReader(ResultSet<K, V> resultSet, String value) {
        return new StorageResultSetReader<K, V>(resultSet, value);
    }

    public static ResultSetReader getResultSetReader(String res) {
        ResultSetFactory rsFactory = ResultSetFactory.getInstance();
        if (rsFactory.isResultSet(res)) {
            ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSet(res);
            return ResultSetReaderFactory.getResultSetReader(resultSet, res);
        }
        FsPath resPath = new FsPath(res);
        ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSetByPath(resPath);
        try {
            FSFactory.getFs(resPath).init(null);
        }
        catch (IOException e) {
            logger.warn("ResultSetReaderFactory fs init failed", (Throwable)e);
        }
        ResultSetReader reader = null;
        try {
            reader = ResultSetReaderFactory.getResultSetReader(resultSet, FSFactory.getFs(resPath).read(resPath));
        }
        catch (IOException e) {
            logger.warn("ResultSetReaderFactory fs read failed", (Throwable)e);
        }
        if (reader instanceof StorageResultSetReader) {
            ((StorageResultSetReader)reader).setFs(FSFactory.getFs(resPath));
        }
        return (StorageResultSetReader)reader;
    }

    public static ResultSetReader getTableResultReader(String res) {
        ResultSetFactory rsFactory = ResultSetFactory.getInstance();
        if (rsFactory.isResultSet(res)) {
            ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSet(res);
            if (!"2".equals(resultSet.resultSetType())) {
                throw new StorageWarnException(LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorCode(), LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorDesc());
            }
            return ResultSetReaderFactory.getResultSetReader((TableResultSet)resultSet, res);
        }
        FsPath resPath = new FsPath(res);
        ResultSet<? extends MetaData, ? extends Record> resultSet = rsFactory.getResultSetByPath(resPath);
        if (!"2".equals(resultSet.resultSetType())) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorCode(), LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorDesc());
        }
        Fs fs = FSFactory.getFs(resPath);
        try {
            fs.init(null);
            InputStream read = fs.read(resPath);
            return ResultSetReaderFactory.getResultSetReader((TableResultSet)resultSet, read);
        }
        catch (IOException e) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorCode(), LinkisStorageErrorCodeSummary.TABLE_ARE_NOT_SUPPORTED.getErrorDesc());
        }
    }
}

