/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.storage.domain.Dolphin;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.resultset.ResultMetaData;
import org.apache.linkis.storage.resultset.ResultRecord;
import org.apache.linkis.storage.resultset.ResultSetFactory;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultSetFactory
implements ResultSetFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResultSetFactory.class);
    private final Map<String, Class<ResultSet<ResultMetaData, ResultRecord>>> resultClasses = StorageUtils.loadClasses((String)StorageConfiguration.STORAGE_RESULT_SET_CLASSES.getValue(), (String)StorageConfiguration.STORAGE_RESULT_SET_PACKAGE.getValue(), t -> {
        try {
            return ((ResultSet)t.newInstance()).resultSetType().toLowerCase(Locale.getDefault());
        }
        catch (InstantiationException e) {
            logger.warn("DefaultResultSetFactory init failed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn("DefaultResultSetFactory init failed", (Throwable)e);
        }
        return null;
    });
    private final String[] resultTypes = ResultSetFactory.resultSetType.keySet().toArray(new String[0]);

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByType(String resultSetType) {
        if (!this.resultClasses.containsKey(resultSetType)) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_RESULT.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.UNSUPPORTED_RESULT.getErrorDesc(), resultSetType));
        }
        try {
            return this.resultClasses.get(resultSetType).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_RESULT.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.UNSUPPORTED_RESULT.getErrorDesc(), resultSetType), e);
        }
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByPath(FsPath fsPath) throws StorageWarnException {
        return this.getResultSetByPath(fsPath, StorageUtils.getJvmUser());
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByContent(String content) {
        return this.getResultSetByType(Dolphin.getType(content));
    }

    @Override
    public boolean exists(String resultSetType) {
        return this.resultClasses.containsKey(resultSetType);
    }

    @Override
    public boolean isResultSetPath(String path) {
        return path.endsWith(".dolphin");
    }

    @Override
    public boolean isResultSet(String content) {
        try {
            return this.resultClasses.containsKey(Dolphin.getType(content));
        }
        catch (Exception e) {
            logger.info("Wrong result Set: " + e.getMessage());
            return false;
        }
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSet(String output) throws StorageWarnException {
        return this.getResultSet(output, StorageUtils.getJvmUser());
    }

    @Override
    public String[] getResultSetType() {
        return Arrays.copyOf(this.resultTypes, this.resultTypes.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByPath(FsPath fsPath, Fs fs) {
        try (InputStream inputStream = fs.read(fsPath);){
            String resultSetType = Dolphin.getType(inputStream);
            if (StringUtils.isEmpty((CharSequence)resultSetType)) {
                throw new StorageWarnException(LinkisStorageErrorCodeSummary.THE_FILE_IS_EMPTY.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.THE_FILE_IS_EMPTY.getErrorDesc(), fsPath.getPath()));
            }
            ResultSet<? extends MetaData, ? extends Record> resultSet = this.getResultSetByType(resultSetType);
            return resultSet;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSetByPath(FsPath fsPath, String proxyUser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet<? extends MetaData, ? extends Record> getResultSet(String output, String proxyUser) {
        if (this.isResultSetPath(output)) {
            return this.getResultSetByPath(new FsPath(output), proxyUser);
        }
        if (this.isResultSet(output)) {
            return this.getResultSetByContent(output);
        }
        return null;
    }
}

