/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.io;

import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.io.IOMethodInterceptorCreator;
import org.springframework.cglib.proxy.MethodInterceptor;

public class IOMethodInterceptorFactory {
    private static IOMethodInterceptorCreator interceptorCreator = null;

    private IOMethodInterceptorFactory() {
    }

    public static void register(IOMethodInterceptorCreator interceptorCreator) {
        IOMethodInterceptorFactory.interceptorCreator = interceptorCreator;
    }

    public static MethodInterceptor getIOMethodInterceptor(String fsName) throws StorageWarnException {
        if (interceptorCreator == null) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.MUST_REGISTER_TOM.getErrorCode(), LinkisStorageErrorCodeSummary.MUST_REGISTER_TOM.getErrorDesc());
        }
        return interceptorCreator.createIOMethodInterceptor(fsName);
    }
}

