/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.io;

import java.util.UUID;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.io.IOClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(IOClientFactory.class);
    private static IOClient ioClient = null;
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILED = "FAILED";

    public static IOClient getIOClient() throws StorageErrorException {
        if (ioClient == null) {
            throw new StorageErrorException(LinkisStorageErrorCodeSummary.MUST_REGISTER_TOC.getErrorCode(), LinkisStorageErrorCodeSummary.MUST_REGISTER_TOC.getErrorDesc());
        }
        return ioClient;
    }

    public static void register(IOClient client) {
        ioClient = client;
        logger.debug("IOClient: {} registered", (Object)ioClient.toString());
    }

    public static String getFSId() {
        return UUID.randomUUID().toString();
    }
}

