/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.impl;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class S3OutputStream
extends ByteArrayOutputStream {
    private AmazonS3 s3Client;
    private String bucket;
    private String path;

    public S3OutputStream(AmazonS3 s3Client, String bucket, String path) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.path = path;
    }

    @Override
    public void close() throws IOException {
        byte[] buffer = this.toByteArray();
        try (ByteArrayInputStream in = new ByteArrayInputStream(buffer);){
            this.s3Client.putObject(this.bucket, this.path, (InputStream)in, new ObjectMetadata());
        }
    }
}

