/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.impl;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(S3FileSystem.class);
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private String region;
    private String bucket;
    private String label;
    private AmazonS3 s3Client;
    private static final String INIT_FILE_NAME = ".s3_dir_init";

    public void init(Map<String, String> properties) throws IOException {
        this.accessKey = (String)StorageConfiguration.S3_ACCESS_KEY.getValue(properties);
        this.secretKey = (String)StorageConfiguration.S3_SECRET_KEY.getValue(properties);
        this.endPoint = (String)StorageConfiguration.S3_ENDPOINT.getValue(properties);
        this.bucket = (String)StorageConfiguration.S3_BUCKET.getValue(properties);
        this.region = (String)StorageConfiguration.S3_REGION.getValue(properties);
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.endPoint, this.region);
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AWSStaticCredentialsProvider StaticCredentials = new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials);
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(endpointConfiguration)).withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)StaticCredentials)).build();
    }

    public String fsName() {
        return "s3";
    }

    public String rootUserName() {
        return null;
    }

    public FsPath get(String dest) throws IOException {
        FsPath ret = new FsPath(dest);
        if (this.exists(ret)) {
            return ret;
        }
        logger.warn("File or folder does not exist or file name is garbled(\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u4e71\u7801)");
        throw new StorageWarnException(LinkisStorageErrorCodeSummary.TO_BE_UNKNOW.getErrorCode(), "File or folder does not exist or file name is garbled(\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u4e71\u7801)");
    }

    public InputStream read(FsPath dest) throws IOException {
        try {
            return this.s3Client.getObject(this.bucket, dest.getPath()).getObjectContent();
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
    }

    /*
     * Exception decompiling
     */
    public OutputStream write(FsPath dest, boolean overwrite) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean create(String dest) throws IOException {
        if (this.exists(new FsPath(dest))) {
            return false;
        }
        this.s3Client.putObject(this.bucket, dest, "");
        return true;
    }

    public List<FsPath> list(FsPath path) throws IOException {
        try {
            if (!StringUtils.isEmpty((CharSequence)path.getPath())) {
                ListObjectsV2Result listObjectsV2Result = this.s3Client.listObjectsV2(this.bucket, path.getPath());
                List s3ObjectSummaries = listObjectsV2Result.getObjectSummaries();
                return s3ObjectSummaries.stream().filter(summary -> !this.isInitFile((S3ObjectSummary)summary)).map(summary -> {
                    FsPath newPath = new FsPath(this.buildPath(summary.getKey()));
                    return this.fillStorageFile(newPath, (S3ObjectSummary)summary);
                }).collect(Collectors.toList());
            }
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + path.getPath());
        }
        return new ArrayList<FsPath>();
    }

    @Override
    public FsPathListWithError listPathWithError(FsPath path) throws IOException {
        try {
            ListObjectsV2Result listObjectsV2Result;
            List s3ObjectSummaries;
            if (!StringUtils.isEmpty((CharSequence)path.getPath()) && (s3ObjectSummaries = (listObjectsV2Result = this.s3Client.listObjectsV2(this.bucket, path.getPath())).getObjectSummaries()) != null) {
                ArrayList<FsPath> rtn = new ArrayList<FsPath>();
                String message = "";
                for (S3ObjectSummary summary : s3ObjectSummaries) {
                    if (this.isDir(summary, path.getPath()) || this.isInitFile(summary)) continue;
                    FsPath newPath = new FsPath(this.buildPath(summary.getKey()));
                    rtn.add(this.fillStorageFile(newPath, summary));
                }
                return new FsPathListWithError(rtn, message);
            }
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + path.getPath());
        }
        return null;
    }

    public boolean exists(FsPath dest) throws IOException {
        try {
            int size = this.s3Client.listObjectsV2(this.bucket, dest.getPath()).getObjectSummaries().size();
            return size > 0;
        }
        catch (AmazonS3Exception e) {
            return false;
        }
    }

    public boolean delete(FsPath dest) throws IOException {
        try {
            this.s3Client.deleteObject(this.bucket, dest.getPath());
            return true;
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + dest.getPath());
        }
    }

    public boolean renameTo(FsPath oldDest, FsPath newDest) throws IOException {
        try {
            this.s3Client.copyObject(this.bucket, oldDest.getPath(), this.bucket, newDest.getPath());
            this.s3Client.deleteObject(this.bucket, oldDest.getPath());
            return true;
        }
        catch (AmazonS3Exception e) {
            this.s3Client.deleteObject(this.bucket, newDest.getPath());
            throw new IOException("You have not permission to access path " + oldDest.getPath() + " or " + newDest.getPath());
        }
    }

    @Override
    public boolean copy(String origin, String dest) throws IOException {
        try {
            this.s3Client.copyObject(this.bucket, origin, this.bucket, dest);
            return true;
        }
        catch (AmazonS3Exception e) {
            throw new IOException("You have not permission to access path " + origin + " or " + dest);
        }
    }

    private boolean isDir(S3ObjectSummary s3ObjectSummary, String prefix) {
        return s3ObjectSummary.getKey().substring(prefix.length()).contains("/");
    }

    private boolean isInitFile(S3ObjectSummary s3ObjectSummary) {
        return s3ObjectSummary.getKey().contains(INIT_FILE_NAME);
    }

    @Override
    public String listRoot() {
        return "/";
    }

    public boolean mkdir(FsPath dest) throws IOException {
        String path = new File(dest.getPath(), INIT_FILE_NAME).getPath();
        if (this.exists(new FsPath(path))) {
            return false;
        }
        return this.create(path);
    }

    public boolean mkdirs(FsPath dest) throws IOException {
        return this.mkdir(dest);
    }

    private FsPath fillStorageFile(FsPath fsPath, S3ObjectSummary s3ObjectSummary) {
        fsPath.setModification_time(s3ObjectSummary.getLastModified().getTime());
        fsPath.setOwner(s3ObjectSummary.getOwner().getDisplayName());
        try {
            fsPath.setIsdir(this.isDir(s3ObjectSummary, fsPath.getParent().getPath()));
        }
        catch (Throwable e) {
            logger.warn("Failed to fill storage file\uff1a" + fsPath.getPath(), e);
        }
        if (fsPath.isdir()) {
            fsPath.setLength(0L);
        } else {
            fsPath.setLength(s3ObjectSummary.getSize());
        }
        return fsPath;
    }

    public boolean canRead(FsPath dest) {
        return true;
    }

    public boolean canWrite(FsPath dest) {
        return true;
    }

    @Override
    public long getTotalSpace(FsPath dest) {
        return 0L;
    }

    @Override
    public long getFreeSpace(FsPath dest) {
        return 0L;
    }

    @Override
    public long getUsableSpace(FsPath dest) {
        return 0L;
    }

    @Override
    public boolean canExecute(FsPath dest) {
        return true;
    }

    @Override
    public boolean setOwner(FsPath dest, String user, String group) {
        return false;
    }

    @Override
    public boolean setOwner(FsPath dest, String user) {
        return false;
    }

    @Override
    public boolean setGroup(FsPath dest, String group) {
        return false;
    }

    @Override
    public boolean setPermission(FsPath dest, String permission) {
        return false;
    }

    public void close() throws IOException {
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String buildPath(String path) {
        if (path == null || "".equals(path)) {
            return "";
        }
        if (path.startsWith("/")) {
            return "s3://" + path;
        }
        return "s3:///" + path;
    }
}

