/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.excel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.excel.ExcelFsWriter;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageExcelWriter
extends ExcelFsWriter {
    private static Logger logger = LoggerFactory.getLogger(StorageExcelWriter.class);
    private String charset;
    private String sheetName;
    private String dateFormat;
    private OutputStream outputStream;
    private boolean autoFormat;
    protected SXSSFWorkbook workBook;
    protected SXSSFSheet sheet;
    private DataFormat format;
    protected DataType[] types;
    protected int rowPoint;
    protected int columnCounter;
    protected Map<String, CellStyle> styles = new HashMap<String, CellStyle>();
    private boolean isFlush = true;
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private ByteArrayInputStream is;

    public StorageExcelWriter(String charset, String sheetName, String dateFormat, OutputStream outputStream, boolean autoFormat) {
        this.charset = charset;
        this.sheetName = sheetName;
        this.dateFormat = dateFormat;
        this.outputStream = outputStream;
        this.autoFormat = autoFormat;
    }

    public void init() {
        this.workBook = new SXSSFWorkbook();
        this.sheet = this.workBook.createSheet(this.sheetName);
    }

    public CellStyle getDefaultHeadStyle() {
        Font headerFont = this.workBook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)14);
        headerFont.setColor(IndexedColors.RED.getIndex());
        CellStyle headerCellStyle = this.workBook.createCellStyle();
        headerCellStyle.setFont(headerFont);
        return headerCellStyle;
    }

    public Workbook getWorkBook() {
        this.sheet.trackAllColumnsForAutoSizing();
        for (int elem = 0; elem <= this.columnCounter; ++elem) {
            this.sheet.autoSizeColumn(elem);
        }
        return this.workBook;
    }

    public CellStyle createCellStyle(DataType dataType) {
        CellStyle style = this.workBook.createCellStyle();
        this.format = this.workBook.createDataFormat();
        style.setDataFormat(this.format.getFormat("@"));
        if (this.autoFormat) {
            switch (dataType) {
                case StringType: 
                case CharType: 
                case VarcharType: {
                    style.setDataFormat(this.format.getFormat("@"));
                    break;
                }
                case TinyIntType: 
                case ShortIntType: 
                case IntType: {
                    style.setDataFormat(this.format.getFormat("#"));
                    break;
                }
                case LongType: 
                case BigIntType: {
                    style.setDataFormat(this.format.getFormat("#.##E+00"));
                    break;
                }
                case FloatType: {
                    style.setDataFormat(this.format.getFormat("#.0000000000"));
                    break;
                }
                case DoubleType: {
                    style.setDataFormat(this.format.getFormat("#.0000000000"));
                    break;
                }
                case DateType: 
                case TimestampType: {
                    style.setDataFormat(this.format.getFormat("m/d/yy h:mm"));
                    break;
                }
                case DecimalType: 
                case BigDecimalType: {
                    style.setDataFormat(this.format.getFormat("#.000000000"));
                    break;
                }
                default: {
                    style.setDataFormat(this.format.getFormat("@"));
                }
            }
        }
        return style;
    }

    public CellStyle getCellStyle(DataType dataType) {
        CellStyle style = this.styles.get(dataType.getTypeName());
        if (style == null) {
            CellStyle newStyle = this.createCellStyle(dataType);
            this.styles.put(dataType.getTypeName(), newStyle);
            return newStyle;
        }
        return style;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        this.init();
        SXSSFRow tableHead = this.sheet.createRow(0);
        Column[] columns = ((TableMetaData)metaData).getColumns();
        ArrayList<DataType> columnType = new ArrayList<DataType>();
        for (int i = 0; i < columns.length; ++i) {
            Cell headCell = tableHead.createCell(this.columnCounter);
            headCell.setCellValue(columns[i].getColumnName());
            headCell.setCellStyle(this.getDefaultHeadStyle());
            columnType.add(columns[i].getDataType());
            ++this.columnCounter;
        }
        this.types = columnType.toArray(new DataType[0]);
        ++this.rowPoint;
    }

    public void addRecord(Record record) throws IOException {
        Object[] excelRecord;
        SXSSFRow tableBody = this.sheet.createRow(this.rowPoint);
        int colunmPoint = 0;
        for (Object elem : excelRecord = ((TableRecord)record).row) {
            Cell cell = tableBody.createCell(colunmPoint);
            DataType dataType = this.types[colunmPoint];
            if (this.autoFormat) {
                this.setCellTypeValue(dataType, elem, cell);
            } else {
                cell.setCellValue(DataType.valueToString(elem));
            }
            cell.setCellStyle(this.getCellStyle(dataType));
            ++colunmPoint;
        }
        ++this.rowPoint;
    }

    private void setCellTypeValue(DataType dataType, Object elem, Cell cell) {
        if (null == elem) {
            return;
        }
        try {
            switch (dataType) {
                case StringType: 
                case CharType: 
                case VarcharType: {
                    cell.setCellValue(DataType.valueToString(elem));
                    break;
                }
                case TinyIntType: 
                case ShortIntType: 
                case IntType: {
                    cell.setCellValue((double)Integer.valueOf(elem.toString()).intValue());
                    break;
                }
                case LongType: 
                case BigIntType: {
                    cell.setCellValue((double)Long.valueOf(elem.toString()).longValue());
                    break;
                }
                case FloatType: {
                    cell.setCellValue((double)Float.valueOf(elem.toString()).floatValue());
                    break;
                }
                case DoubleType: {
                    this.doubleCheck(elem.toString());
                    cell.setCellValue(Double.valueOf(elem.toString()).doubleValue());
                    break;
                }
                case DateType: 
                case TimestampType: {
                    cell.setCellValue(this.getDate(elem));
                    break;
                }
                case DecimalType: 
                case BigDecimalType: {
                    this.doubleCheck(DataType.valueToString(elem));
                    cell.setCellValue(Double.valueOf(DataType.valueToString(elem)).doubleValue());
                    break;
                }
                default: {
                    cell.setCellValue(DataType.valueToString(elem));
                    break;
                }
            }
        }
        catch (Exception e) {
            cell.setCellValue(DataType.valueToString(elem));
        }
    }

    private Date getDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new NumberFormatException("Value " + value + " with class : " + value.getClass().getName() + " is not a valid type of Date.");
    }

    private void doubleCheck(String elemValue) {
        BigDecimal value = new BigDecimal(elemValue).stripTrailingZeros();
        if (value.precision() - value.scale() > 15) {
            throw new NumberFormatException("Value " + elemValue + " error : This data exceeds 15 significant digits.");
        }
    }

    public void flush() {
        try {
            this.getWorkBook().write((OutputStream)this.os);
        }
        catch (IOException e) {
            logger.warn("flush fail", (Throwable)e);
        }
        byte[] content = this.os.toByteArray();
        this.is = new ByteArrayInputStream(content);
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while (this.isFlush) {
            try {
                bytesRead = this.is.read(buffer, 0, 1024);
                if (bytesRead == -1) {
                    this.isFlush = false;
                    continue;
                }
                this.outputStream.write(buffer, 0, bytesRead);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void close() {
        if (this.isFlush) {
            this.flush();
        }
        IOUtils.closeQuietly((OutputStream)this.outputStream);
        IOUtils.closeQuietly((InputStream)this.is);
        IOUtils.closeQuietly((OutputStream)this.os);
        IOUtils.closeQuietly((Closeable)this.workBook);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public boolean isAutoFormat() {
        return this.autoFormat;
    }
}

