/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.domain;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphin {
    private static final Logger logger = LoggerFactory.getLogger(Dolphin.class);
    public static final Charset CHAR_SET = Charset.forName((String)StorageConfiguration.STORAGE_RS_FILE_TYPE.getValue());
    public static final String MAGIC = "dolphin";
    public static byte[] MAGIC_BYTES = new byte[0];
    public static final int MAGIC_LEN;
    public static final String DOLPHIN_FILE_SUFFIX = ".dolphin";
    public static final String COL_SPLIT = ",";
    public static final byte[] COL_SPLIT_BYTES;
    public static final int COL_SPLIT_LEN;
    public static final String NULL = "NULL";
    public static final byte[] NULL_BYTES;
    public static final int INT_LEN = 10;
    public static final int FILE_EMPTY = 31;

    public static byte[] getBytes(Object value) {
        return value.toString().getBytes(CHAR_SET);
    }

    public static String getString(byte[] bytes, int start, int len) {
        return new String(bytes, start, len, CHAR_SET);
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[11];
        if (StorageUtils.readBytes(inputStream, bytes, 10) != 10) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.FAILED_TO_READ_INTEGER.getErrorCode(), LinkisStorageErrorCodeSummary.FAILED_TO_READ_INTEGER.getErrorDesc());
        }
        return Integer.parseInt(Dolphin.getString(bytes, 0, 10));
    }

    public static byte[] getIntBytes(int value) {
        String str = Integer.toString(value);
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 10 - str.length(); ++i) {
            res.append("0");
        }
        res.append(str);
        return Dolphin.getBytes(res.toString());
    }

    public static String getType(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[100];
        int len = StorageUtils.readBytes(inputStream, bytes, MAGIC_LEN + 10);
        if (len == -1) {
            return null;
        }
        return Dolphin.getType(Dolphin.getString(bytes, 0, len));
    }

    public static String getType(String content) {
        if (content.length() < MAGIC.length() || !content.substring(0, MAGIC.length()).equals(MAGIC)) {
            throw new RuntimeException("File header type must be dolphin, content: " + content + " is not");
        }
        return Integer.toString(Integer.parseInt(content.substring(MAGIC.length(), MAGIC.length() + 10)));
    }

    static {
        try {
            MAGIC_BYTES = MAGIC.getBytes((String)StorageConfiguration.STORAGE_RS_FILE_TYPE.getValue());
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Dolphin getBytes failed", (Throwable)e);
        }
        MAGIC_LEN = MAGIC_BYTES.length;
        COL_SPLIT_BYTES = COL_SPLIT.getBytes(Charset.forName("utf-8"));
        COL_SPLIT_LEN = COL_SPLIT_BYTES.length;
        NULL_BYTES = NULL.getBytes(Charset.forName("utf-8"));
    }
}

