/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.domain;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataType {
    NullType("void", 0),
    StringType("string", 12),
    BooleanType("boolean", 16),
    TinyIntType("tinyint", -6),
    ShortIntType("short", 5),
    IntType("int", 4),
    LongType("long", -5),
    BigIntType("bigint", -5),
    FloatType("float", 6),
    DoubleType("double", 8),
    CharType("char", 1),
    VarcharType("varchar", 12),
    DateType("date", 91),
    TimestampType("timestamp", 93),
    BinaryType("binary", -2),
    DecimalType("decimal", 3),
    ArrayType("array", 2003),
    MapType("map", 2000),
    ListType("list", 2001),
    StructType("struct", 2002),
    BigDecimalType("bigdecimal", 3);

    private final String typeName;
    private final int javaSQLType;
    private static Logger logger;
    public static final String NULL_VALUE = "NULL";
    public static final String LOWCASE_NULL_VALUE = "null";
    public static final Pattern DECIMAL_REGEX;
    public static final Pattern SHORT_REGEX;
    public static final Pattern INT_REGEX;
    public static final Pattern LONG_REGEX;
    public static final Pattern BIGINT_REGEX;
    public static final Pattern FLOAT_REGEX;
    public static final Pattern DOUBLE_REGEX;
    public static final Pattern VARCHAR_REGEX;
    public static final Pattern CHAR_REGEX;
    public static final Pattern ARRAY_REGEX;
    public static final Pattern MAP_REGEX;
    public static final Pattern LIST_REGEX;
    public static final Pattern STRUCT_REGEX;

    private DataType(String typeName, int javaSQLType) {
        this.typeName = typeName;
        this.javaSQLType = javaSQLType;
    }

    public static DataType toDataType(String dataType) {
        if (dataType.equals("void") || dataType.equals(LOWCASE_NULL_VALUE)) {
            return NullType;
        }
        if (dataType.equals("string")) {
            return StringType;
        }
        if (dataType.equals("boolean")) {
            return BooleanType;
        }
        if (SHORT_REGEX.matcher(dataType).matches()) {
            return ShortIntType;
        }
        if (LONG_REGEX.matcher(dataType).matches()) {
            return LongType;
        }
        if (BIGINT_REGEX.matcher(dataType).matches()) {
            return BigIntType;
        }
        if (INT_REGEX.matcher(dataType).matches() || dataType.equals("integer") || dataType.equals("smallint")) {
            return IntType;
        }
        if (FLOAT_REGEX.matcher(dataType).matches()) {
            return FloatType;
        }
        if (DOUBLE_REGEX.matcher(dataType).matches()) {
            return DoubleType;
        }
        if (VARCHAR_REGEX.matcher(dataType).matches()) {
            return VarcharType;
        }
        if (CHAR_REGEX.matcher(dataType).matches()) {
            return CharType;
        }
        if (dataType.equals("date")) {
            return DateType;
        }
        if (dataType.equals("timestamp")) {
            return TimestampType;
        }
        if (dataType.equals("binary")) {
            return BinaryType;
        }
        if (dataType.equals("decimal") || DECIMAL_REGEX.matcher(dataType).matches()) {
            return DecimalType;
        }
        if (ARRAY_REGEX.matcher(dataType).matches()) {
            return ArrayType;
        }
        if (MAP_REGEX.matcher(dataType).matches()) {
            return MapType;
        }
        if (LIST_REGEX.matcher(dataType).matches()) {
            return ListType;
        }
        if (STRUCT_REGEX.matcher(dataType).matches()) {
            return StructType;
        }
        return StringType;
    }

    public static Object toValue(DataType dataType, String value) {
        Object result = null;
        try {
            switch (dataType) {
                case NullType: {
                    result = null;
                    break;
                }
                case StringType: 
                case CharType: 
                case VarcharType: 
                case StructType: 
                case ListType: 
                case ArrayType: 
                case MapType: {
                    result = value;
                    break;
                }
                case BooleanType: {
                    result = DataType.isNumberNull(value) ? null : Boolean.valueOf(value);
                    break;
                }
                case ShortIntType: {
                    result = DataType.isNumberNull(value) ? null : Short.valueOf(value);
                    break;
                }
                case IntType: {
                    result = DataType.isNumberNull(value) ? null : Integer.valueOf(value);
                    break;
                }
                case LongType: 
                case BigIntType: {
                    result = DataType.isNumberNull(value) ? null : Long.valueOf(value);
                    break;
                }
                case FloatType: {
                    result = DataType.isNumberNull(value) ? null : Float.valueOf(value);
                    break;
                }
                case DoubleType: {
                    result = DataType.isNumberNull(value) ? null : Double.valueOf(value);
                    break;
                }
                case DecimalType: {
                    result = DataType.isNumberNull(value) ? null : new BigDecimal(value);
                    break;
                }
                case DateType: {
                    result = DataType.isNumberNull(value) ? null : Date.valueOf(value);
                    break;
                }
                case TimestampType: {
                    result = DataType.isNumberNull(value) ? null : Optional.of(value).map(Timestamp::valueOf).map(Timestamp::toString).map(s -> s.endsWith(".0") ? s.substring(0, s.length() - 2) : s).orElse(null);
                    break;
                }
                case BinaryType: {
                    result = DataType.isNull(value) ? null : value.getBytes();
                    break;
                }
                default: {
                    result = value;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.debug("Failed to " + value + " switch to dataType:", (Throwable)e);
            result = value;
        }
        return result;
    }

    public static boolean isNull(String value) {
        return value == null || value.equals(NULL_VALUE) || value.trim().equals("");
    }

    public static boolean isNumberNull(String value) {
        return value == null || value.equalsIgnoreCase(NULL_VALUE) || value.trim().equals("");
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return LOWCASE_NULL_VALUE;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getJavaSQLType() {
        return this.javaSQLType;
    }

    public String toString() {
        return this.typeName;
    }

    static {
        logger = LoggerFactory.getLogger(DataType.class);
        DECIMAL_REGEX = Pattern.compile("^decimal\\(\\d*\\,\\d*\\)");
        SHORT_REGEX = Pattern.compile("^short.*");
        INT_REGEX = Pattern.compile("^int.*");
        LONG_REGEX = Pattern.compile("^long.*");
        BIGINT_REGEX = Pattern.compile("^bigint.*");
        FLOAT_REGEX = Pattern.compile("^float.*");
        DOUBLE_REGEX = Pattern.compile("^double.*");
        VARCHAR_REGEX = Pattern.compile("^varchar.*");
        CHAR_REGEX = Pattern.compile("^char.*");
        ARRAY_REGEX = Pattern.compile("array.*");
        MAP_REGEX = Pattern.compile("map.*");
        LIST_REGEX = Pattern.compile("list.*");
        STRUCT_REGEX = Pattern.compile("struct.*");
    }
}

