/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.csv.CSVFsWriter;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCSVWriter
extends CSVFsWriter {
    private static final Logger logger = LoggerFactory.getLogger(StorageCSVWriter.class);
    private final String charset;
    private final String separator;
    private final boolean quoteRetouchEnable;
    private final OutputStream outputStream;
    private final String delimiter;
    private final StringBuilder buffer;

    public StorageCSVWriter(String charset, String separator, boolean quoteRetouchEnable, OutputStream outputStream) {
        this.charset = charset;
        this.separator = separator;
        this.quoteRetouchEnable = quoteRetouchEnable;
        this.outputStream = outputStream;
        if (StringUtils.isBlank((CharSequence)separator)) {
            this.delimiter = "\t";
        } else {
            switch (separator) {
                case "t": {
                    this.delimiter = "\t";
                    break;
                }
                default: {
                    this.delimiter = separator;
                }
            }
        }
        this.buffer = new StringBuilder(50000);
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public boolean isQuoteRetouchEnable() {
        return this.quoteRetouchEnable;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        Column[] columns = ((TableMetaData)metaData).getColumns();
        String[] head = (String[])Stream.of(columns).map(Column::getColumnName).toArray(String[]::new);
        this.write(head);
    }

    private String compact(String[] row) {
        String quotationMarks = "\"";
        StringBuilder rowBuilder = new StringBuilder();
        for (String value : row) {
            String decoratedValue = StringUtils.isBlank((CharSequence)value) ? value : (this.quoteRetouchEnable ? quotationMarks + value.replaceAll(quotationMarks, "") + quotationMarks : value);
            rowBuilder.append(decoratedValue).append(this.delimiter);
        }
        if (rowBuilder.length() > 0 && rowBuilder.toString().endsWith(this.delimiter)) {
            int index = rowBuilder.lastIndexOf(this.delimiter);
            rowBuilder.delete(index, index + this.delimiter.length());
        }
        rowBuilder.append("\n");
        if (logger.isDebugEnabled()) {
            logger.debug("delimiter:" + this.delimiter);
        }
        return rowBuilder.toString();
    }

    private void write(String[] row) throws IOException {
        String content = this.compact(row);
        if (this.buffer.length() + content.length() > 49500) {
            IOUtils.write((byte[])this.buffer.toString().getBytes(this.charset), (OutputStream)this.outputStream);
            this.buffer.setLength(0);
        }
        this.buffer.append(content);
    }

    public void addRecord(Record record) throws IOException {
        Object[] rows = ((TableRecord)record).row;
        String[] body = (String[])Stream.of(rows).map(dataType -> DataType.valueToString(dataType)).toArray(String[]::new);
        this.write(body);
    }

    public void flush() throws IOException {
        IOUtils.write((byte[])this.buffer.toString().getBytes(this.charset), (OutputStream)this.outputStream);
        this.buffer.setLength(0);
    }

    public void close() throws IOException {
        this.flush();
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }
}

