/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.conf;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.utils.ByteTimeUtils;

public class LinkisStorageConf {
    private static final Object CONF_LOCK = new Object();
    public static final String HDFS_FILE_SYSTEM_REST_ERRS = (String)CommonVars.apply((String)"wds.linkis.hdfs.rest.errs", (Object)".*Filesystem closed.*|.*Failed to find any Kerberos tgt.*").getValue();
    public static final String ROW_BYTE_MAX_LEN_STR = (String)CommonVars.apply((String)"wds.linkis.resultset.row.max.str", (Object)"2m").getValue();
    public static final long ROW_BYTE_MAX_LEN = ByteTimeUtils.byteStringAsBytes((String)ROW_BYTE_MAX_LEN_STR);
    public static final String FILE_TYPE = (String)CommonVars.apply((String)"wds.linkis.storage.file.type", (Object)"dolphin,sql,scala,py,hql,python,out,log,text,sh,jdbc,ngql,psql,fql,tsql").getValue();
    private static volatile String[] fileTypeArr = null;

    private static String[] fileTypeArrParser(String fileType) {
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return new String[0];
        }
        return fileType.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getFileTypeArr() {
        if (fileTypeArr == null) {
            Object object = CONF_LOCK;
            synchronized (object) {
                if (fileTypeArr == null) {
                    fileTypeArr = LinkisStorageConf.fileTypeArrParser(FILE_TYPE);
                }
            }
        }
        return fileTypeArr;
    }
}

