/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.factory.BuildFactory;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;

public class FSFactory {
    private static final Map<String, BuildFactory> buildClasses = StorageUtils.loadClass((String)StorageConfiguration.STORAGE_BUILD_FS_CLASSES.getValue(), t -> t.fsName());

    public static BuildFactory getBuildFactory(String fsName) {
        if (!buildClasses.containsKey(fsName)) {
            throw new StorageWarnException(LinkisStorageErrorCodeSummary.UNSUPPORTED_FILE.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.UNSUPPORTED_FILE.getErrorDesc(), fsName));
        }
        return buildClasses.get(fsName);
    }

    public static Fs getFs(String fsType, String proxyUser) {
        String user = StorageUtils.getJvmUser();
        return FSFactory.getBuildFactory(fsType).getFs(user, proxyUser);
    }

    public static Fs getFs(String fsType) {
        String user = StorageUtils.getJvmUser();
        return FSFactory.getBuildFactory(fsType).getFs(user, user);
    }

    public static Fs getFs(FsPath fsPath) {
        return FSFactory.getFs(fsPath.getFsType());
    }

    public static Fs getFsByProxyUser(FsPath fsPath, String proxyUser) {
        return FSFactory.getFs(fsPath.getFsType(), proxyUser);
    }

    public Fs getFSByLabel(String fs, String label) {
        String user = StorageUtils.getJvmUser();
        return FSFactory.getBuildFactory(fs).getFs(user, user, label);
    }

    public Fs getFSByLabelAndUser(String fs, String label, String proxy) {
        String user = StorageUtils.getJvmUser();
        return FSFactory.getBuildFactory(fs).getFs(user, proxy, label);
    }
}

