/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.scheduler.executer;

import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.protocol.engine.EngineState;
import org.apache.linkis.scheduler.errorcode.LinkisSchedulerErrorCodeSummary;
import org.apache.linkis.scheduler.exception.SchedulerErrorException;
import org.apache.linkis.scheduler.executer.Executor;
import org.apache.linkis.scheduler.executer.ExecutorInfo;
import org.apache.linkis.scheduler.executer.ExecutorState$;
import org.apache.linkis.scheduler.listener.ExecutorListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!B\u0001\u0003\u0003\u0003i!\u0001E!cgR\u0014\u0018m\u0019;Fq\u0016\u001cW\u000f^8s\u0015\t\u0019A!\u0001\u0005fq\u0016\u001cW\u000f^3s\u0015\t)a!A\u0005tG\",G-\u001e7fe*\u0011q\u0001C\u0001\u0007Y&t7.[:\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u0011\u0015CXmY;u_J\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000bU$\u0018\u000e\\:\u000b\u0005}1\u0011AB2p[6|g.\u0003\u0002\"9\t9Aj\\4hS:<\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0005%$\u0007CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001\u0002'p]\u001eDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDCA\u0017/!\t9\u0002\u0001C\u0003$U\u0001\u0007A\u0005C\u00041\u0001\u0001\u0007I\u0011B\u0019\u0002\r}\u001bH/\u0019;f+\u0005\u0011\u0004CA\u001aD\u001d\t!\u0014I\u0004\u00026\u0001:\u0011ag\u0010\b\u0003oyr!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005mb\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!A\u0011\u0002\u0002\u001b\u0015CXmY;u_J\u001cF/\u0019;f\u0013\t!UIA\u0007Fq\u0016\u001cW\u000f^8s'R\fG/\u001a\u0006\u0003\u0005\nAqa\u0012\u0001A\u0002\u0013%\u0001*\u0001\u0006`gR\fG/Z0%KF$\"!\u0013'\u0011\u0005\u0015R\u0015BA&'\u0005\u0011)f.\u001b;\t\u000f53\u0015\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\r=\u0003\u0001\u0015)\u00033\u0003\u001dy6\u000f^1uK\u0002Bq!\u0015\u0001A\u0002\u0013%!+\u0001\tmCN$\u0018i\u0019;jm&$\u0018\u0010V5nKV\tA\u0005C\u0004U\u0001\u0001\u0007I\u0011B+\u0002)1\f7\u000f^!di&4\u0018\u000e^=US6,w\fJ3r)\tIe\u000bC\u0004N'\u0006\u0005\t\u0019\u0001\u0013\t\ra\u0003\u0001\u0015)\u0003%\u0003Ea\u0017m\u001d;BGRLg/\u001b;z)&lW\r\t\u0005\b5\u0002\u0001\r\u0011\"\u0003\\\u0003A)\u00070Z2vi>\u0014H*[:uK:,'/F\u0001]!\r)SlX\u0005\u0003=\u001a\u0012aa\u00149uS>t\u0007C\u00011d\u001b\u0005\t'B\u00012\u0005\u0003!a\u0017n\u001d;f]\u0016\u0014\u0018B\u00013b\u0005A)\u00050Z2vi>\u0014H*[:uK:,'\u000fC\u0004g\u0001\u0001\u0007I\u0011B4\u0002)\u0015DXmY;u_Jd\u0015n\u001d;f]\u0016\u0014x\fJ3r)\tI\u0005\u000eC\u0004NK\u0006\u0005\t\u0019\u0001/\t\r)\u0004\u0001\u0015)\u0003]\u0003E)\u00070Z2vi>\u0014H*[:uK:,'\u000f\t\u0005\u0006Y\u0002!\t!\\\u0001\u0014g\u0016$X\t_3dkR|'\u000fT5ti\u0016tWM\u001d\u000b\u0003\u0013:DQAW6A\u0002}CQ\u0001\u001d\u0001\u0007\u0012E\f\u0001bY1mY\n\f7m\u001b\u000b\u0002\u0013\")1\u000f\u0001C\ti\u00061\u0011n]%eY\u0016,\u0012!\u001e\t\u0003KYL!a\u001e\u0014\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0010\u0001C\ti\u00061\u0011n\u001d\"vgfDQa\u001f\u0001\u0005\u0012q\f\u0001b\u001e5f]\n+8/_\u000b\u0004{\u0006EAc\u0001@\u0002\u0004A\u0011Qe`\u0005\u0004\u0003\u00031#aA!os\"A\u0011Q\u0001>\u0005\u0002\u0004\t9!A\u0001g!\u0015)\u0013\u0011BA\u0007\u0013\r\tYA\n\u0002\ty\tLh.Y7f}A!\u0011qBA\t\u0019\u0001!q!a\u0005{\u0005\u0004\t)BA\u0001B#\r\t9B \t\u0004K\u0005e\u0011bAA\u000eM\t9aj\u001c;iS:<\u0007bBA\u0010\u0001\u0011E\u0011\u0011E\u0001\to\",g.\u00133mKV!\u00111EA\u0016)\rq\u0018Q\u0005\u0005\n\u0003\u000b\ti\u0002\"a\u0001\u0003O\u0001R!JA\u0005\u0003S\u0001B!a\u0004\u0002,\u0011A\u00111CA\u000f\u0005\u0004\t)\u0002C\u0004\u00020\u0001!\t\"!\r\u0002\u0013]DWM\\*uCR,W\u0003BA\u001a\u0003\u007f!RA`A\u001b\u0003sAq!a\u000e\u0002.\u0001\u0007!'A\u0003ti\u0006$X\rC\u0005\u0002\u0006\u00055B\u00111\u0001\u0002<A)Q%!\u0003\u0002>A!\u0011qBA \t!\t\u0019\"!\fC\u0002\u0005U\u0001bBA\"\u0001\u0011E\u0011QI\u0001\u000bK:\u001cXO]3CkNLX\u0003BA$\u0003\u0017\"B!!\u0013\u0002NA!\u0011qBA&\t!\t\u0019\"!\u0011C\u0002\u0005U\u0001\"CA\u0003\u0003\u0003\"\t\u0019AA(!\u0015)\u0013\u0011BA%\u0011\u001d\t\u0019\u0006\u0001C\t\u0003+\n!\"\u001a8tkJ,\u0017\n\u001a7f+\u0011\t9&a\u0017\u0015\t\u0005e\u0013Q\f\t\u0005\u0003\u001f\tY\u0006\u0002\u0005\u0002\u0014\u0005E#\u0019AA\u000b\u0011%\t)!!\u0015\u0005\u0002\u0004\ty\u0006E\u0003&\u0003\u0013\tI\u0006C\u0004\u0002T\u0001!\t\"a\u0019\u0016\t\u0005\u0015\u0014\u0011\u000e\u000b\u0007\u0003O\nY'a\u001c\u0011\t\u0005=\u0011\u0011\u000e\u0003\t\u0003'\t\tG1\u0001\u0002\u0016!I\u0011QAA1\t\u0003\u0007\u0011Q\u000e\t\u0006K\u0005%\u0011q\r\u0005\b\u0003c\n\t\u00071\u0001v\u0003=!(/\u00198tSRLwN\\*uCR,\u0007bBA;\u0001\u0011E\u0011qO\u0001\u0010K:\u001cXO]3Bm\u0006LG.\u00192mKV!\u0011\u0011PA?)\u0011\tY(a \u0011\t\u0005=\u0011Q\u0010\u0003\t\u0003'\t\u0019H1\u0001\u0002\u0016!I\u0011QAA:\t\u0003\u0007\u0011\u0011\u0011\t\u0006K\u0005%\u00111\u0010\u0005\b\u0003\u000b\u0003A\u0011CAD\u000359\b.\u001a8Bm\u0006LG.\u00192mKV!\u0011\u0011RAG)\u0011\tY)a$\u0011\t\u0005=\u0011Q\u0012\u0003\t\u0003'\t\u0019I1\u0001\u0002\u0016!I\u0011QAAB\t\u0003\u0007\u0011\u0011\u0013\t\u0006K\u0005%\u00111\u0012\u0005\b\u0003+\u0003A\u0011CAL\u0003)!(/\u00198tSRLwN\u001c\u000b\u0004\u0013\u0006e\u0005bBA\u001c\u0003'\u0003\rA\r\u0005\u0007\u0003;\u0003A\u0011\t*\u0002\u000b\u001d,G/\u00133\t\r\u0005]\u0002\u0001\"\u00112\u0011\u001d\t\u0019\u000b\u0001C!\u0003K\u000bqbZ3u\u000bb,7-\u001e;pe&sgm\\\u000b\u0003\u0003O\u00032aFAU\u0013\r\tYK\u0001\u0002\r\u000bb,7-\u001e;pe&sgm\u001c\u0005\u0007\u0003_\u0003A\u0011\u0001*\u0002'\u001d,G\u000fT1ti\u0006\u001bG/\u001b<jif$\u0016.\\3\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006\u00192/\u001a;MCN$\u0018i\u0019;jm&$\u0018\u0010V5nKR\u0019\u0011*a.\t\rE\u000b\t\f1\u0001%\u0001")
public abstract class AbstractExecutor
implements Executor,
Logging {
    private final long id;
    private EngineState _state;
    private long lastActivityTime;
    private Option<ExecutorListener> executorListener;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AbstractExecutor abstractExecutor = this;
        synchronized (abstractExecutor) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private EngineState _state() {
        return this._state;
    }

    private void _state_$eq(EngineState x$1) {
        this._state = x$1;
    }

    private long lastActivityTime() {
        return this.lastActivityTime;
    }

    private void lastActivityTime_$eq(long x$1) {
        this.lastActivityTime = x$1;
    }

    private Option<ExecutorListener> executorListener() {
        return this.executorListener;
    }

    private void executorListener_$eq(Option<ExecutorListener> x$1) {
        this.executorListener = x$1;
    }

    public void setExecutorListener(ExecutorListener executorListener) {
        this.executorListener_$eq((Option<ExecutorListener>)new Some((Object)executorListener));
    }

    public abstract void callback();

    public boolean isIdle() {
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Idle();
        return !(engineState != null ? !engineState.equals(engineState2) : engineState2 != null);
    }

    public boolean isBusy() {
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Busy();
        return !(engineState != null ? !engineState.equals(engineState2) : engineState2 != null);
    }

    public <A> Object whenBusy(Function0<A> f) {
        return this.whenState(ExecutorState$.MODULE$.Busy(), f);
    }

    public <A> Object whenIdle(Function0<A> f) {
        return this.whenState(ExecutorState$.MODULE$.Idle(), f);
    }

    public <A> Object whenState(EngineState state, Function0<A> f) {
        EngineState engineState = this._state();
        EngineState engineState2 = state;
        return !(engineState != null ? !engineState.equals(engineState2) : engineState2 != null) ? f.apply() : BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <A> A ensureBusy(Function0<A> f) {
        BoxedUnit boxedUnit;
        this.lastActivityTime_$eq(System.currentTimeMillis());
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Busy();
        if (!(engineState != null ? !engineState.equals(engineState2) : engineState2 != null)) {
            AbstractExecutor abstractExecutor = this;
            synchronized (abstractExecutor) {
                EngineState engineState3 = this._state();
                EngineState engineState4 = ExecutorState$.MODULE$.Busy();
                if (!(engineState3 != null ? !engineState3.equals(engineState4) : engineState4 != null)) {
                    return (A)f.apply();
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl14 : MonitorExitStatement: MONITOREXIT : abstractExecutor
                boxedUnit = boxedUnit2;
                throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public <A> A ensureIdle(Function0<A> f) {
        return this.ensureIdle(f, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <A> A ensureIdle(Function0<A> f, boolean transitionState) {
        BoxedUnit boxedUnit;
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Idle();
        if (!(engineState != null ? !engineState.equals(engineState2) : engineState2 != null)) {
            AbstractExecutor abstractExecutor = this;
            synchronized (abstractExecutor) {
                EngineState engineState3 = this._state();
                EngineState engineState4 = ExecutorState$.MODULE$.Idle();
                if (!(engineState3 != null ? !engineState3.equals(engineState4) : engineState4 != null)) {
                    if (!transitionState) return (A)Utils$.MODULE$.tryFinally(f, (Function0)new Serializable(this, transitionState){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AbstractExecutor $outer;
                        private final boolean transitionState$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            if (this.transitionState$1) {
                                this.$outer.transition(ExecutorState$.MODULE$.Idle());
                            }
                            this.$outer.callback();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.transitionState$1 = transitionState$1;
                        }
                    });
                    this.transition(ExecutorState$.MODULE$.Busy());
                    return (A)Utils$.MODULE$.tryFinally(f, (Function0)new /* invalid duplicate definition of identical inner class */);
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl15 : MonitorExitStatement: MONITOREXIT : abstractExecutor
                boxedUnit = boxedUnit2;
                throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <A> A ensureAvailable(Function0<A> f) {
        BoxedUnit boxedUnit;
        if (ExecutorState$.MODULE$.isAvailable(this._state())) {
            AbstractExecutor abstractExecutor = this;
            synchronized (abstractExecutor) {
                if (ExecutorState$.MODULE$.isAvailable(this._state())) {
                    return (A)Utils$.MODULE$.tryFinally(f, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AbstractExecutor $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.callback();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl9 : MonitorExitStatement: MONITOREXIT : abstractExecutor
                boxedUnit = boxedUnit2;
                throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public <A> A whenAvailable(Function0<A> f) {
        if (ExecutorState$.MODULE$.isAvailable(this._state())) {
            return (A)Utils$.MODULE$.tryFinally(f, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractExecutor $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.callback();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public synchronized void transition(EngineState state) {
        boolean bl;
        this.lastActivityTime_$eq(System.currentTimeMillis());
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Error();
        EngineState engineState3 = engineState;
        if (!(engineState2 != null ? !engineState2.equals(engineState3) : engineState3 != null)) {
            bl = true;
        } else {
            EngineState engineState4 = ExecutorState$.MODULE$.Dead();
            EngineState engineState5 = engineState;
            if (!(engineState4 != null ? !engineState4.equals(engineState5) : engineState5 != null)) {
                bl = true;
            } else {
                EngineState engineState6 = ExecutorState$.MODULE$.Success();
                EngineState engineState7 = engineState;
                bl = !(engineState6 != null ? !engineState6.equals(engineState7) : engineState7 != null);
            }
        }
        if (bl) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " attempt to change state ", " => ", ", ignore it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state(), state})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            EngineState engineState8 = ExecutorState$.MODULE$.ShuttingDown();
            EngineState engineState9 = engineState;
            if (!(engineState8 != null ? !engineState8.equals(engineState9) : engineState9 != null)) {
                boolean bl2;
                EngineState engineState10 = state;
                EngineState engineState11 = ExecutorState$.MODULE$.Error();
                EngineState engineState12 = engineState10;
                if (!(engineState11 != null ? !engineState11.equals(engineState12) : engineState12 != null)) {
                    bl2 = true;
                } else {
                    EngineState engineState13 = ExecutorState$.MODULE$.Dead();
                    EngineState engineState14 = engineState10;
                    if (!(engineState13 != null ? !engineState13.equals(engineState14) : engineState14 != null)) {
                        bl2 = true;
                    } else {
                        EngineState engineState15 = ExecutorState$.MODULE$.Success();
                        EngineState engineState16 = engineState10;
                        bl2 = !(engineState15 != null ? !engineState15.equals(engineState16) : engineState16 != null);
                    }
                }
                if (bl2) {
                    EngineState oldState = this._state();
                    this._state_$eq(state);
                    this.executorListener().foreach((Function1)new Serializable(this, state, oldState){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ AbstractExecutor $outer;
                        private final EngineState state$1;
                        private final EngineState oldState$1;

                        public final void apply(ExecutorListener x$1) {
                            x$1.onExecutorStateChanged(this.$outer, this.oldState$1, this.state$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.state$1 = state$1;
                            this.oldState$1 = oldState$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " attempt to change a ShuttingDown session to ", ", ignore it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), state})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " change state ", " => ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state(), state})));
                EngineState oldState = this._state();
                this._state_$eq(state);
                this.executorListener().foreach((Function1)new Serializable(this, state, oldState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AbstractExecutor $outer;
                    private final EngineState state$1;
                    private final EngineState oldState$2;

                    public final void apply(ExecutorListener x$2) {
                        x$2.onExecutorStateChanged(this.$outer, this.oldState$2, this.state$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.state$1 = state$1;
                        this.oldState$2 = oldState$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public EngineState state() {
        return this._state();
    }

    @Override
    public ExecutorInfo getExecutorInfo() {
        return new ExecutorInfo(this.id, this._state());
    }

    public long getLastActivityTime() {
        return this.lastActivityTime();
    }

    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime_$eq(lastActivityTime);
    }

    public AbstractExecutor(long id) {
        this.id = id;
        Logging.class.$init$((Logging)this);
        this._state = ExecutorState$.MODULE$.Starting();
        this.lastActivityTime = System.currentTimeMillis();
        this.executorListener = None$.MODULE$;
    }
}

