/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.protocol.utils;

import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.NonLocalReturnControl;

public final class ZuulEntranceUtils$ {
    public static final ZuulEntranceUtils$ MODULE$;
    private final String INSTANCE_SPLIT_TOKEN;
    private final String EXEC_ID;
    private final int SPLIT_LEN;

    static {
        new ZuulEntranceUtils$();
    }

    private String INSTANCE_SPLIT_TOKEN() {
        return this.INSTANCE_SPLIT_TOKEN;
    }

    private String EXEC_ID() {
        return this.EXEC_ID;
    }

    private int SPLIT_LEN() {
        return this.SPLIT_LEN;
    }

    public String[] parseExecID(String longExecID) {
        String[] stringArray;
        if (longExecID.startsWith(this.EXEC_ID())) {
            String content = longExecID.replaceFirst(this.EXEC_ID(), "");
            int applicationNameLength = Integer.parseInt(content.substring(0, this.SPLIT_LEN()));
            int instanceLength = Integer.parseInt(content.substring(this.SPLIT_LEN(), this.SPLIT_LEN() * 2));
            String applicationName = content.substring(this.SPLIT_LEN() * 2, this.SPLIT_LEN() * 2 + applicationNameLength);
            String instances = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength, this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength);
            String shortExecID = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength, content.length());
            stringArray = (String[])((Object[])new String[]{this.EXEC_ID(), applicationName, instances, shortExecID});
        } else {
            int creatorLength = Integer.parseInt(longExecID.substring(0, 2));
            int executeLength = Integer.parseInt(longExecID.substring(2, 4));
            int instanceLength = Integer.parseInt(longExecID.substring(4, 6));
            String creator = longExecID.substring(6, 6 + creatorLength);
            String executeApplicationName = longExecID.substring(6 + creatorLength, 6 + creatorLength + executeLength);
            String instance = longExecID.substring(6 + creatorLength + executeLength, 6 + creatorLength + executeLength + instanceLength);
            String shortExecID = longExecID.substring(6 + creatorLength + executeLength + instanceLength, longExecID.length());
            stringArray = (String[])((Object[])new String[]{creator, executeApplicationName, instance, shortExecID});
        }
        return stringArray;
    }

    public String generateExecID(String shortExecID, String executeApplicationName, String instance, String creator) {
        String creatorLength = this.getLengthStr(creator);
        String executeLength = this.getLengthStr(executeApplicationName);
        String instanceLength = this.getLengthStr(instance);
        return new StringBuilder().append((Object)creatorLength).append((Object)executeLength).append((Object)instanceLength).append((Object)creator).append((Object)executeApplicationName).append((Object)instance).append((Object)shortExecID).toString();
    }

    private boolean isNumberic(String s) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                Predef$.MODULE$.charArrayOps(s.toCharArray()).foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(char c) {
                        if (c < '0' || c > '9') {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                        }
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public String generateExecID(String shortExecID, String executeApplicationName, String instance) {
        String executeLength = this.getLengthStr(executeApplicationName);
        String instanceLength = this.getLengthStr(instance);
        if (shortExecID.split("_").length == 3) {
            String creator = shortExecID.split("_")[0];
            String creatorLength = this.getLengthStr(creator);
            return new StringBuilder().append((Object)creatorLength).append((Object)executeLength).append((Object)instanceLength).append((Object)creator).append((Object)executeApplicationName).append((Object)instance).append((Object)shortExecID).toString();
        }
        return new StringBuilder().append((Object)executeLength).append((Object)instanceLength).append((Object)executeApplicationName).append((Object)instance).append((Object)shortExecID).toString();
    }

    public ServiceInstance[] parseServiceInstanceByExecID(String longExecID) {
        ServiceInstance[] serviceInstanceArray;
        if (longExecID.startsWith(this.EXEC_ID())) {
            String content = longExecID.replaceFirst(this.EXEC_ID(), "");
            int applicationNameLength = Integer.parseInt(content.substring(0, this.SPLIT_LEN()));
            int instanceLength = Integer.parseInt(content.substring(this.SPLIT_LEN(), this.SPLIT_LEN() * 2));
            String applicationName = content.substring(this.SPLIT_LEN() * 2, this.SPLIT_LEN() * 2 + applicationNameLength);
            String instances = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength, this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength);
            String shortExecID = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength, content.length());
            serviceInstanceArray = (ServiceInstance[])Predef$.MODULE$.refArrayOps((Object[])instances.split(this.INSTANCE_SPLIT_TOKEN())).map((Function1)new Serializable(applicationName){
                public static final long serialVersionUID = 0L;
                private final String applicationName$1;

                public final ServiceInstance apply(String x$1) {
                    return ServiceInstance$.MODULE$.apply(this.applicationName$1, x$1);
                }
                {
                    this.applicationName$1 = applicationName$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServiceInstance.class)));
        } else {
            int creatorLength = Integer.parseInt(longExecID.substring(0, 2));
            int executeLength = Integer.parseInt(longExecID.substring(2, 4));
            int instanceLength = Integer.parseInt(longExecID.substring(4, 6));
            String executeApplicationName = longExecID.substring(6 + creatorLength, 6 + creatorLength + executeLength);
            String instance = longExecID.substring(6 + creatorLength + executeLength, 6 + creatorLength + executeLength + instanceLength);
            serviceInstanceArray = (ServiceInstance[])((Object[])new ServiceInstance[]{ServiceInstance$.MODULE$.apply(executeApplicationName, instance)});
        }
        return serviceInstanceArray;
    }

    private String getLengthStr(String string) {
        int length = string.length();
        return length >= 10 ? String.valueOf(length) : new StringBuilder().append((Object)"0").append((Object)String.valueOf(length)).toString();
    }

    public String generateExecID(String shortExecID, String applicationName, String[] instances) {
        if (instances == null || Predef$.MODULE$.refArrayOps((Object[])instances).isEmpty()) {
            throw new RuntimeException("failed to generate ExecID ,the parameters instance is not null (\u751f\u6210ExecID\u5931\u8d25\uff0c\u4f20\u5165\u7684Instance\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        String applicationNameLength = this.getStrFixedLen(applicationName, this.SPLIT_LEN());
        String instanceStr = Predef$.MODULE$.refArrayOps((Object[])instances).mkString(this.INSTANCE_SPLIT_TOKEN());
        String instanceStrLength = this.getStrFixedLen(instanceStr, this.SPLIT_LEN());
        return new StringBuilder().append((Object)this.EXEC_ID()).append((Object)applicationNameLength).append((Object)instanceStrLength).append((Object)applicationName).append((Object)instanceStr).append((Object)shortExecID).toString();
    }

    private String getStrFixedLen(String string, int len) {
        String str = String.valueOf(string.length());
        String res = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("0")).$times(len - str.length())).append((Object)str).toString();
        return res;
    }

    private ZuulEntranceUtils$() {
        MODULE$ = this;
        this.INSTANCE_SPLIT_TOKEN = "_";
        this.EXEC_ID = "exec_id";
        this.SPLIT_LEN = 3;
    }
}

