/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.mybatis;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.github.pagehelper.PageInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.linkis.common.utils.JavaLog;
import org.apache.linkis.mybatis.DataSourceConfig;
import org.apache.linkis.mybatis.conf.MybatisConfiguration;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConfigurationProperties
@AutoConfigureAfter(value={DataSourceConfig.class})
@EnableTransactionManagement
public class MybatisConfigurationFactory
extends JavaLog {
    @Autowired
    private DataSource dataSource;

    @Bean(name={"sqlSessionFactory"})
    @Primary
    public MybatisSqlSessionFactoryBean sqlSessionFactory() {
        String typeAliasesPackage = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_TYPEALIASESPACKAGE.getValue();
        String mapperLocations = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_MAPPER_LOCATIONS.getValue();
        String configLocation = (String)MybatisConfiguration.BDP_SERVER_MYBATIS_CONFIGLOCATION.getValue();
        try {
            MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
            sessionFactoryBean.setDataSource(this.dataSource);
            this.info("Mybatis typeAliasesPackage=" + typeAliasesPackage);
            this.info("Mybatis mapperLocations=" + mapperLocations);
            this.info("Mybatis configLocation=" + configLocation);
            sessionFactoryBean.setTypeAliasesPackage(typeAliasesPackage);
            if (StringUtils.isNotBlank((String)mapperLocations)) {
                String[] mapperArray = mapperLocations.split(",");
                ArrayList resources = new ArrayList();
                for (String mapperLocation : mapperArray) {
                    CollectionUtils.addAll(resources, (Object[])new PathMatchingResourcePatternResolver().getResources(mapperLocation));
                }
                sessionFactoryBean.setMapperLocations(resources.toArray(new Resource[0]));
            }
            sessionFactoryBean.setConfigLocation(new DefaultResourceLoader().getResource(configLocation));
            Interceptor[] plugins = new Interceptor[]{this.pageInterceptor()};
            sessionFactoryBean.setPlugins(plugins);
            return sessionFactoryBean;
        }
        catch (IOException e) {
            this.error("mybatis resolver mapper*xml is error", e);
            return null;
        }
        catch (Exception e) {
            this.error("mybatis sqlSessionFactoryBean create error", e);
            return null;
        }
    }

    @Bean
    @Primary
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    @Primary
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public PageInterceptor pageInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties p = new Properties();
        p.setProperty("reasonable", "true");
        p.setProperty("pageSizeZero", "true");
        p.setProperty("helperDialect", "mysql");
        pageInterceptor.setProperties(p);
        return pageInterceptor;
    }
}

