/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$ = new GetOffsetShell$();

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        scala.collection.mutable.Map map;
        void var20_19;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently commited record timestamp is given.]").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        parser.accepts("offsets", "DEPRECATED AND IGNORED: number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        parser.accepts("max-wait-ms", "DEPRECATED AND IGNORED: The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (scala.collection.immutable.Seq<OptionSpec<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionsString = (String)options.valueOf((OptionSpec)partitionOpt);
        Set partitionIdsRequested = partitionsString.isEmpty() ? Predef$.MODULE$.Set().empty() : Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionsString.split(",")), (Function1 & Serializable)partitionString -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$1(partitionsString, partitionString)), (ClassTag)ClassTag$.MODULE$.Int())).toSet();
        long listOffsetsTimestamp = (Long)options.valueOf((OptionSpec)timeOpt);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        boolean bl = false;
        Some some = null;
        Option<Seq<PartitionInfo>> option = this.listPartitionInfos(consumer, topic, (Set<Object>)partitionIdsRequested);
        if (None$.MODULE$.equals(option)) {
            System.err.println(new StringBuilder(21).append("Topic ").append(topic).append(" does not exist").toString());
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((Seq)some.value()).isEmpty()) {
                if (partitionIdsRequested.isEmpty()) {
                    System.err.println(new StringBuilder(23).append("Topic ").append(topic).append(" has 0 partitions").toString());
                } else {
                    System.err.println(new StringBuilder(53).append("Topic ").append(topic).append(" does not have any of the requested partitions ").append(partitionIdsRequested.mkString(",")).toString());
                }
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
        }
        if (!bl) {
            throw new MatchError(option);
        }
        Seq p2 = (Seq)some.value();
        if (partitionIdsRequested.nonEmpty()) {
            partitionIdsRequested.$minus$minus((IterableOnce)var20_19.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> System.err.println(new StringBuilder(32).append("Error: partition ").append(partitionId).append(" does not exist").toString()));
        }
        Seq topicPartitions = (Seq)((IterableOps)var20_19.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)p -> {
            if (p.leader() == null) {
                System.err.println(new StringBuilder(62).append("Error: partition ").append(p.partition()).append(" does not have a leader. Skip getting offsets").toString());
                return None$.MODULE$;
            }
            return new Some((Object)new TopicPartition(p.topic(), p.partition()));
        });
        if (-2L == listOffsetsTimestamp) {
            map = CollectionConverters$.MODULE$.MapHasAsScala(consumer.beginningOffsets((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava())).asScala();
        } else if (-1L == listOffsetsTimestamp) {
            map = CollectionConverters$.MODULE$.MapHasAsScala(consumer.endOffsets((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava())).asScala();
        } else {
            java.util.Map timestampsToSearch = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topicPartitions.map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Predef$.MODULE$.long2Long(listOffsetsTimestamp)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            map = (Map)CollectionConverters$.MODULE$.MapHasAsScala(consumer.offsetsForTimes(timestampsToSearch)).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    OffsetAndTimestamp x = (OffsetAndTimestamp)x0$1._2();
                    if (x == null) {
                        return new Tuple2((Object)k, null);
                    }
                    return new Tuple2((Object)k, (Object)Predef$.MODULE$.long2Long(x.offset()));
                }
                throw new MatchError(null);
            });
        }
        scala.collection.mutable.Map partitionOffsets = map;
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])partitionOffsets.toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$main$8(x0$2)), (Ordering)Ordering.Int$.MODULE$)), (Function1 & Serializable)x0$3 -> {
            GetOffsetShell$.$anonfun$main$9(topic, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<PartitionInfo>> listPartitionInfos(KafkaConsumer<?, ?> consumer, String topic, Set<Object> partitionIds) {
        Buffer partitionInfos = ((IterableOnceOps)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(consumer.listTopics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$listPartitionInfos$1(topic, x0$1)))).values().flatMap((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3).asScala())).toBuffer();
        if (partitionInfos.isEmpty()) {
            return None$.MODULE$;
        }
        if (partitionIds.isEmpty()) {
            return new Some((Object)partitionInfos);
        }
        return new Some(partitionInfos.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitionIds.contains((Object)BoxesRunTime.boxToInteger((int)p.partition())))));
    }

    public static final /* synthetic */ int $anonfun$main$1(String partitionsString$1, String partitionString) {
        try {
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partitionString));
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(new StringBuilder(84).append("--partitions expects a comma separated list of numeric partition ids, but received: ").append(partitionsString$1).toString());
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    public static final /* synthetic */ int $anonfun$main$8(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((TopicPartition)x0$2._1()).partition();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$main$9(String topic$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition tp = (TopicPartition)x0$3._1();
            Long offset = (Long)x0$3._2();
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(topic$1).append(":").append(tp.partition()).append(":").append(Option$.MODULE$.apply((Object)offset).getOrElse((Function0 & Serializable)() -> "")).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$listPartitionInfos$1(String topic$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = (String)x0$1._1();
            return !(string != null ? !string.equals(topic$2) : topic$2 != null);
        }
        throw new MatchError(null);
    }

    private GetOffsetShell$() {
    }
}

