/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBroker$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rmh\u0001\u0002#F\u0001)C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0006?\u0002!\t\u0001\u0019\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019\t\b\u0001)A\u0005K\"9!\u000f\u0001a\u0001\n\u0013\u0019\b\"\u0003B,\u0001\u0001\u0007I\u0011\u0002B-\u0011\u001d\u0011\u0019\u0007\u0001Q!\nQD\u0011B!\u001c\u0001\u0005\u0004%IAa\u001c\t\u0011\tu\u0004\u0001)A\u0005\u0005cBqAa \u0001\t\u0013\u0011\t\tC\u0004\u0003\"\u0002!IAa)\t\u000f\t-\u0007\u0001\"\u0003\u0003N\"9!Q\u001b\u0001\u0005\n\t]\u0007b\u0002Bq\u0001\u0011\u0005!1\u001d\u0005\n\u0007\u0003\u0001\u0011\u0013!C\u0001\u0007\u0007A\u0011ba\u0002\u0001#\u0003%\taa\u0001\t\u000f\r%\u0001\u0001\"\u0001\u0004\f!91Q\u0002\u0001\u0005\u0002\r=\u0001bBB\u0005\u0001\u0011%1\u0011\u0004\u0005\b\u0007\u001b\u0001A\u0011BB\u000f\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0007KAqa!\u000b\u0001\t\u0003\u0019Y\u0003C\u0004\u0004>\u0001!\taa\u0010\t\u000f\r\r\u0003\u0001\"\u0003\u0004F!911\u000b\u0001\u0005\u0002\rU\u0003bBB/\u0001\u0011\u00051q\f\u0005\b\u0007G\u0002A\u0011AB3\u0011\u001d\u0019i\u0007\u0001C\u0001\u0007_Bqa!\u001f\u0001\t\u0003\t)\tC\u0004\u0004|\u0001!\ta! \t\u000f\r-\u0005\u0001\"\u0001\u0004\u000e\"91Q\u0015\u0001\u0005\u0002\r\u001d\u0006bBBS\u0001\u0011\u000511\u0016\u0005\b\u0007_\u0003A\u0011BBY\r\u00111\b\u0001Q<\t\u0015\u0005=1E!f\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002n\r\u0012\t\u0012)A\u0005\u0003'A!\"a\u001c$\u0005+\u0007I\u0011AA9\u0011)\t\ti\tB\tB\u0003%\u00111\u000f\u0005\u000b\u0003\u0007\u001b#Q3A\u0005\u0002\u0005\u0015\u0005BCAGG\tE\t\u0015!\u0003\u0002\b\"Q\u0011qR\u0012\u0003\u0016\u0004%\t!!%\t\u0015\u0005\u00056E!E!\u0002\u0013\t\u0019\n\u0003\u0006\u0002$\u000e\u0012)\u001a!C\u0001\u0003KC!\"!1$\u0005#\u0005\u000b\u0011BAT\u0011\u0019y6\u0005\"\u0001\u0002D\"I\u0011qZ\u0012\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003;\u001c\u0013\u0013!C\u0001\u0003?D\u0011\"!>$#\u0003%\t!a>\t\u0013\u0005m8%%A\u0005\u0002\u0005u\b\"\u0003B\u0001GE\u0005I\u0011\u0001B\u0002\u0011%\u00119aII\u0001\n\u0003\u0011I\u0001C\u0005\u0003\u000e\r\n\t\u0011\"\u0011\u0003\u0010!I!1D\u0012\u0002\u0002\u0013\u0005!Q\u0004\u0005\n\u0005?\u0019\u0013\u0011!C\u0001\u0005CA\u0011B!\f$\u0003\u0003%\tEa\f\t\u0013\t]2%!A\u0005\u0002\te\u0002\"\u0003B\"G\u0005\u0005I\u0011\tB#\u0011%\u0011IeIA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003N\r\n\t\u0011\"\u0011\u0003P!I!\u0011K\u0012\u0002\u0002\u0013\u0005#1K\u0004\n\u0007\u007f\u0003\u0011\u0011!E\u0001\u0007\u00034\u0001B\u001e\u0001\u0002\u0002#\u000511\u0019\u0005\u0007?~\"\taa7\t\u0013\t5s(!A\u0005F\t=\u0003\"CBo\u007f\u0005\u0005I\u0011QBp\u0011%\u0019YoPA\u0001\n\u0003\u001biOA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0015\t1u)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0011\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001L#V\u0003\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013a!\u00118z%\u00164\u0007C\u0001*T\u001b\u0005)\u0015B\u0001+F\u00055iU\r^1eCR\f7)Y2iKB\u0011a+W\u0007\u0002/*\u0011\u0001lR\u0001\u0006kRLGn]\u0005\u00035^\u0013q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\taU,\u0003\u0002_\u001b\n\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t\t'\r\u0005\u0002S\u0001!)1L\u0001a\u00019\u0006)\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\W#A3\u0011\u0005\u0019|W\"A4\u000b\u0005!L\u0017!\u00027pG.\u001c(B\u00016l\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019h\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017A\u00069beRLG/[8o\u001b\u0016$\u0018\rZ1uC2{7m\u001b\u0011\u0002!5,G/\u00193bi\u0006\u001cf.\u00199tQ>$X#\u0001;\u0011\u0005U\u001cS\"\u0001\u0001\u0003!5+G/\u00193bi\u0006\u001cf.\u00199tQ>$8\u0003B\u0012Lqn\u0004\"\u0001T=\n\u0005il%a\u0002)s_\u0012,8\r\u001e\t\u0004y\u0006%abA?\u0002\u00069\u0019a0a\u0001\u000e\u0003}T1!!\u0001J\u0003\u0019a$o\\8u}%\ta*C\u0002\u0002\b5\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00055!\u0001D*fe&\fG.\u001b>bE2,'bAA\u0004\u001b\u0006y\u0001/\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002\u0014AA\u0011QCA\u0010\u0003G\t\u0019$\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u001diW\u000f^1cY\u0016T1!!\bN\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\t9BA\u0005B]f\u0014VMZ'baB!\u0011QEA\u0017\u001d\u0011\t9#!\u000b\u0011\u0005yl\u0015bAA\u0016\u001b\u00061\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000bN!\u0019\t)\"!\u000e\u0002:%!\u0011qGA\f\u0005\u001dauN\\4NCB\u0004B!a\u000f\u0002h9!\u0011QHA1\u001d\u0011\ty$a\u0017\u000f\t\u0005\u0005\u0013Q\u000b\b\u0005\u0003\u0007\n\tF\u0004\u0003\u0002F\u0005-cb\u0001@\u0002H%\u0011\u0011\u0011J\u0001\u0004_J<\u0017\u0002BA'\u0003\u001f\na!\u00199bG\",'BAA%\u0013\rA\u00151\u000b\u0006\u0005\u0003\u001b\ny%\u0003\u0003\u0002X\u0005e\u0013AB2p[6|gNC\u0002I\u0003'JA!!\u0018\u0002`\u00059Q.Z:tC\u001e,'\u0002BA,\u00033JA!a\u0019\u0002f\u0005IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0015\u0011\ti&a\u0018\n\t\u0005%\u00141\u000e\u0002\u001d+B$\u0017\r^3NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\t\u0019'!\u001a\u0002!A\f'\u000f^5uS>t7\u000b^1uKN\u0004\u0013\u0001\u0003;pa&\u001c\u0017\nZ:\u0016\u0005\u0005M\u0004\u0003CA\u0013\u0003k\n\u0019#!\u001f\n\t\u0005]\u0014\u0011\u0007\u0002\u0004\u001b\u0006\u0004\b\u0003BA>\u0003{j!!a\u0018\n\t\u0005}\u0014q\f\u0002\u0005+VLG-A\u0005u_BL7-\u00133tA\u0005a1m\u001c8ue>dG.\u001a:JIV\u0011\u0011q\u0011\t\u0005\u0019\u0006%E,C\u0002\u0002\f6\u0013aa\u00149uS>t\u0017!D2p]R\u0014x\u000e\u001c7fe&#\u0007%\u0001\u0007bY&4XM\u0011:pW\u0016\u00148/\u0006\u0002\u0002\u0014B1\u0011QCA\u001b\u0003+\u0003B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u00037;\u0015aB2mkN$XM]\u0005\u0005\u0003?\u000bIJ\u0001\u0004Ce>\\WM]\u0001\u000eC2Lg/\u001a\"s_.,'o\u001d\u0011\u0002\u0015\u0005d\u0017N^3O_\u0012,7/\u0006\u0002\u0002(B1\u0011QCA\u001b\u0003S\u0003\u0002\"a+\u0002.\u0006=\u00161X\u0007\u0003\u00037IA!a\u001e\u0002\u001cA!\u0011\u0011WA\\\u001b\t\t\u0019L\u0003\u0003\u00026\u0006}\u0013a\u00028fi^|'o[\u0005\u0005\u0003s\u000b\u0019L\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002|\u0005u\u0016\u0002BA`\u0003?\u0012AAT8eK\u0006Y\u0011\r\\5wK:{G-Z:!)-!\u0018QYAd\u0003\u0013\fY-!4\t\u000f\u0005=a\u00061\u0001\u0002\u0014!9\u0011q\u000e\u0018A\u0002\u0005M\u0004bBAB]\u0001\u0007\u0011q\u0011\u0005\b\u0003\u001fs\u0003\u0019AAJ\u0011\u001d\t\u0019K\fa\u0001\u0003O\u000bAaY8qsRYA/a5\u0002V\u0006]\u0017\u0011\\An\u0011%\tya\fI\u0001\u0002\u0004\t\u0019\u0002C\u0005\u0002p=\u0002\n\u00111\u0001\u0002t!I\u00111Q\u0018\u0011\u0002\u0003\u0007\u0011q\u0011\u0005\n\u0003\u001f{\u0003\u0013!a\u0001\u0003'C\u0011\"a)0!\u0003\u0005\r!a*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001d\u0016\u0005\u0003'\t\u0019o\u000b\u0002\u0002fB!\u0011q]Ay\u001b\t\tIO\u0003\u0003\u0002l\u00065\u0018!C;oG\",7m[3e\u0015\r\ty/T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAz\u0003S\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!?+\t\u0005M\u00141]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyP\u000b\u0003\u0002\b\u0006\r\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u000bQC!a%\u0002d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B\u0006U\u0011\t9+a9\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\t\u0002\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119\"\\\u0001\u0005Y\u0006tw-\u0003\u0003\u00020\tU\u0011\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001/\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0005B\u0015!\ra%QE\u0005\u0004\u0005Oi%aA!os\"A!1F\u001c\u0002\u0002\u0003\u0007A,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005c\u0001b!a+\u00034\t\r\u0012\u0002\u0002B\u001b\u00037\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\bB!!\ra%QH\u0005\u0004\u0005\u007fi%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005WI\u0014\u0011!a\u0001\u0005G\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u0003B$\u0011!\u0011YCOA\u0001\u0002\u0004a\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003q\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005#\ta!Z9vC2\u001cH\u0003\u0002B\u001e\u0005+B\u0011Ba\u000b>\u0003\u0003\u0005\rAa\t\u0002)5,G/\u00193bi\u0006\u001cf.\u00199tQ>$x\fJ3r)\u0011\u0011YF!\u0019\u0011\u00071\u0013i&C\u0002\u0003`5\u0013A!\u00168ji\"A!1\u0006\u0004\u0002\u0002\u0003\u0007A/A\tnKR\fG-\u0019;b':\f\u0007o\u001d5pi\u0002B3a\u0002B4!\ra%\u0011N\u0005\u0004\u0005Wj%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0003rA!!1\u000fB=\u001b\t\u0011)HC\u0002\u0003x\u001d\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\u0011YH!\u001e\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0013\u0001G7bs\n,g)\u001b7uKJ\fE.\u001b<f%\u0016\u0004H.[2bgRQ!1\u0011BI\u0005+\u0013IJ!(\u0011\r\t\u0015%q\u0011BF\u001b\u0005Y\u0017b\u0001BEW\n!A*[:u!\u0011\u0011\u0019B!$\n\t\t=%Q\u0003\u0002\b\u0013:$XmZ3s\u0011\u0019\u0011\u0019J\u0003a\u0001i\u0006A1O\\1qg\"|G\u000fC\u0004\u0003\u0018*\u0001\rAa!\u0002\u000f\t\u0014xn[3sg\"9!1\u0014\u0006A\u0002\u0005=\u0016\u0001\u00047jgR,g.\u001a:OC6,\u0007b\u0002BP\u0015\u0001\u0007!1H\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo]\u0001\u0015O\u0016$\b+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0015\u0019\t\u0015&1\u0018B_\u0005\u0003\u0014\u0019Ma2\u0011\u000b1\u000bIIa*\u0011\u000bq\u0014IK!,\n\t\t-\u0016Q\u0002\u0002\t\u0013R,'/\u00192mKB!!q\u0016B[\u001d\u0011\tiD!-\n\t\tM\u0016QM\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t]&\u0011\u0018\u0002\u001a\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u00034\u0006\u0015\u0004B\u0002BJ\u0017\u0001\u0007A\u000fC\u0004\u0003@.\u0001\r!a\t\u0002\u000bQ|\u0007/[2\t\u000f\tm5\u00021\u0001\u00020\"9!QY\u0006A\u0002\tm\u0012!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiNDqA!3\f\u0001\u0004\u0011Y$A\rfeJ|'/\u00168bm\u0006LG.\u00192mK2K7\u000f^3oKJ\u001c\u0018\u0001\u00055bg\u0006c\u0017N^3F]\u0012\u0004x.\u001b8u)!\u0011YDa4\u0003R\nM\u0007B\u0002BJ\u0019\u0001\u0007A\u000fC\u0003\\\u0019\u0001\u0007A\fC\u0004\u0003\u001c2\u0001\r!a,\u0002!\u001d,G/\u00117jm\u0016,e\u000e\u001a9pS:$H\u0003\u0003Bm\u00057\u0014iNa8\u0011\u000b1\u000bI)a/\t\r\tMU\u00021\u0001u\u0011\u0015YV\u00021\u0001]\u0011\u001d\u0011Y*\u0004a\u0001\u0003_\u000b\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0015\t\u0015(\u0011\u001fB~\u0005{\u0014y\u0010\u0005\u0004\u0002,\n\u001d(1^\u0005\u0005\u0005S\fYBA\u0002TKF\u0004BAa,\u0003n&!!q\u001eB]\u0005UiU\r^1eCR\f'+Z:q_:\u001cX\rV8qS\u000eDqAa=\u000f\u0001\u0004\u0011)0\u0001\u0004u_BL7m\u001d\t\u0007\u0003W\u001390a\t\n\t\te\u00181\u0004\u0002\u0004'\u0016$\bb\u0002BN\u001d\u0001\u0007\u0011q\u0016\u0005\n\u0005\u000bt\u0001\u0013!a\u0001\u0005wA\u0011B!3\u000f!\u0003\u0005\rAa\u000f\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0015!\u0006\u0002B\u001e\u0003G\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ\nAbZ3u\u00032dGk\u001c9jGN$\"A!>\u0002!\u001d,G/\u00117m!\u0006\u0014H/\u001b;j_:\u001cHCAB\t!\u0019\tYKa>\u0004\u0014A!\u00111PB\u000b\u0013\u0011\u00199\"a\u0018\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]R!!Q_B\u000e\u0011\u0019\u0011\u0019j\u0005a\u0001iR!1qDB\u0011!!\t)#!\u001e\u0004\u0014\u0005e\u0002B\u0002BJ)\u0001\u0007A/\u0001\u000bhKRtuN\\#ySN$\u0018N\\4U_BL7m\u001d\u000b\u0005\u0005k\u001c9\u0003C\u0004\u0003tV\u0001\rA!>\u0002\u001d\u001d,G/\u00117jm\u0016\u0014%o\\6feR!1QFB\u001e!\u0015a\u0015\u0011RB\u0018!\u0011\u0019\tda\u000e\u000e\u0005\rM\"bAB\u001b\u000b\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0004:\rM\"AD'fi\u0006$\u0017\r^1Ce>\\WM\u001d\u0005\u00067Z\u0001\r\u0001X\u0001\u0010O\u0016$\u0018\t\\5wK\n\u0013xn[3sgV\u00111\u0011\t\t\u0007\u0003W\u00139oa\f\u00021\u0005$Gm\u0014:Va\u0012\fG/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0006\u0003\\\r\u001d3\u0011JB&\u0007\u001fBq!a\u0004\u0019\u0001\u0004\t\u0019\u0002C\u0004\u0003@b\u0001\r!a\t\t\r\r5\u0003\u00041\u0001]\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\rE\u0003\u00041\u0001\u0002:\u0005I1\u000f^1uK&sgm\\\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$baa\u0016\u0004Z\rm\u0003#\u0002'\u0002\n\u0006e\u0002b\u0002B`3\u0001\u0007\u00111\u0005\u0005\u0007\u0007\u001bJ\u0002\u0019\u0001/\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t)\u0011\t9i!\u0019\t\u000f\t}&\u00041\u0001\u0002$\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA!\u0011\\B4\u0007S\u001aY\u0007C\u0004\u0003@n\u0001\r!a\t\t\r\r53\u00041\u0001]\u0011\u001d\u0011Yj\u0007a\u0001\u0003_\u000bAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0004r\rM4q\u000f\t\b\u0003K\t)\bXA^\u0011\u001d\u0019)\b\ba\u0001\u0007'\t!\u0001\u001e9\t\u000f\tmE\u00041\u0001\u00020\u0006yq-\u001a;D_:$(o\u001c7mKJLE-\u0001\nhKR\u001cE.^:uKJlU\r^1eCR\fGCBB@\u0007\u000b\u001bI\t\u0005\u0003\u0002|\r\u0005\u0015\u0002BBB\u0003?\u0012qa\u00117vgR,'\u000fC\u0004\u0004\bz\u0001\r!a\t\u0002\u0013\rdWo\u001d;fe&#\u0007b\u0002BN=\u0001\u0007\u0011qV\u0001\u000fkB$\u0017\r^3NKR\fG-\u0019;b)\u0019\u0019yi!%\u0004\u0016B1\u00111\u0016Bt\u0007'Aaaa% \u0001\u0004a\u0016!D2peJ,G.\u0019;j_:LE\rC\u0004\u0004\u0018~\u0001\ra!'\u0002+U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB!11TBQ\u001b\t\u0019iJ\u0003\u0003\u0004 \u0006}\u0013\u0001\u0003:fcV,7\u000f^:\n\t\r\r6Q\u0014\u0002\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0003!\u0019wN\u001c;bS:\u001cH\u0003\u0002B\u001e\u0007SCqAa0!\u0001\u0004\t\u0019\u0003\u0006\u0003\u0003<\r5\u0006bBB;C\u0001\u000711C\u0001\u0014e\u0016lwN^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0005w\u0019\u0019l!.\u0004<\u000eu\u0006bBA\bE\u0001\u0007\u00111\u0003\u0005\b\u0003_\u0012\u0003\u0019AB\\!!\t)b!/\u0002$\u0005e\u0014\u0002BA<\u0003/AqAa0#\u0001\u0004\t\u0019\u0003\u0003\u0004\u0004N\t\u0002\r\u0001X\u0001\u0011\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R\u0004\"!^ \u0014\u000b}\u001a)m!5\u0011\u001f\r\u001d7QZA\n\u0003g\n9)a%\u0002(Rl!a!3\u000b\u0007\r-W*A\u0004sk:$\u0018.\\3\n\t\r=7\u0011\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,\u0004\u0003BBj\u00073l!a!6\u000b\u0007\r]W.\u0001\u0002j_&!\u00111BBk)\t\u0019\t-A\u0003baBd\u0017\u0010F\u0006u\u0007C\u001c\u0019o!:\u0004h\u000e%\bbBA\b\u0005\u0002\u0007\u00111\u0003\u0005\b\u0003_\u0012\u0005\u0019AA:\u0011\u001d\t\u0019I\u0011a\u0001\u0003\u000fCq!a$C\u0001\u0004\t\u0019\nC\u0004\u0002$\n\u0003\r!a*\u0002\u000fUt\u0017\r\u001d9msR!1q^B|!\u0015a\u0015\u0011RBy!5a51_A\n\u0003g\n9)a%\u0002(&\u00191Q_'\u0003\rQ+\b\u000f\\36\u0011!\u0019IpQA\u0001\u0002\u0004!\u0018a\u0001=%a\u0001")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        CollectionConverters$.MODULE$.ListHasAsScala(brokers).asScala().foreach((Function1 & Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable)partitions -> (scala.collection.mutable.Iterable)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long partitionId = x0$1._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
                int leaderBrokerId = partitionState.leader();
                int leaderEpoch = partitionState.leaderEpoch();
                Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
                List replicas = partitionState.replicas();
                List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
                List isr = partitionState.isr();
                List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
                List offlineReplicas = partitionState.offlineReplicas();
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    if (filteredReplicas.size() < replicas.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < isr.size()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(isr).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }
            throw new MatchError(null);
        }));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getAllPartitions() {
        return ((IterableOnceOps)this.metadataSnapshot().partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                return (Iterable)((LongMap)x0$1._2()).keys().map((Function1 & Serializable)partitionId -> ZkMetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong((Object)partitionId)));
            }
            throw new MatchError(null);
        })).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                return (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        long partition = x0$2._1$mcJ$sp();
                        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                        return new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        }, DummyImplicit$.MODULE$.dummyImplicit()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.diff(this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public Option<MetadataBroker> getAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).map((Function1 & Serializable)broker -> MetadataBroker$.MODULE$.apply((Broker)broker));
    }

    @Override
    public Seq<MetadataBroker> getAliveBrokers() {
        return ((IterableOnceOps)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable)broker -> MetadataBroker$.MODULE$.apply((Broker)broker))).toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$4 -> x$4.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$6 -> x$6.get((long)partitionId)).map((Function1 & Serializable)partitionInfo -> {
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                return (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable)() -> Node.noNode());
            }
            if (None$.MODULE$.equals(option)) {
                return Node.noNode();
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable)x$7 -> x$7.get((long)tp.partition())).map((Function1 & Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaIds).asScala().map((Function1 & Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long id = x0$1._1$mcJ$sp();
                return ((Map)x0$1._2()).get((Object)listenerName).map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node));
            }
            throw new MatchError(null);
        });
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((IterableOps)this.getAllPartitions(snapshot).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition tp = (TopicPartition)x0$3._1();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
                return new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.replicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.isr()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.offlineReplicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)));
            }
            throw new MatchError(null);
        });
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$9(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        Lock inWriteLock_inLock_lock = this.partitionMetadataLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair != null) {
            return !((Node)pair._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$8) {
        Set set = x$8.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$8)))) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x$9) {
        Object object = x$9._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return object == null ? uuid != null : !object.equals(uuid);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$9(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((IterableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newTopicIds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest$1.topicStates()).asScala().map((Function1 & Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()))).filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x$9)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map topicIds = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        topicIds.$plus$plus$eq((IterableOnce)newTopicIds);
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            $this.metadataSnapshot().partitionStates().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$9(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = CollectionConverters$.MODULE$.IterableHasAsScala(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public ZkMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$2() {
            return this.topicIds();
        }

        public Option<Object> copy$default$3() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$4() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$5() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicIds();
                }
                case 2: {
                    return this.controllerId();
                }
                case 3: {
                    return this.aliveBrokers();
                }
                case 4: {
                    return this.aliveNodes();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "partitionStates";
                }
                case 1: {
                    return "topicIds";
                }
                case 2: {
                    return "controllerId";
                }
                case 3: {
                    return "aliveBrokers";
                }
                case 4: {
                    return "aliveNodes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof MetadataSnapshot && ((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() == this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer())) break block3;
                    MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
                    AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
                    AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
                    if (anyRefMap != null ? !anyRefMap.equals(anyRefMap2) : anyRefMap2 != null) break block3;
                    scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
                    scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
                    if (map != null ? !map.equals(map2) : map2 != null) break block3;
                    Option<Object> option = this.controllerId();
                    Option<Object> option2 = metadataSnapshot.controllerId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    LongMap<Broker> longMap = this.aliveBrokers();
                    LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
                    if (longMap != null ? !longMap.equals(longMap2) : longMap2 != null) break block3;
                    LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
                    LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
                    if ((longMap3 != null ? !longMap3.equals(longMap4) : longMap4 != null) || !metadataSnapshot.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

