/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.raft.RaftManager;
import kafka.security.CredentialProvider;
import kafka.server.ControllerApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.metalog.MetaLogManager;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001B\u001f?\u0001\rC\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t9\u0002\u0011\t\u0011)A\u00051\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\u0007A!b\u0001\n\u0003!\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B3\t\u0011E\u0004!Q1A\u0005\u0002ID\u0001b \u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\u000b\u0003\u0003\u0001!Q1A\u0005\u0002\u0005\r\u0001BCA\n\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!I1\u000b\u0001BC\u0002\u0013\u0005\u0011Q\u0003\u0005\u000b\u0003C\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u0012\u0001\t\u0015\r\u0011\"\u0001\u0002&!Q\u00111\t\u0001\u0003\u0002\u0003\u0006I!a\n\t\u0015\u0005\u0015\u0003A!b\u0001\n\u0003\t9\u0005\u0003\u0006\u0002f\u0001\u0011\t\u0011)A\u0005\u0003\u0013Bq!a\u001a\u0001\t\u0003\tI\u0007C\u0005\u0002~\u0001\u0011\r\u0011\"\u0001\u0002\u0000!A\u0011Q\u0012\u0001!\u0002\u0013\t\t\tC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0001\u0002\u0012\"A\u0011\u0011\u0014\u0001!\u0002\u0013\t\u0019\nC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0001\u0002\u001e\"I\u0011Q\u0017\u0001A\u0002\u0013\u0005\u0011q\u0017\u0005\t\u0003\u0007\u0004\u0001\u0015)\u0003\u0002 \"I\u0011Q\u0019\u0001A\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003\u001f\u0004\u0001\u0019!C\u0001\u0003#D\u0001\"!6\u0001A\u0003&\u0011\u0011\u001a\u0005\n\u0003/\u0004\u0001\u0019!C\u0001\u00033D\u0011\"!;\u0001\u0001\u0004%\t!a;\t\u0011\u0005=\b\u0001)Q\u0005\u00037D\u0011\"!=\u0001\u0001\u0004%\t!a=\t\u0013\t5\u0001\u00011A\u0005\u0002\t=\u0001\u0002\u0003B\n\u0001\u0001\u0006K!!>\t\u0013\tU\u0001\u00011A\u0005\u0002\t]\u0001\"\u0003B\u0012\u0001\u0001\u0007I\u0011\u0001B\u0013\u0011!\u0011I\u0003\u0001Q!\n\te\u0001\"\u0003B\u0016\u0001\u0001\u0007I\u0011\u0001B\u0017\u0011%\u0011Y\u0004\u0001a\u0001\n\u0003\u0011i\u0004\u0003\u0005\u0003B\u0001\u0001\u000b\u0015\u0002B\u0018\u0011%\u0011\u0019\u0005\u0001b\u0001\n\u0003\u0011)\u0005\u0003\u0005\u0003V\u0001\u0001\u000b\u0011\u0002B$\u0011%\u00119\u0006\u0001a\u0001\n\u0003\u0011I\u0006C\u0005\u0003f\u0001\u0001\r\u0011\"\u0001\u0003h!A!1\u000e\u0001!B\u0013\u0011Y\u0006C\u0005\u0003n\u0001\u0011\r\u0011\"\u0001\u0003p!A!Q\u0010\u0001!\u0002\u0013\u0011\t\bC\u0005\u0003\u0000\u0001\u0001\r\u0011\"\u0001\u0003\u0002\"I!\u0011\u0013\u0001A\u0002\u0013\u0005!1\u0013\u0005\t\u0005/\u0003\u0001\u0015)\u0003\u0003\u0004\"I!\u0011\u0014\u0001A\u0002\u0013\u0005!1\u0014\u0005\n\u0005G\u0003\u0001\u0019!C\u0001\u0005KC\u0001B!+\u0001A\u0003&!Q\u0014\u0005\n\u0005W\u0003\u0001\u0019!C\u0001\u0005[C\u0011B!.\u0001\u0001\u0004%\tAa.\t\u0011\tm\u0006\u0001)Q\u0005\u0005_CqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003P\u0002!\tA!5\t\u000f\tM\u0007\u0001\"\u0001\u0003V\"9!q\u001b\u0001\u0005\u0002\tU\u0007b\u0002Bm\u0001\u0011\u0005!Q\u001b\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJT!a\u0010!\u0002\rM,'O^3s\u0015\u0005\t\u0015!B6bM.\f7\u0001A\n\u0005\u0001\u0011S\u0005\u000b\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u0002\u000bQ!\u001e;jYNL!a\u0014'\u0003\u000f1{wmZ5oOB\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bQ\u0001\b[\u0016$(/[2t\u0013\t)&KA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fa\"\\3uCB\u0013x\u000e]3si&,7/F\u0001Y!\tI&,D\u0001?\u0013\tYfH\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0002\u001f5,G/\u0019)s_B,'\u000f^5fg\u0002\naaY8oM&<W#A0\u0011\u0005e\u0003\u0017BA1?\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005qQ.\u001a;b\u0019><W*\u00198bO\u0016\u0014X#A3\u0011\u0005\u0019tW\"A4\u000b\u0005!L\u0017aB7fi\u0006dwn\u001a\u0006\u0003\u0003*T!a\u001b7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0017aA8sO&\u0011qn\u001a\u0002\u000f\u001b\u0016$\u0018\rT8h\u001b\u0006t\u0017mZ3s\u0003=iW\r^1M_\u001el\u0015M\\1hKJ\u0004\u0013a\u0003:bMRl\u0015M\\1hKJ,\u0012a\u001d\t\u0004i^LX\"A;\u000b\u0005Y\u0004\u0015\u0001\u0002:bMRL!\u0001_;\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0003uvl\u0011a\u001f\u0006\u0003y&\f\u0001\"\\3uC\u0012\fG/Y\u0005\u0003}n\u0014A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017\u0001\u0004:bMRl\u0015M\\1hKJ\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0002\u0011\t\u0005\u001d\u0011qB\u0007\u0003\u0003\u0013Q1!TA\u0006\u0015\r\ti![\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0011\u0011\u0002\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u000f\u001b\t\tYBC\u0002T\u0003\u0017IA!a\b\u0002\u001c\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DXCAA\u0014!\u0015)\u0015\u0011FA\u0017\u0013\r\tYC\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0012Q\b\b\u0005\u0003c\tI\u0004E\u0002\u00024\u0019k!!!\u000e\u000b\u0007\u0005]\")\u0001\u0004=e>|GOP\u0005\u0004\u0003w1\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0005\u0005#AB*ue&twMC\u0002\u0002<\u0019\u000b\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003q\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016,\"!!\u0013\u0011\r\u0005-\u0013\u0011LA/\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013AC2p]\u000e,(O]3oi*!\u00111KA+\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0017\u0002N\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\r\u0005}\u0013\u0011MA\u0017\u001b\t\t\t&\u0003\u0003\u0002d\u0005E#\u0001\u0002'jgR\fQdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005-\u0014QNA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141\u0010\t\u00033\u0002AQAV\tA\u0002aCQ!X\tA\u0002}CQaY\tA\u0002\u0015DQ!]\tA\u0002MDq!!\u0001\u0012\u0001\u0004\t)\u0001\u0003\u0004T#\u0001\u0007\u0011q\u0003\u0005\b\u0003G\t\u0002\u0019AA\u0014\u0011\u001d\t)%\u0005a\u0001\u0003\u0013\nA\u0001\\8dWV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA'\u0003\u0015awnY6t\u0013\u0011\tY)!\"\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003E\tw/Y5u'\",H\u000fZ8x]\u000e{g\u000eZ\u000b\u0003\u0003'\u0003B!a!\u0002\u0016&!\u0011qSAC\u0005%\u0019uN\u001c3ji&|g.\u0001\nbo\u0006LGo\u00155vi\u0012|wO\\\"p]\u0012\u0004\u0013AB:uCR,8/\u0006\u0002\u0002 B!\u0011\u0011UAX\u001d\u0011\t\u0019+a+\u000f\t\u0005\u0015\u0016\u0011\u0016\b\u0005\u0003g\t9+C\u0001B\u0013\ty\u0004)C\u0002\u0002.z\naaU3sm\u0016\u0014\u0018\u0002BAY\u0003g\u0013Q\u0002\u0015:pG\u0016\u001c8o\u0015;biV\u001c(bAAW}\u0005Q1\u000f^1ukN|F%Z9\u0015\t\u0005e\u0016q\u0018\t\u0004\u000b\u0006m\u0016bAA_\r\n!QK\\5u\u0011%\t\tmFA\u0001\u0002\u0004\ty*A\u0002yIE\nqa\u001d;biV\u001c\b%A\fmS:,\b0S8NKR\u0014\u0018nY:D_2dWm\u0019;peV\u0011\u0011\u0011\u001a\t\u0004#\u0006-\u0017bAAg%\n9B*\u001b8vq&{W*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN]\u0001\u001cY&tW\u000f_%p\u001b\u0016$(/[2t\u0007>dG.Z2u_J|F%Z9\u0015\t\u0005e\u00161\u001b\u0005\n\u0003\u0003T\u0012\u0011!a\u0001\u0003\u0013\f\u0001\u0004\\5okbLu.T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:!\u0003)\tW\u000f\u001e5pe&TXM]\u000b\u0003\u00037\u0004R!RA\u0015\u0003;\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0005\u0003/\f\u0019O\u0003\u0002@S&!\u0011q]Aq\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u000fCV$\bn\u001c:ju\u0016\u0014x\fJ3r)\u0011\tI,!<\t\u0013\u0005\u0005W$!AA\u0002\u0005m\u0017aC1vi\"|'/\u001b>fe\u0002\n!\u0002^8lK:\u001c\u0015m\u00195f+\t\t)\u0010\u0005\u0003\u0002x\n%QBAA}\u0015\u0011\tY0!@\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BA\u0000\u0005\u0003\t!\u0002Z3mK\u001e\fG/[8o\u0015\u0011\u0011\u0019A!\u0002\u0002\u000bQ|7.\u001a8\u000b\t\t\u001d\u00111B\u0001\tg\u0016\u001cWO]5us&!!1BA}\u0005Q!U\r\\3hCRLwN\u001c+pW\u0016t7)Y2iK\u0006qAo\\6f]\u000e\u000b7\r[3`I\u0015\fH\u0003BA]\u0005#A\u0011\"!1!\u0003\u0003\u0005\r!!>\u0002\u0017Q|7.\u001a8DC\u000eDW\rI\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0006\u0002\u0003\u001aA!!1\u0004B\u0010\u001b\t\u0011iBC\u0002\u0003\b\u0001KAA!\t\u0003\u001e\t\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003Y\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:`I\u0015\fH\u0003BA]\u0005OA\u0011\"!1$\u0003\u0003\u0005\rA!\u0007\u0002'\r\u0014X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\u0011\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0016\u0005\t=\u0002\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\u0007\tU\u0002)A\u0004oKR<xN]6\n\t\te\"1\u0007\u0002\r'>\u001c7.\u001a;TKJ4XM]\u0001\u0011g>\u001c7.\u001a;TKJ4XM]0%KF$B!!/\u0003@!I\u0011\u0011\u0019\u0014\u0002\u0002\u0003\u0007!qF\u0001\u000eg>\u001c7.\u001a;TKJ4XM\u001d\u0011\u0002AM|7m[3u'\u0016\u0014h/\u001a:GSJ\u001cHOQ8v]\u0012\u0004vN\u001d;GkR,(/Z\u000b\u0003\u0005\u000f\u0002b!a\u0013\u0002Z\t%\u0003\u0003\u0002B&\u0005#j!A!\u0014\u000b\t\t=\u0013QK\u0001\u0005Y\u0006tw-\u0003\u0003\u0003T\t5#aB%oi\u0016<WM]\u0001\"g>\u001c7.\u001a;TKJ4XM\u001d$jeN$(i\\;oIB{'\u000f\u001e$viV\u0014X\rI\u0001\u000bG>tGO]8mY\u0016\u0014XC\u0001B.!\u0011\u0011iF!\u0019\u000e\u0005\t}#b\u0001B,S&!!1\rB0\u0005)\u0019uN\u001c;s_2dWM]\u0001\u000fG>tGO]8mY\u0016\u0014x\fJ3r)\u0011\tIL!\u001b\t\u0013\u0005\u00057&!AA\u0002\tm\u0013aC2p]R\u0014x\u000e\u001c7fe\u0002\n\u0011c];qa>\u0014H/\u001a3GK\u0006$XO]3t+\t\u0011\t\b\u0005\u0005\u00020\tM\u0014Q\u0006B<\u0013\u0011\u0011)(!\u0011\u0003\u00075\u000b\u0007\u000fE\u0002{\u0005sJ1Aa\u001f|\u000511VM]:j_:\u0014\u0016M\\4f\u0003I\u0019X\u000f\u001d9peR,GMR3biV\u0014Xm\u001d\u0011\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\t\u0011\u0019\t\u0005\u0003\u0003\u0006\n-e\u0002BAR\u0005\u000fK1A!#?\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\u0011\u0011iIa$\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\r\u0011IIP\u0001\u0012cV|G/Y'b]\u0006<WM]:`I\u0015\fH\u0003BA]\u0005+C\u0011\"!11\u0003\u0003\u0005\rAa!\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA\u0005q1m\u001c8ue>dG.\u001a:Ba&\u001cXC\u0001BO!\rI&qT\u0005\u0004\u0005Cs$AD\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n]\u0001\u0013G>tGO]8mY\u0016\u0014\u0018\t]5t?\u0012*\u0017\u000f\u0006\u0003\u0002:\n\u001d\u0006\"CAag\u0005\u0005\t\u0019\u0001BO\u0003=\u0019wN\u001c;s_2dWM]!qSN\u0004\u0013!G2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d%b]\u0012dWM\u001d)p_2,\"Aa,\u0011\u0007e\u0013\t,C\u0002\u00034z\u0012qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u0002;\r|g\u000e\u001e:pY2,'/\u00119jg\"\u000bg\u000e\u001a7feB{w\u000e\\0%KF$B!!/\u0003:\"I\u0011\u0011\u0019\u001c\u0002\u0002\u0003\u0007!qV\u0001\u001bG>tGO]8mY\u0016\u0014\u0018\t]5t\u0011\u0006tG\r\\3s!>|G\u000eI\u0001\u0012[\u0006L(-Z\"iC:<Wm\u0015;biV\u001cHC\u0002Ba\u0005\u000f\u0014Y\rE\u0002F\u0005\u0007L1A!2G\u0005\u001d\u0011un\u001c7fC:DqA!39\u0001\u0004\ty*\u0001\u0003ge>l\u0007b\u0002Bgq\u0001\u0007\u0011qT\u0001\u0003i>\f\u0011b\u00197vgR,'/\u00133\u0016\u0005\u00055\u0012aB:uCJ$X\u000f\u001d\u000b\u0003\u0003s\u000b\u0001b\u001d5vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8")
public class ControllerServer
implements KafkaMetricsGroup {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final MetaLogManager metaLogManager;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final Time time;
    private final Metrics metrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<List<String>> controllerQuorumVotersFuture;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Controller controller;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaLogManager metaLogManager() {
        return this.metaLogManager;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<List<String>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block8: {
            boolean bl;
            block7: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block7;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                    } else if (processStatus2.equals(server$SHUTDOWN$)) {
                        this.awaitShutdownCond().signalAll();
                    }
                    break block8;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    public String clusterId() {
        return this.metaProperties().clusterId().toString();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        try {
            scala.collection.immutable.Map map;
            this.info((Function0<String>)(Function0 & Serializable)() -> "Starting controller");
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.newGauge("ClusterId", new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    ControllerServer controllerServer = this.$outer;
                    if (controllerServer == null) {
                        throw null;
                    }
                    return controllerServer.clusterId();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.newGauge("yammer-metrics-count", new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.newGauge("linux-disk-read-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
                this.newGauge("linux-disk-write-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
            }
            List javaListeners = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.config().controllerListeners().map((Function1 & Serializable)x$1 -> x$1.toJava())).asJava();
            this.authorizer_$eq(this.config().authorizer());
            this.authorizer().foreach((Function1 & Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0));
                map = CollectionConverters$.MODULE$.MapHasAsScala(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        Endpoint ep = (Endpoint)x0$1._1();
                        CompletionStage cs = (CompletionStage)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else if (None$.MODULE$.equals(option)) {
                map = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(javaListeners).asScala().map((Function1 & Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            } else {
                throw new MatchError(option);
            }
            scala.collection.immutable.Map authorizerFutures = map;
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER);
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            this.socketServer().startup(false, (Option<EndPoint>)None$.MODULE$, this.config().controllerListeners());
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            java.util.Map configDefs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.BROKER), (Object)KafkaConfig$.MODULE$.configDef()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.TOPIC), (Object)LogConfig$.MODULE$.configDefCopy())}))).asJava();
            String threadNamePrefixAsString = (String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "");
            this.controller_$eq((Controller)new QuorumController.Builder(this.config().nodeId()).setTime(this.time()).setThreadNamePrefix(threadNamePrefixAsString).setConfigDefs(configDefs).setLogManager(this.metaLogManager()).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setMetrics((ControllerMetrics)new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry())).build());
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), (String)this.threadNamePrefix().getOrElse((Function0 & Serializable)() -> "")));
            Buffer controllerNodes = CollectionConverters$.MODULE$.ListHasAsScala(RaftConfig.quorumVoterStringsToNodes(this.controllerQuorumVotersFuture().get())).asScala();
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.supportedFeatures(), this.controller(), this.raftManager(), this.config(), this.metaProperties(), (scala.collection.immutable.Seq<Node>)controllerNodes.toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(SocketServer$.MODULE$.DataPlaneMetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), SocketServer$.MODULE$.DataPlaneThreadPrefix()));
            this.socketServer().startProcessingRequests((Map<Endpoint, CompletableFuture<Void>>)authorizerFutures);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller startup. Prepare to shutdown", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().stopProcessingRequests(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.socketServer().shutdown(), this, Level.WARN);
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, Level.WARN);
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.quotaManagers().shutdown(), this, Level.WARN);
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null || !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public ControllerServer(MetaProperties metaProperties, KafkaConfig config, MetaLogManager metaLogManager, RaftManager<ApiMessageAndVersion> raftManager, Time time, Metrics metrics, Option<String> threadNamePrefix, CompletableFuture<List<String>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.metaLogManager = metaLogManager;
        this.raftManager = raftManager;
        this.time = time;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.linuxIoMetricsCollector = null;
        this.authorizer = null;
        this.tokenCache = null;
        this.credentialProvider = null;
        this.socketServer = null;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.controller = null;
        this.supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.quotaManagers = null;
        this.controllerApis = null;
        this.controllerApisHandlerPool = null;
    }
}

