/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.AuthorizerWrapper$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t%t!B\r\u001b\u0011\u0003\tc!B\u0012\u001b\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0003q\u0003\"\u0002/\u0002\t\u0003i\u0006\"\u00023\u0002\t\u0003)\u0007\"\u00026\u0002\t\u0003Y\u0007\"\u00028\u0002\t\u0003yg!B\u0012\u001b\u0001\u0005\u0015\u0001bCA\u0013\u0011\t\u0015\r\u0011\"\u0001\u001f\u0003OA!\"!\f\t\u0005\u0003\u0005\u000b\u0011BA\u0015\u0011\u0019Y\u0003\u0002\"\u0001\u00020!I\u0011Q\u0007\u0005A\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u007fA\u0001\u0019!C\u0001\u0003\u0003B\u0001\"!\u0014\tA\u0003&\u0011\u0011\b\u0005\b\u0003\u001fBA\u0011IA)\u0011\u001d\tY\t\u0003C!\u0003\u001bCq!a0\t\t\u0003\n\t\rC\u0004\u0002f\"!\t%a:\t\u000f\t\u0015\u0001\u0002\"\u0011\u0003\b!9!Q\u0005\u0005\u0005B\t\u001d\u0002b\u0002B\u0019\u0011\u0011\u0005#1\u0007\u0005\b\u0005kAA\u0011\tB\u001c\u0011\u001d\u0011y\u0005\u0003C\u0005\u0005#BqA!\u0017\t\t\u0013\u0011Y&A\tBkRDwN]5{KJ<&/\u00199qKJT!a\u0007\u000f\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002\u001e=\u0005A1/Z2ve&$\u0018PC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AI\u0001\u000e\u0003i\u0011\u0011#Q;uQ>\u0014\u0018N_3s/J\f\u0007\u000f]3s'\t\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\nqcY8om\u0016\u0014H\u000fV8SKN|WO]2f\u0003:$\u0017i\u00197\u0015\u0005=\"\u0006\u0003\u0002\u00199w!s!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0013A\u0002\u001fs_>$h(C\u0001)\u0013\t9t%A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$AB#ji\",'O\u0003\u00028OA\u0011AHR\u0007\u0002{)\u0011ahP\u0001\te\u0016\fX/Z:ug*\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u0005}\u0011%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!aR\u001f\u0003\u0011\u0005\u0003\u0018.\u0012:s_J\u0004BAJ%L#&\u0011!j\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00051{U\"A'\u000b\u00059c\u0012\u0001B1vi\"L!\u0001U'\u0003\u0011I+7o\\;sG\u0016\u0004\"\u0001\u0014*\n\u0005Mk%aA!dY\")Qk\u0001a\u0001-\u00061a-\u001b7uKJ\u0004\"a\u0016.\u000e\u0003aS!!W \u0002\u0007\u0005\u001cG.\u0003\u0002\\1\n\u0001\u0012i\u00197CS:$\u0017N\\4GS2$XM]\u0001\u0014G>tg/\u001a:u)>\f5\r\u001c\"j]\u0012Lgn\u001a\u000b\u0004=\u0006\u001c\u0007CA,`\u0013\t\u0001\u0007L\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDQA\u0019\u0003A\u0002-\u000b\u0001B]3t_V\u00148-\u001a\u0005\u00063\u0012\u0001\r!U\u0001\u001cG>tg/\u001a:u)>\f5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\u0015\u0005\u0019L\u0007CA,h\u0013\tA\u0007L\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\b\"B-\u0006\u0001\u0004\t\u0016\u0001D2p]Z,'\u000f\u001e+p\u0003\u000edGCA)m\u0011\u0015ig\u00011\u0001g\u0003\r\t7-Z\u0001\u0012G>tg/\u001a:u)>\u0014Vm]8ve\u000e,GCA&q\u0011\u0015\tx\u00011\u0001s\u0003=\u0011Xm]8ve\u000e,\u0007+\u0019;uKJt\u0007CA:v\u001b\u0005!(B\u00012@\u0013\t1HOA\bSKN|WO]2f!\u0006$H/\u001a:oQ\u0019\t\u0001p\u001f?\u007f\u007fB\u0011a%_\u0005\u0003u\u001e\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f\u0013!`\u0001,+N,\u0007e[1gW\u0006t3/Z2ve&$\u0018PL1vi\"|'/\u001b>fe:\n5\r\\!vi\"|'/\u001b>fe\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011A\u0001\n'&t7-\u001a\u00113]UBc\u0001\u0001=|yz|8#\u0002\u0005\u0002\b\u0005]\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\u0011\t)\"a\u0003\u0003\r=\u0013'.Z2u!\u0011\tI\"!\t\u000e\u0005\u0005m!bA\u000e\u0002\u001e)\u0019\u0011qD!\u0002\rM,'O^3s\u0013\u0011\t\u0019#a\u0007\u0003\u0015\u0005+H\u000f[8sSj,'/\u0001\bcCN,\u0017)\u001e;i_JL'0\u001a:\u0016\u0005\u0005%\u0002c\u0001'\u0002,%\u0019\u00111E'\u0002\u001f\t\f7/Z!vi\"|'/\u001b>fe\u0002\"B!!\r\u00024A\u0011!\u0005\u0003\u0005\b\u0003KY\u0001\u0019AA\u0015\u0003\u0005\u001a\bn\\;mI\u0006cGn\\<Fm\u0016\u0014\u0018p\u001c8f\u0013\u001atu.Q2m\u0013N4u.\u001e8e+\t\tI\u0004E\u0002'\u0003wI1!!\u0010(\u0005\u001d\u0011un\u001c7fC:\fQe\u001d5pk2$\u0017\t\u001c7po\u00163XM]=p]\u0016LeMT8BG2L5OR8v]\u0012|F%Z9\u0015\t\u0005\r\u0013\u0011\n\t\u0004M\u0005\u0015\u0013bAA$O\t!QK\\5u\u0011%\tY%DA\u0001\u0002\u0004\tI$A\u0002yIE\n!e\u001d5pk2$\u0017\t\u001c7po\u00163XM]=p]\u0016LeMT8BG2L5OR8v]\u0012\u0004\u0013!C2p]\u001aLw-\u001e:f)\u0011\t\u0019%a\u0015\t\u000f\u0005Us\u00021\u0001\u0002X\u000591m\u001c8gS\u001e\u001c\b\u0007BA-\u0003s\u0002\u0002\"a\u0017\u0002b\u0005\u0015\u0014QO\u0007\u0003\u0003;RA!a\u0018\u0002\u0010\u0005!Q\u000f^5m\u0013\u0011\t\u0019'!\u0018\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002h\u0005=d\u0002BA5\u0003W\u0002\"AM\u0014\n\u0007\u00055t%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\n\u0019H\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[:\u0003\u0003BA<\u0003sb\u0001\u0001\u0002\u0007\u0002|\u0005M\u0013\u0011!A\u0001\u0006\u0003\tiHA\u0002`IE\nB!a \u0002\u0006B\u0019a%!!\n\u0007\u0005\ruEA\u0004O_RD\u0017N\\4\u0011\u0007\u0019\n9)C\u0002\u0002\n\u001e\u00121!\u00118z\u0003\u0015\u0019H/\u0019:u)\u0011\ty)!.1\t\u0005E\u0015Q\u0014\t\t\u00037\n\t'a%\u0002\u001cB!\u0011QSAL\u001b\u0005y\u0014bAAM\u007f\tAQI\u001c3q_&tG\u000f\u0005\u0003\u0002x\u0005uEaCAP!\u0005\u0005\t\u0011!B\u0001\u0003C\u00131a\u0018\u00133#\u0011\ty(a)\u0011\r\u0005\u0015\u00161VAX\u001b\t\t9K\u0003\u0003\u0002*\u0006u\u0013AC2p]\u000e,(O]3oi&!\u0011QVAT\u0005=\u0019u.\u001c9mKRLwN\\*uC\u001e,\u0007\u0003BA\u0005\u0003cKA!a-\u0002\f\t!ak\\5e\u0011\u001d\t9\f\u0005a\u0001\u0003s\u000b!b]3sm\u0016\u0014\u0018J\u001c4p!\u0011\tI\"a/\n\t\u0005u\u00161\u0004\u0002\u0015\u0003V$\bn\u001c:ju\u0016\u00148+\u001a:wKJLeNZ8\u0002\u0013\u0005,H\u000f[8sSj,GCBAb\u0003\u001f\fI\u000e\u0005\u0004\u0002\\\u0005\u0015\u0017\u0011Z\u0005\u0005\u0003\u000f\fiF\u0001\u0003MSN$\b\u0003BA\r\u0003\u0017LA!!4\u0002\u001c\t\u0019\u0012)\u001e;i_JL'0\u0019;j_:\u0014Vm];mi\"9\u0011\u0011[\tA\u0002\u0005M\u0017A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u00033\t).\u0003\u0003\u0002X\u0006m!AG!vi\"|'/\u001b>bE2,'+Z9vKN$8i\u001c8uKb$\bbBAn#\u0001\u0007\u0011Q\\\u0001\bC\u000e$\u0018n\u001c8t!\u0019\tY&!2\u0002`B!\u0011\u0011DAq\u0013\u0011\t\u0019/a\u0007\u0003\r\u0005\u001bG/[8o\u0003)\u0019'/Z1uK\u0006\u001bGn\u001d\u000b\u0007\u0003S\fi0a@1\t\u0005-\u0018q\u001e\t\u0007\u00037\n)-!<\u0011\t\u0005]\u0014q\u001e\u0003\f\u0003c\u0014\u0012\u0011!A\u0001\u0006\u0003\t\u0019PA\u0002`IM\nB!a \u0002vB1\u0011QUAV\u0003o\u0004B!!\u0007\u0002z&!\u00111`A\u000e\u0005=\t5\r\\\"sK\u0006$XMU3tk2$\bbBAi%\u0001\u0007\u00111\u001b\u0005\b\u0005\u0003\u0011\u0002\u0019\u0001B\u0002\u0003-\t7\r\u001c\"j]\u0012LgnZ:\u0011\u000b\u0005m\u0013Q\u00190\u0002\u0015\u0011,G.\u001a;f\u0003\u000ed7\u000f\u0006\u0004\u0003\n\tu!q\u0004\u0019\u0005\u0005\u0017\u0011y\u0001\u0005\u0004\u0002\\\u0005\u0015'Q\u0002\t\u0005\u0003o\u0012y\u0001B\u0006\u0003\u0012M\t\t\u0011!A\u0003\u0002\tM!aA0%iE!\u0011q\u0010B\u000b!\u0019\t)+a+\u0003\u0018A!\u0011\u0011\u0004B\r\u0013\u0011\u0011Y\"a\u0007\u0003\u001f\u0005\u001bG\u000eR3mKR,'+Z:vYRDq!!5\u0014\u0001\u0004\t\u0019\u000eC\u0004\u0003\"M\u0001\rAa\t\u0002#\u0005\u001cGNQ5oI&twMR5mi\u0016\u00148\u000fE\u0003\u0002\\\u0005\u0015g+\u0001\u0003bG2\u001cH\u0003\u0002B\u0015\u0005_\u0001R!!\u0003\u0003,yKAA!\f\u0002\f\tA\u0011\n^3sC\ndW\rC\u0003V)\u0001\u0007a+A\u0003dY>\u001cX\r\u0006\u0002\u0002D\u00059\u0012-\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/\u001a\u000b\t\u0003\u0013\u0014IDa\u000f\u0003F!9\u0011\u0011\u001b\fA\u0002\u0005M\u0007b\u0002B\u001f-\u0001\u0007!qH\u0001\u0003_B\u00042a\u0016B!\u0013\r\u0011\u0019\u0005\u0017\u0002\r\u0003\u000edw\n]3sCRLwN\u001c\u0005\b\u0005\u000f2\u0002\u0019\u0001B%\u00031\u0011Xm]8ve\u000e,G+\u001f9f!\r\u0019(1J\u0005\u0004\u0005\u001b\"(\u0001\u0004*fg>,(oY3UsB,\u0017a\u00043f]f\fE\u000e\u001c*fg>,(oY3\u0015\u0011\u0005e\"1\u000bB+\u0005/Bq!!5\u0018\u0001\u0004\t\u0019\u000eC\u0004\u0003>]\u0001\rAa\u0010\t\u000f\t\u001ds\u00031\u0001\u0003J\u0005\u0011\u0002O]5oG&\u0004\u0018\r\u001c%pgRl\u0015\r^2i)!\tID!\u0018\u0003`\t\r\u0004\"B7\u0019\u0001\u00041\u0007b\u0002B11\u0001\u0007\u0011QM\u0001\naJLgnY5qC2DqA!\u001a\u0019\u0001\u0004\t)'\u0001\u0003i_N$\bF\u0002\u0005ywrtx\u0010")
public class AuthorizerWrapper
implements org.apache.kafka.server.authorizer.Authorizer {
    private final Authorizer baseAuthorizer;
    private boolean shouldAllowEveryoneIfNoAclIsFound;

    public static Resource convertToResource(ResourcePattern resourcePattern) {
        return AuthorizerWrapper$.MODULE$.convertToResource(resourcePattern);
    }

    public static Acl convertToAcl(AccessControlEntry ace) {
        return AuthorizerWrapper$.MODULE$.convertToAcl(ace);
    }

    public static AccessControlEntry convertToAccessControlEntry(Acl acl) {
        return AuthorizerWrapper$.MODULE$.convertToAccessControlEntry(acl);
    }

    public static AclBinding convertToAclBinding(Resource resource, Acl acl) {
        return AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, acl);
    }

    public static Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter filter) {
        return AuthorizerWrapper$.MODULE$.convertToResourceAndAcl(filter);
    }

    public Authorizer baseAuthorizer() {
        return this.baseAuthorizer;
    }

    public boolean shouldAllowEveryoneIfNoAclIsFound() {
        return this.shouldAllowEveryoneIfNoAclIsFound;
    }

    public void shouldAllowEveryoneIfNoAclIsFound_$eq(boolean x$1) {
        this.shouldAllowEveryoneIfNoAclIsFound = x$1;
    }

    public void configure(java.util.Map<String, ?> configs) {
        this.baseAuthorizer().configure(configs);
        this.shouldAllowEveryoneIfNoAclIsFound_$eq(CollectionConverters$.MODULE$.MapHasAsScala(configs).asScala().get((Object)AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$2.toString())))) && this.baseAuthorizer() instanceof SimpleAclAuthorizer);
    }

    public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(serverInfo.endpoints()).asScala().map((Function1 & Serializable)endpoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endpoint), CompletableFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        RequestChannel.Session session = new RequestChannel.Session(requestContext.principal(), requestContext.clientAddress());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(actions).asScala().map((Function1 & Serializable)action -> {
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            if (this.baseAuthorizer().authorize(session, operation, AuthorizerWrapper$.MODULE$.convertToResource(action.resourcePattern()))) {
                return AuthorizationResult.ALLOWED;
            }
            return AuthorizationResult.DENIED;
        })).asJava();
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aclBindings).asScala().map((Function1 & Serializable)aclBinding -> {
            Tuple2 tuple2;
            Either<ApiError, Tuple2<Resource, Acl>> either = AuthorizerWrapper$.MODULE$.convertToResourceAndAcl(aclBinding.toFilter());
            if (either instanceof Left) {
                ApiError apiError = (ApiError)((Left)either).value();
                return new AclCreateResult(apiError.exception());
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                Resource resource = (Resource)tuple2._1();
                Acl acl = (Acl)tuple2._2();
                try {
                    this.baseAuthorizer().addAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Acl[]{acl}))), resource);
                    return AclCreateResult.SUCCESS;
                }
                catch (ApiException e) {
                    return new AclCreateResult(e);
                }
                catch (Throwable e) {
                    return new AclCreateResult((ApiException)((Object)((Object)((Object)new InvalidRequestException("Failed to create ACL", e)))));
                }
            }
            throw new MatchError(either);
        })).toList().map((Function1 & Serializable)x$1 -> CompletableFuture.completedFuture(x$1))).asJava();
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        Buffer filters = CollectionConverters$.MODULE$.ListHasAsScala(aclBindingFilters).asScala();
        scala.collection.mutable.Map results = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map toDelete = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        if (filters.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matchesAtMostOne()))) {
            ((IterableOps)filters.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                if (x$4 != null) {
                    AclBindingFilter filter = (AclBindingFilter)x$4._1();
                    int i = x$4._2$mcI$sp();
                    Either<ApiError, Tuple2<Resource, Acl>> either = AuthorizerWrapper$.MODULE$.convertToResourceAndAcl(filter);
                    if (either instanceof Left) {
                        ApiError apiError = (ApiError)((Left)either).value();
                        return results.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new AclDeleteResult(apiError.exception()));
                    }
                    if (either instanceof Right) {
                        Tuple2 binding = (Tuple2)((Right)either).value();
                        return toDelete.put((Object)BoxesRunTime.boxToInteger((int)i), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{binding})));
                    }
                    throw new MatchError(either);
                }
                throw new MatchError(null);
            });
        } else {
            scala.collection.immutable.Map<Resource, Set<Acl>> aclMap = this.baseAuthorizer().getAcls();
            Buffer filtersWithIndex = (Buffer)filters.zipWithIndex();
            aclMap.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$4(check$ifrefutable$2))).foreach((Function1 & Serializable)x$7 -> {
                AuthorizerWrapper.$anonfun$deleteAcls$5(filtersWithIndex, toDelete, x$7);
                return BoxedUnit.UNIT;
            });
        }
        toDelete.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$11(check$ifrefutable$4))).foreach((Function1 & Serializable)x$8 -> {
            if (x$8 != null) {
                int i = x$8._1$mcI$sp();
                ArrayBuffer acls = (ArrayBuffer)x$8._2();
                List deletionResults = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)acls.flatMap((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        Some some;
                        Resource resource = (Resource)x0$1._1();
                        Acl acl = (Acl)x0$1._2();
                        AclBinding aclBinding = AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, acl);
                        try {
                            if (!this.baseAuthorizer().removeAcls((Set<Acl>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Acl[]{acl}))), resource)) {
                                return None$.MODULE$;
                            }
                            some = new Some((Object)new AclDeleteResult.AclBindingDeleteResult(aclBinding));
                        }
                        catch (Throwable throwable) {
                            some = new Some((Object)new AclDeleteResult.AclBindingDeleteResult(aclBinding, ApiError.fromThrowable((Throwable)throwable).exception()));
                        }
                        return some;
                    }
                    throw new MatchError(null);
                })).asJava();
                return results.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new AclDeleteResult((Collection)deletionResults));
            }
            throw new MatchError(null);
        });
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)filters.indices().map((Function1 & Serializable)i -> AuthorizerWrapper.$anonfun$deleteAcls$14(results, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$1 -> CompletableFuture.completedFuture(x$1))).asJava();
    }

    public java.lang.Iterable<AclBinding> acls(AclBindingFilter filter) {
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)this.baseAuthorizer().getAcls().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Resource resource = (Resource)x0$1._1();
                return (Set)((IterableOps)((Set)x0$1._2()).map((Function1 & Serializable)acl -> AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, (Acl)acl))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)));
            }
            throw new MatchError(null);
        })).asJava();
    }

    public void close() {
        this.baseAuthorizer().close();
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        SecurityUtils.authorizeByResourceTypeCheckArgs((AclOperation)op, (ResourceType)resourceType);
        AuthorizationResult authorizationResult = super.authorizeByResourceType(requestContext, op, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        if (!(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null)) {
            return AuthorizationResult.ALLOWED;
        }
        if (this.denyAllResource(requestContext, op, resourceType) || !this.shouldAllowEveryoneIfNoAclIsFound()) {
            return AuthorizationResult.DENIED;
        }
        return AuthorizationResult.ALLOWED;
    }

    private boolean denyAllResource(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        ResourcePatternFilter resourceTypeFilter = new ResourcePatternFilter(resourceType, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL);
        String principal = new KafkaPrincipal(requestContext.principal().getPrincipalType(), requestContext.principal().getName()).toString();
        String host = requestContext.clientAddress().getHostAddress();
        AccessControlEntryFilter entryFilter = new AccessControlEntryFilter(null, null, op, AclPermissionType.DENY);
        AccessControlEntryFilter entryFilterAllOp = new AccessControlEntryFilter(null, null, AclOperation.ALL, AclPermissionType.DENY);
        AclBindingFilter aclFilter = new AclBindingFilter(resourceTypeFilter, entryFilter);
        AclBindingFilter aclFilterAllOp = new AclBindingFilter(resourceTypeFilter, entryFilterAllOp);
        return CollectionConverters$.MODULE$.IterableHasAsScala(this.acls(aclFilter)).asScala().exists((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)this.principalHostMatch(b.entry(), principal, host))) || CollectionConverters$.MODULE$.IterableHasAsScala(this.acls(aclFilterAllOp)).asScala().exists((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)this.principalHostMatch(b.entry(), principal, host)));
    }

    private boolean principalHostMatch(AccessControlEntry ace, String principal, String host) {
        block3: {
            block4: {
                block2: {
                    String string = ace.host();
                    String string2 = AclEntry$.MODULE$.WildcardHost();
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = ace.host();
                    if (string3 != null ? !string3.equals(host) : host != null) break block3;
                }
                String string = ace.principal();
                String string4 = AclEntry$.MODULE$.WildcardPrincipalString();
                if (!(string == null ? string4 != null : !string.equals(string4))) break block4;
                String string5 = ace.principal();
                if (string5 != null ? !string5.equals(principal) : principal != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$4(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$7(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$8(AclBinding binding$1, Tuple2 x$5) {
        if (x$5 != null) {
            return ((AclBindingFilter)x$5._1()).matches(binding$1);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$6(Resource resource$1, Buffer filtersWithIndex$1, scala.collection.mutable.Map toDelete$1, Acl acl) {
        AclBinding binding = new AclBinding(new ResourcePattern(resource$1.resourceType().toJava(), resource$1.name(), resource$1.patternType()), new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava()));
        filtersWithIndex$1.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$7(check$ifrefutable$3))).withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$8(binding, x$5))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                int i = x$6._2$mcI$sp();
                return (ArrayBuffer)((Growable)toDelete$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty())).$plus$eq((Object)new Tuple2((Object)resource$1, (Object)acl));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$5(Buffer filtersWithIndex$1, scala.collection.mutable.Map toDelete$1, Tuple2 x$7) {
        if (x$7 != null) {
            Resource resource = (Resource)x$7._1();
            ((Set)x$7._2()).foreach((Function1 & Serializable)acl -> {
                AuthorizerWrapper.$anonfun$deleteAcls$6(resource, filtersWithIndex$1, toDelete$1, acl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$11(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ AclDeleteResult $anonfun$deleteAcls$14(scala.collection.mutable.Map results$1, int i) {
        return (AclDeleteResult)results$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable)() -> new AclDeleteResult((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()));
    }

    public AuthorizerWrapper(Authorizer baseAuthorizer) {
        this.baseAuthorizer = baseAuthorizer;
        this.shouldAllowEveryoneIfNoAclIsFound = false;
    }
}

