/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaServer$ {
    public static final KafkaServer$ MODULE$ = new KafkaServer$();
    private static final long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS = 120000L;

    public Time $lessinit$greater$default$2() {
        return Time.SYSTEM;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Seq<KafkaMetricsReporter> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> copyKafkaConfigToLog(KafkaConfig kafkaConfig) {
        void var2_2;
        HashMap<String, Object> logProps = new HashMap<String, Object>();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), kafkaConfig.logSegmentBytes());
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), kafkaConfig.logRollTimeMillis());
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), kafkaConfig.logRollTimeJitterMillis());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), kafkaConfig.logIndexSizeMaxBytes());
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), kafkaConfig.logFlushIntervalMessages());
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), kafkaConfig.logFlushIntervalMs());
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), kafkaConfig.logRetentionBytes());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), kafkaConfig.logRetentionTimeMillis());
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), kafkaConfig.messageMaxBytes());
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), kafkaConfig.logIndexIntervalBytes());
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), kafkaConfig.logCleanerDeleteRetentionMs());
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), kafkaConfig.logCleanerMinCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), kafkaConfig.logCleanerMaxCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), kafkaConfig.logDeleteDelayMs());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), kafkaConfig.logCleanerMinCleanRatio());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), kafkaConfig.logCleanupPolicy());
        logProps.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), kafkaConfig.minInSyncReplicas());
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), kafkaConfig.compressionType());
        logProps.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), kafkaConfig.uncleanLeaderElectionEnable());
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), kafkaConfig.logPreAllocateEnable());
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), kafkaConfig.logMessageFormatVersion().version());
        logProps.put(LogConfig$.MODULE$.MessageTimestampTypeProp(), kafkaConfig.logMessageTimestampType().name);
        logProps.put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), kafkaConfig.logMessageTimestampDifferenceMaxMs());
        logProps.put(LogConfig$.MODULE$.MessageDownConversionEnableProp(), kafkaConfig.logMessageDownConversionEnable());
        return var2_2;
    }

    public MetricConfig metricConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(BoxesRunTime.unboxToInt((Object)kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(BoxesRunTime.unboxToLong((Object)kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public Option<ZKClientConfig> zkClientConfigFromKafkaConfig(KafkaConfig config, boolean forceZkSslClientEnable) {
        if (!config.zkSslClientEnable() && !forceZkSslClientEnable) {
            return None$.MODULE$;
        }
        ZKClientConfig clientConfig = new ZKClientConfig();
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "true");
        Option<String> option = config.zkClientCnxnSocketClassName();
        if (option == null) {
            throw null;
        }
        Option<String> foreach_this = option;
        if (!foreach_this.isEmpty()) {
            String string = (String)foreach_this.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), string);
        }
        Object var4_4 = null;
        Option<String> option2 = config.zkSslKeyStoreLocation();
        if (option2 == null) {
            throw null;
        }
        Option<String> foreach_this2 = option2;
        if (!foreach_this2.isEmpty()) {
            String string = (String)foreach_this2.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), string);
        }
        Object var5_6 = null;
        Option<Password> option3 = config.zkSslKeyStorePassword();
        if (option3 == null) {
            throw null;
        }
        Option<Password> foreach_this3 = option3;
        if (!foreach_this3.isEmpty()) {
            Password password = (Password)foreach_this3.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), password.value());
        }
        Object var6_8 = null;
        Option<String> option4 = config.zkSslKeyStoreType();
        if (option4 == null) {
            throw null;
        }
        Option<String> foreach_this4 = option4;
        if (!foreach_this4.isEmpty()) {
            String string = (String)foreach_this4.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), string);
        }
        Object var7_10 = null;
        Option<String> option5 = config.zkSslTrustStoreLocation();
        if (option5 == null) {
            throw null;
        }
        Option<String> foreach_this5 = option5;
        if (!foreach_this5.isEmpty()) {
            String string = (String)foreach_this5.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), string);
        }
        Object var8_12 = null;
        Option<Password> option6 = config.zkSslTrustStorePassword();
        if (option6 == null) {
            throw null;
        }
        Option<Password> foreach_this6 = option6;
        if (!foreach_this6.isEmpty()) {
            Password password = (Password)foreach_this6.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), password.value());
        }
        Object var9_14 = null;
        Option<String> option7 = config.zkSslTrustStoreType();
        if (option7 == null) {
            throw null;
        }
        Option<String> foreach_this7 = option7;
        if (!foreach_this7.isEmpty()) {
            String string = (String)foreach_this7.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), string);
        }
        Object var10_16 = null;
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslProtocolProp(), config.ZkSslProtocol());
        Option<List<String>> option8 = config.ZkSslEnabledProtocols();
        if (option8 == null) {
            throw null;
        }
        Option<List<String>> foreach_this8 = option8;
        if (!foreach_this8.isEmpty()) {
            List list = (List)foreach_this8.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), list);
        }
        Object var11_18 = null;
        Option<List<String>> option9 = config.ZkSslCipherSuites();
        if (option9 == null) {
            throw null;
        }
        Option<List<String>> foreach_this9 = option9;
        if (!foreach_this9.isEmpty()) {
            List list = (List)foreach_this9.get();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), list);
        }
        Object var12_20 = null;
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp(), config.ZkSslEndpointIdentificationAlgorithm());
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCrlEnableProp(), ((Object)config.ZkSslCrlEnable()).toString());
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslOcspEnableProp(), ((Object)config.ZkSslOcspEnable()).toString());
        return new Some((Object)clientConfig);
    }

    public boolean zkClientConfigFromKafkaConfig$default$2() {
        return false;
    }

    public long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS() {
        return MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    }

    private KafkaServer$() {
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$1$adapted(ZKClientConfig clientConfig$1, String x$1) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$2$adapted(ZKClientConfig clientConfig$1, String x$2) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), x$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$3$adapted(ZKClientConfig clientConfig$1, Password x) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), x.value());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$4$adapted(ZKClientConfig clientConfig$1, String x$3) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), x$3);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$5$adapted(ZKClientConfig clientConfig$1, String x$4) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), x$4);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$6$adapted(ZKClientConfig clientConfig$1, Password x) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), x.value());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$7$adapted(ZKClientConfig clientConfig$1, String x$5) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), x$5);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$8$adapted(ZKClientConfig clientConfig$1, List x$6) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), x$6);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$zkClientConfigFromKafkaConfig$9$adapted(ZKClientConfig clientConfig$1, List x$7) {
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig$1, KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), x$7);
        return BoxedUnit.UNIT;
    }
}

