/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005y4Qa\u0003\u0007\u0002\u0002EA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006Y\u0001!\t\u0001\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006[\u0001!\t!\u0016\u0005\u0006A\u0002!I!\u0019\u0005\u0006O\u0002!I\u0001\u000b\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006Q\u00021\ta\u001d\u0002\u0016!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0015\tia\"\u0001\u0006d_:$(o\u001c7mKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mq\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\t\u0001\u0013%D\u0001\r\u0013\t\u0011CBA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fa\u0001P5oSRtDCA\u0013'!\t\u0001\u0003\u0001C\u0003\u001f\u0005\u0001\u0007q$A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003%\u0002\"a\u0005\u0016\n\u0005-\"\"\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\"iJLwmZ3s\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]N#\u0018\r^3DQ\u0006tw-\u001a\u000b\u0002_A!\u0001gM\u001bA\u001b\u0005\t$B\u0001\u001a\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003iE\u00121!T1q!\t1d(D\u00018\u0015\tA\u0014(\u0001\u0004d_6lwN\u001c\u0006\u0003\u001fiR!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO&\u0011qh\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t\u0015\nT(\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#\u0011\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002I)\u00059\u0001/Y2lC\u001e,\u0017B\u0001&L\u0005\u0019)\u0015\u000e\u001e5fe*\u0011\u0001\n\u0006\t\u0003\u00036K!AT&\u0003\u0013QC'o\\<bE2,\u0007C\u0001)T\u001b\u0005\t&B\u0001*\u000f\u0003\r\t\u0007/[\u0005\u0003)F\u0013A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJ$\"!\u000b,\t\u000b]3\u0001\u0019\u0001-\u0002\u000bQ|\u0007/[2\u0011\u0005ekfB\u0001.\\!\t\u0019E#\u0003\u0002])\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\taF#A\u0013ue&<w-\u001a:P]2Lg.Z*uCR,7\t[1oO\u00164uN\u001d)beRLG/[8ogR\u0011qF\u0019\u0005\u0006G\u001e\u0001\r\u0001Z\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bc\u0001\u0019fk%\u0011a-\r\u0002\u0004'\u0016$\u0018\u0001G5oSRL\u0017\r\\5{KB\u000b'\u000f^5uS>t7\u000b^1uK\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\ry#N\u001c\u0005\u0006G&\u0001\ra\u001b\t\u0004a1,\u0014BA72\u0005\r\u0019V-\u001d\u0005\u0006_&\u0001\r\u0001]\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\r\u0005\u0002!c&\u0011!\u000f\u0004\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011yC/\u001e<\t\u000b\rT\u0001\u0019A6\t\u000b=T\u0001\u0019\u00019\t\u000b]T\u0001\u0019\u0001=\u0002-1,\u0017\rZ3s\u000b2,7\r^5p]N#(/\u0019;fOf\u00042aE=|\u0013\tQHC\u0001\u0004PaRLwN\u001c\t\u0003AqL!! \u0007\u0003?A\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u0017\u0010")
public abstract class PartitionStateMachine
implements Logging {
    private final ControllerContext controllerContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Initializing partition state");
        this.initializePartitionState();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Triggering online partition state changes");
        this.triggerOnlinePartitionStateChange();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Started partition state machine with initial state -> ").append($this.controllerContext.partitionStates()).toString());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped partition state machine");
    }

    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> triggerOnlinePartitionStateChange() {
        Set<TopicPartition> partitions = this.controllerContext.partitionsInStates((Set<PartitionState>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PartitionState[]{OfflinePartition$.MODULE$, NewPartition$.MODULE$}))));
        return this.triggerOnlineStateChangeForPartitions(partitions);
    }

    public void triggerOnlinePartitionStateChange(String topic) {
        Set<TopicPartition> partitions = this.controllerContext.partitionsInStates(topic, (Set<PartitionState>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PartitionState[]{OfflinePartition$.MODULE$, NewPartition$.MODULE$}))));
        this.triggerOnlineStateChangeForPartitions(partitions);
    }

    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> triggerOnlineStateChangeForPartitions(Set<TopicPartition> partitions) {
        scala.collection.immutable.Seq partitionsToTrigger = ((IterableOnceOps)partitions.filter((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlineStateChangeForPartitions$1(this, partition)))).toSeq();
        return this.handleStateChanges((Seq<TopicPartition>)partitionsToTrigger, OnlinePartition$.MODULE$, (Option<PartitionLeaderElectionStrategy>)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
    }

    private void initializePartitionState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable)topicPartition -> {
            PartitionStateMachine.$anonfun$initializePartitionState$1(this, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState) {
        return this.handleStateChanges(partitions, targetState, (Option<PartitionLeaderElectionStrategy>)None$.MODULE$);
    }

    public abstract Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> var1, PartitionState var2, Option<PartitionLeaderElectionStrategy> var3);

    public static final /* synthetic */ boolean $anonfun$triggerOnlineStateChangeForPartitions$1(PartitionStateMachine $this, TopicPartition partition) {
        return !$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic());
    }

    public static final /* synthetic */ void $anonfun$initializePartitionState$1(PartitionStateMachine $this, TopicPartition topicPartition) {
        Option<LeaderIsrAndControllerEpoch> option = $this.controllerContext.partitionLeadershipInfo(topicPartition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            if ($this.controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.controllerContext.putPartitionState(topicPartition, OnlinePartition$.MODULE$);
                return;
            }
            $this.controllerContext.putPartitionState(topicPartition, OfflinePartition$.MODULE$);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.controllerContext.putPartitionState(topicPartition, NewPartition$.MODULE$);
            return;
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
    }
}

