/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.coordinator.transaction.ProducerIdBlock;
import kafka.coordinator.transaction.ProducerIdGenerator;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\r\u001b\u0011\u0003\tc!B\u0012\u001b\u0011\u0003!\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007q\u0005\u0001\u000b\u0011B\u001b\t\u000fe\n!\u0019!C\u0001i!1!(\u0001Q\u0001\nUBQaO\u0001\u0005\u0002qBQ\u0001S\u0001\u0005\u0002%3Aa\t\u000e\u0001\u0019\"A\u0001+\u0003BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005V\u0013\t\u0005\t\u0015!\u0003S\u0011!1\u0016B!b\u0001\n\u00039\u0006\u0002\u00030\n\u0005\u0003\u0005\u000b\u0011\u0002-\t\u000bEJA\u0011A0\t\u000f\rL\u0001\u0019!C\u0005I\"9Q-\u0003a\u0001\n\u00131\u0007B\u00027\nA\u0003&Q\tC\u0004n\u0013\u0001\u0007I\u0011\u0002\u001b\t\u000f9L\u0001\u0019!C\u0005_\"1\u0011/\u0003Q!\nUBQA]\u0005\u0005\nMDQ\u0001^\u0005\u0005\nUDq!!\u0007\n\t\u0003\tY\u0002\u0003\u0004\u0002\u001e%!\te]\u0001\u0012!J|G-^2fe&#W*\u00198bO\u0016\u0014(BA\u000e\u001d\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005uq\u0012aC2p_J$\u0017N\\1u_JT\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0011\u0013!D\u0001\u001b\u0005E\u0001&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM]\n\u0004\u0003\u0015Z\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-_5\tQF\u0003\u0002/=\u0005)Q\u000f^5mg&\u0011\u0001'\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011%\u0001\bDkJ\u0014XM\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003U\u0002\"A\n\u001c\n\u0005]:#\u0001\u0002'p]\u001e\fqbQ;se\u0016tGOV3sg&|g\u000eI\u0001\r!&$'\t\\8dWNK'0Z\u0001\u000e!&$'\t\\8dWNK'0\u001a\u0011\u00027\u001d,g.\u001a:bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\'j]8o)\ti4\tE\u0002'}\u0001K!aP\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019\n\u0015B\u0001\"(\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u0011;\u0001\u0019A#\u0002\u001fA\u0014x\u000eZ;dKJLEM\u00117pG.\u0004\"A\t$\n\u0005\u001dS\"a\u0004)s_\u0012,8-\u001a:JI\ncwnY6\u00021A\f'o]3Qe>$WoY3s\u0013\u0012\u0014En\\2l\t\u0006$\u0018\r\u0006\u0002F\u0015\")1\n\u0003a\u0001{\u0005A!n]8o\t\u0006$\u0018m\u0005\u0003\nK5[\u0003C\u0001\u0012O\u0013\ty%DA\nQe>$WoY3s\u0013\u0012<UM\\3sCR|'/\u0001\u0005ce>\\WM]%e+\u0005\u0011\u0006C\u0001\u0014T\u0013\t!vEA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0011i\\7\t\\5f]R,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037z\t!A_6\n\u0005uS&!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uAQ\u0019\u0001-\u00192\u0011\u0005\tJ\u0001\"\u0002)\u000f\u0001\u0004\u0011\u0006\"\u0002,\u000f\u0001\u0004A\u0016AF2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6\u0016\u0003\u0015\u000b!dY;se\u0016tG\u000f\u0015:pIV\u001cWM]%e\u00052|7m[0%KF$\"a\u001a6\u0011\u0005\u0019B\u0017BA5(\u0005\u0011)f.\u001b;\t\u000f-\u0004\u0012\u0011!a\u0001\u000b\u0006\u0019\u0001\u0010J\u0019\u0002/\r,(O]3oiB\u0013x\u000eZ;dKJLEM\u00117pG.\u0004\u0013A\u00048fqR\u0004&o\u001c3vG\u0016\u0014\u0018\nZ\u0001\u0013]\u0016DH\u000f\u0015:pIV\u001cWM]%e?\u0012*\u0017\u000f\u0006\u0002ha\"91nEA\u0001\u0002\u0004)\u0014a\u00048fqR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\u0002+\u001d,GOT3x!J|G-^2fe&#'\t\\8dWR\tq-\u0001\u000edQ\u0016\u001c7\u000e\u0015:pIV\u001cWM]%e\u00052|7m\u001b.l\t\u0006$\u0018\rF\u0003wyv\f)\u0002\u0005\u0003'of\u0014\u0016B\u0001=(\u0005\u0019!V\u000f\u001d7feA\u0011aE_\u0005\u0003w\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003W-\u0001\u0007\u0001\fC\u0003\u007f-\u0001\u0007q0\u0001\u0003qCRD\u0007\u0003BA\u0001\u0003\u001fqA!a\u0001\u0002\fA\u0019\u0011QA\u0014\u000e\u0005\u0005\u001d!bAA\u0005A\u00051AH]8pizJ1!!\u0004(\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA\n\u0005\u0019\u0019FO]5oO*\u0019\u0011QB\u0014\t\r\u0005]a\u00031\u0001>\u00031)\u0007\u0010]3di\u0016$G)\u0019;b\u0003I9WM\\3sCR,\u0007K]8ek\u000e,'/\u00133\u0015\u0003U\n\u0001b\u001d5vi\u0012|wO\u001c")
public class ProducerIdManager
implements ProducerIdGenerator,
Logging {
    private final int brokerId;
    private final KafkaZkClient zkClient;
    private ProducerIdBlock currentProducerIdBlock;
    private long nextProducerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ProducerIdBlock parseProducerIdBlockData(byte[] byArray) {
        return ProducerIdManager$.MODULE$.parseProducerIdBlockData(byArray);
    }

    public static byte[] generateProducerIdBlockJson(ProducerIdBlock producerIdBlock) {
        return ProducerIdManager$.MODULE$.generateProducerIdBlockJson(producerIdBlock);
    }

    public static long PidBlockSize() {
        return ProducerIdManager$.MODULE$.PidBlockSize();
    }

    public static long CurrentVersion() {
        return ProducerIdManager$.MODULE$.CurrentVersion();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private ProducerIdBlock currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private void currentProducerIdBlock_$eq(ProducerIdBlock x$1) {
        this.currentProducerIdBlock = x$1;
    }

    private long nextProducerId() {
        return this.nextProducerId;
    }

    private void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private void getNewProducerIdBlock() {
        boolean zkWriteComplete = false;
        while (!zkWriteComplete) {
            void var10_10;
            void var9_9;
            ProducerIdBlock producerIdBlock;
            void var4_4;
            Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient().getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option dataOpt = (Option)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (var4_4 instanceof Some) {
                byte[] data = (byte[])((Some)var4_4).value();
                ProducerIdBlock currProducerIdBlock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(data);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Read current producerId block ").append(currProducerIdBlock).append(", Zk path version ").append(n).toString());
                if (currProducerIdBlock.blockEndId() > Long.MAX_VALUE - ProducerIdManager$.MODULE$.PidBlockSize()) {
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(132).append("Exhausted all producerIds as the next block's end producerId is will has exceeded long type limit (current block end producerId is ").append(currProducerIdBlock.blockEndId()).append(")").toString());
                    throw new KafkaException("Have exhausted all producerIds.");
                }
                producerIdBlock = new ProducerIdBlock(this.brokerId(), currProducerIdBlock.blockEndId() + 1L, currProducerIdBlock.blockEndId() + ProducerIdManager$.MODULE$.PidBlockSize());
            } else if (None$.MODULE$.equals(var4_4)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("There is no producerId block yet (Zk path version ").append(n).append("), creating the first block").toString());
                producerIdBlock = new ProducerIdBlock(this.brokerId(), 0L, ProducerIdManager$.MODULE$.PidBlockSize() - 1L);
            } else {
                throw new MatchError((Object)var4_4);
            }
            this.currentProducerIdBlock_$eq(producerIdBlock);
            byte[] newProducerIdBlockData = ProducerIdManager$.MODULE$.generateProducerIdBlockJson(this.currentProducerIdBlock());
            Tuple2<Object, Object> tuple22 = this.zkClient().conditionalUpdatePath(ProducerIdBlockZNode$.MODULE$.path(), newProducerIdBlockData, n, (Option<Function3<KafkaZkClient, String, byte[], Tuple2<Object, Object>>>)new Some((Function3 & Serializable & scala.Serializable)(zkClient, path, expectedData) -> this.checkProducerIdBlockZkData((KafkaZkClient)zkClient, (String)path, (byte[])expectedData)));
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            boolean succeeded = tuple22._1$mcZ$sp();
            int version = tuple22._2$mcI$sp();
            zkWriteComplete = var9_9;
            if (!zkWriteComplete) continue;
            this.info((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ProducerIdManager.$anonfun$getNewProducerIdBlock$5(this, (int)var10_10)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<Object, Object> checkProducerIdBlockZkData(KafkaZkClient zkClient, String path, byte[] expectedData) {
        try {
            ProducerIdBlock expectedPidBlock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(expectedData);
            Tuple2<Option<byte[]>, Object> tuple2 = zkClient.getDataAndVersion(ProducerIdBlockZNode$.MODULE$.path());
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                int zkVersion = tuple2._2$mcI$sp();
                if (option instanceof Some) {
                    ProducerIdBlock currProducerIdBLock;
                    byte[] data = (byte[])((Some)option).value();
                    ProducerIdBlock producerIdBlock = currProducerIdBLock = ProducerIdManager$.MODULE$.parseProducerIdBlockData(data);
                    return new Tuple2.mcZI.sp(!(producerIdBlock != null ? !((Object)producerIdBlock).equals(expectedPidBlock) : expectedPidBlock != null), zkVersion);
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            Option option = (Option)tuple2._1();
            if (!None$.MODULE$.equals(option)) throw new MatchError(tuple2);
            return new Tuple2.mcZI.sp(false, -1);
        }
        catch (Exception e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Error while checking for producerId block Zk data on path ").append(path).append(": expected data ").append(new String(expectedData, StandardCharsets.UTF_8)).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return new Tuple2.mcZI.sp(false, -1);
        }
    }

    @Override
    public synchronized long generateProducerId() {
        if (this.nextProducerId() > this.currentProducerIdBlock().blockEndId()) {
            this.getNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().blockStartId() + 1L);
        } else {
            this.nextProducerId_$eq(this.nextProducerId() + 1L);
        }
        return this.nextProducerId() - 1L;
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Shutdown complete: last producerId assigned ").append(this.nextProducerId()).toString());
    }

    public static final /* synthetic */ String $anonfun$getNewProducerIdBlock$5(ProducerIdManager $this, int version$1) {
        return new StringBuilder(66).append("Acquired new producerId block ").append($this.currentProducerIdBlock()).append(" by writing to Zk with path version ").append(version$1).toString();
    }

    public ProducerIdManager(int brokerId, KafkaZkClient zkClient) {
        this.brokerId = brokerId;
        this.zkClient = zkClient;
        ProducerIdGenerator.$init$(this);
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(23).append("[ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.currentProducerIdBlock = null;
        this.nextProducerId = -1L;
        synchronized (this) {
            this.getNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().blockStartId());
            return;
        }
    }
}

