/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.raft;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.raft.KafkaFuturePurgatory;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.MockTimer$;
import kafka.utils.timer.Timer;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)a\u0005\u0001C\u00013!)\u0001\u0006\u0001C\u00013\tA2*\u00194lC\u001a+H/\u001e:f!V\u0014x-\u0019;pef$Vm\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002:bMRT!!\u0003\u0006\u0002\u000b-\fgm[1\u000b\u0003-\tA!\u001e8ji\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011AB\u0001\u000fi\u0016\u001cH/\u0012=qSJ\fG/[8o)\u0005Q\u0002CA\b\u001c\u0013\ta\u0002C\u0001\u0003V]&$\bF\u0001\u0002\u001f!\tyB%D\u0001!\u0015\t\t#%A\u0003kk:LGOC\u0001$\u0003\ry'oZ\u0005\u0003K\u0001\u0012A\u0001V3ti\u0006qA/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007FA\u0002\u001f\u0003m!Xm\u001d;D_6\u0004H.\u001a;j_:,\u0005pY3qi&|g.\u00197ms\"\u0012AA\b")
public class KafkaFuturePurgatoryTest {
    @Test
    public void testExpiration() {
        int brokerId = 0;
        MockTimer timer = new MockTimer(MockTimer$.MODULE$.$lessinit$greater$default$1());
        KafkaFuturePurgatory purgatory = new KafkaFuturePurgatory(brokerId, (Timer)timer, false);
        Assert.assertEquals((long)0L, (long)purgatory.numWaiting());
        CompletableFuture future1 = purgatory.await(x$1 -> Predef$.MODULE$.Integer2int(x$1) > 1, 500L);
        Assert.assertEquals((long)1L, (long)purgatory.numWaiting());
        CompletableFuture future2 = purgatory.await(x$2 -> Predef$.MODULE$.Integer2int(x$2) > 2, 500L);
        Assert.assertEquals((long)2L, (long)purgatory.numWaiting());
        CompletableFuture future3 = purgatory.await(x$3 -> Predef$.MODULE$.Integer2int(x$3) > 3, 1000L);
        Assert.assertEquals((long)3L, (long)purgatory.numWaiting());
        timer.advanceClock(501L);
        Assert.assertEquals((long)1L, (long)purgatory.numWaiting());
        TestUtils.assertFutureThrows((Future)future1, TimeoutException.class);
        TestUtils.assertFutureThrows((Future)future2, TimeoutException.class);
        timer.advanceClock(500L);
        Assert.assertEquals((long)0L, (long)purgatory.numWaiting());
        TestUtils.assertFutureThrows((Future)future3, TimeoutException.class);
    }

    @Test
    public void testCompletion() {
        int brokerId = 0;
        MockTimer timer = new MockTimer(MockTimer$.MODULE$.$lessinit$greater$default$1());
        KafkaFuturePurgatory purgatory = new KafkaFuturePurgatory(brokerId, (Timer)timer, false);
        Assert.assertEquals((long)0L, (long)purgatory.numWaiting());
        CompletableFuture future1 = purgatory.await(x$4 -> Predef$.MODULE$.Integer2int(x$4) > 1, 500L);
        Assert.assertEquals((long)1L, (long)purgatory.numWaiting());
        CompletableFuture future2 = purgatory.await(x$5 -> Predef$.MODULE$.Integer2int(x$5) > 2, 500L);
        Assert.assertEquals((long)2L, (long)purgatory.numWaiting());
        CompletableFuture future3 = purgatory.await(x$6 -> Predef$.MODULE$.Integer2int(x$6) > 3, 1000L);
        Assert.assertEquals((long)3L, (long)purgatory.numWaiting());
        purgatory.maybeComplete((Object)Predef$.MODULE$.int2Integer(4), 100L);
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), future1.get());
        Assert.assertTrue((boolean)future2.isDone());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), future2.get());
        Assert.assertTrue((boolean)future3.isDone());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)100L), future3.get());
    }

    @Test
    public void testCompletionExceptionally() {
        int brokerId = 0;
        MockTimer timer = new MockTimer(MockTimer$.MODULE$.$lessinit$greater$default$1());
        KafkaFuturePurgatory purgatory = new KafkaFuturePurgatory(brokerId, (Timer)timer, false);
        Assert.assertEquals((long)0L, (long)purgatory.numWaiting());
        CompletableFuture future1 = purgatory.await(x$7 -> Predef$.MODULE$.Integer2int(x$7) > 1, 500L);
        Assert.assertEquals((long)1L, (long)purgatory.numWaiting());
        CompletableFuture future2 = purgatory.await(x$8 -> Predef$.MODULE$.Integer2int(x$8) > 2, 500L);
        Assert.assertEquals((long)2L, (long)purgatory.numWaiting());
        CompletableFuture future3 = purgatory.await(x$9 -> Predef$.MODULE$.Integer2int(x$9) > 3, 1000L);
        Assert.assertEquals((long)3L, (long)purgatory.numWaiting());
        Throwable exception = new Throwable("kaboom");
        purgatory.completeAllExceptionally(exception);
        Assert.assertTrue((boolean)future1.isDone());
        Assertions$.MODULE$.assertThrows((Function0 & java.io.Serializable & Serializable)() -> (Long)future1.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("KafkaFuturePurgatoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        Assert.assertTrue((boolean)future2.isDone());
        Assertions$.MODULE$.assertThrows((Function0 & java.io.Serializable & Serializable)() -> (Long)future2.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("KafkaFuturePurgatoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        Assert.assertTrue((boolean)future3.isDone());
        Assertions$.MODULE$.assertThrows((Function0 & java.io.Serializable & Serializable)() -> (Long)future3.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("KafkaFuturePurgatoryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }
}

