/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)Q\u0005\u0001C\u00011!)q\u0005\u0001C\u00011!)\u0011\u0006\u0001C\u00011\t\u0001b)Z1ukJ,'LT8eKR+7\u000f\u001e\u0006\u0003\u0011%\t!A_6\u000b\u0003)\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0004\u0002!Q,7\u000f^#oG>$W\rR3d_\u0012,G#A\r\u0011\u00059Q\u0012BA\u000e\u0010\u0005\u0011)f.\u001b;)\u0005\ti\u0002C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0013aA8sO&\u0011Ae\b\u0002\u0005)\u0016\u001cH/A\tuKN$H)Z2pI\u0016\u001cVoY2fgND#aA\u000f\u0002OQ,7\u000f\u001e#fG>$WMR1jY>s\u0017J\u001c<bY&$g+\u001a:tS>t\u0017I\u001c3Ti\u0006$Xo\u001d\u0015\u0003\tu\tq\u0004^3ti\u0012+7m\u001c3f\r\u0006LGn\u00148J]Z\fG.\u001b3GK\u0006$XO]3tQ\t)Q\u0004")
public class FeatureZNodeTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testEncodeDecode() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(1, 2);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        FinalizedVersionRange finalizedVersionRange2 = new FinalizedVersionRange(2, 4);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature2");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        FeatureZNode featureZNode = new FeatureZNode(FeatureZNodeStatus$.MODULE$.Enabled(), Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava())));
        FeatureZNode decoded = FeatureZNode$.MODULE$.decode(FeatureZNode$.MODULE$.encode(featureZNode));
        Assert.assertEquals((Object)featureZNode, (Object)decoded);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeSuccess() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        String featureZNodeStrTemplate = "{\n      \"version\":1,\n      \"status\":1,\n      \"features\":%s\n    }";
        String validFeatures = "{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"feature2\": {\"min_version_level\": 2, \"max_version_level\": 4}}";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        FeatureZNode node1 = FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{validFeatures})).getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)FeatureZNodeStatus$.MODULE$.Enabled(), (Object)node1.status());
        Tuple2[] tuple2Array = new Tuple2[2];
        FinalizedVersionRange finalizedVersionRange = new FinalizedVersionRange(1, 2);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"feature1");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        FinalizedVersionRange finalizedVersionRange2 = new FinalizedVersionRange(2, 4);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"feature2");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Features.finalizedFeatures((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava())), (Object)node1.features());
        String emptyFeatures = "{}";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        FeatureZNode node2 = FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{emptyFeatures})).getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)FeatureZNodeStatus$.MODULE$.Enabled(), (Object)node2.status());
        Assert.assertEquals((Object)Features.emptyFinalizedFeatures(), (Object)node2.features());
    }

    @Test
    public void testDecodeFailOnInvalidVersionAndStatus() {
        String featureZNodeStrTemplate = "{\n      \"version\":%d,\n      \"status\":%d,\n      \"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"feature2\": {\"min_version_level\": 2, \"max_version_level\": 4}}\n    }";
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(FeatureZNode$.MODULE$.V1() - 1)), BoxesRunTime.boxToInteger((int)1)})).getBytes(StandardCharsets.UTF_8));
        });
        int invalidStatus = BoxesRunTime.unboxToInt((Object)((TraversableOnce)FeatureZNodeStatus$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.Int$.MODULE$))).toList().max((Ordering)Ordering.Int$.MODULE$)) + 1;
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)FeatureZNode$.MODULE$.CurrentVersion()), BoxesRunTime.boxToInteger((int)invalidStatus)})).getBytes(StandardCharsets.UTF_8));
        });
    }

    @Test
    public void testDecodeFailOnInvalidFeatures() {
        String featureZNodeStrTemplate = "{\n      \"version\":1,\n      \"status\":1%s\n    }";
        String missingFeatures = "";
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingFeatures})).getBytes(StandardCharsets.UTF_8));
        });
        String malformedFeatures = ",\"features\":{\"feature1\": {\"min_version_level\": 1, \"max_version_level\": 2}, \"partial\"}";
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{malformedFeatures})).getBytes(StandardCharsets.UTF_8));
        });
        String invalidFeaturesMinVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 0, \"max_version_level\": 2}}";
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMinVersionLevel})).getBytes(StandardCharsets.UTF_8));
        });
        String invalidFeaturesMaxVersionLevel = ",\"features\":{\"feature1\": {\"min_version_level\": 2, \"max_version_level\": 1}}";
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMaxVersionLevel})).getBytes(StandardCharsets.UTF_8));
        });
        String invalidFeaturesMissingMinVersionLevel = ",\"features\":{\"feature1\": {\"max_version_level\": 1}}";
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            FeatureZNode$.MODULE$.decode(new StringOps(featureZNodeStrTemplate).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidFeaturesMissingMinVersionLevel})).getBytes(StandardCharsets.UTF_8));
        });
    }
}

