/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.utils.TestUtils$Roll$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00042\u0001\u0001\u0006Ia\u000b\u0005\be\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\u0019\u0004\u0001)A\u0005W!9A\u0007\u0001b\u0001\n\u0003Q\u0003BB\u001b\u0001A\u0003%1\u0006C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\u0001\u0003\u0001\u0015!\u00039\u0011\u001d\t\u0005A1A\u0005\n)BaA\u0011\u0001!\u0002\u0013Y\u0003bB\"\u0001\u0005\u0004%\tE\u000b\u0005\u0007\t\u0002\u0001\u000b\u0011B\u0016\t\u000b\u0015\u0003A\u0011\t$\t\u000bM\u0003A\u0011\u0001$\t\u000ba\u0003A\u0011\u0001$\t\u000bi\u0003A\u0011\u0001$\t\u000bq\u0003A\u0011\u0001$\t\u000by\u0003A\u0011\u0001$\t\u000b\u0001\u0004A\u0011\u0001$\t\u000b\t\u0004A\u0011A2\t\u000bY\u0004A\u0011A<\t\u000be\u0004A\u0011\u0002>\u0003#1{w\rR5s\r\u0006LG.\u001e:f)\u0016\u001cHO\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011E\u0003\u0002#7\u0005\u0019\u0011\r]5\n\u0005\u0011\n#AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005I\u0012!\u00049s_\u0012,8-\u001a:D_VtG/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\rIe\u000e^\u0001\u000faJ|G-^2fe\u000e{WO\u001c;!\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\u0006q1m\u001c8tk6,'oQ8v]R\u0004\u0013a\u00032s_.,'oQ8v]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nQ\u0001^8qS\u000e,\u0012\u0001\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\nA\u0001\\1oO*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0002]1si&$\u0018n\u001c8Ok6\fQ\u0002]1si&$\u0018n\u001c8Ok6\u0004\u0013a\u00037pO\u0012K'oQ8v]R\fA\u0002\\8h\t&\u00148i\\;oi\u0002\nQa]3u+B$\u0012a\u0012\t\u0003Y!K!!S\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001d-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\u000b),h.\u001b;\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011VJ\u0001\u0004CK\u001a|'/Z\u0001%i\u0016\u001cH\u000f\u0015:pIV\u001cW-\u0012:s_J4%o\\7GC&dWO]3P]2{wMU8mY\"\u0012q\"\u0016\t\u0003\u0019ZK!aV'\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\t\u0001R+A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\tR+A\u0014uKN$\bK]8ek\u000e,WI\u001d:pe\u001a\u0013x.\u001c$bS2,(/Z(o\u0007\",7m\u001b9pS:$\bF\u0001\nV\u0003}!Xm\u001d;J\u001f\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0003'U\u000bA\u0007^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148G_2dwn^3sQ\t!R+\u0001\u0016uKN$\bK]8ek\u000e,WI\u001d:peN4%o\\7M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0005\u001d#\u0007\"B3\u0016\u0001\u00041\u0017a\u00034bS2,(/\u001a+za\u0016\u0004\"aZ:\u000f\u0005!\u0004hBA5o\u001d\tQW.D\u0001l\u0015\taW$\u0001\u0004=e>|GOP\u0005\u00029%\u0011qnG\u0001\u0006kRLGn]\u0005\u0003cJ\f\u0011\u0002V3tiV#\u0018\u000e\\:\u000b\u0005=\\\u0012B\u0001;v\u0005Eaun\u001a#je\u001a\u000b\u0017\u000e\\;sKRK\b/\u001a\u0006\u0003cJ\fQ\u0005^3tiB\u0013x\u000eZ;dK\u00063G/\u001a:M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0005\u001dC\b\"B3\u0017\u0001\u00041\u0017!H:vEN\u001c'/\u001b2f\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\t\u001d[\u0018q\u0001\u0005\u0006m]\u0001\r\u0001 \t\u0004{\u0006\raB\u0001@\u0000!\tQW&C\u0002\u0002\u00025\na\u0001\u0015:fI\u00164\u0017bA \u0002\u0006)\u0019\u0011\u0011A\u0017\t\u000f\u0005%q\u00031\u0001\u0002\f\u0005A1m\u001c8tk6,'\u000f\u0005\u0005\u0002\u000e\u0005m\u0011qDA\u0010\u001b\t\tyA\u0003\u0003\u0002\n\u0005E!\u0002BA\n\u0003+\tqa\u00197jK:$8OC\u0002\u001d\u0003/Q1!!\u0007P\u0003\u0019\t\u0007/Y2iK&!\u0011QDA\b\u00055Y\u0015MZ6b\u0007>t7/^7feB)A&!\t\u0002&%\u0019\u00111E\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\u00071\n9#C\u0002\u0002*5\u0012AAQ=uK\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4());
    }

    @Test
    public void testProduceErrorFromFailureOnLogRoll() {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Roll$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        void setHaltProcedure_haltProcedure;
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        KafkaServer server = null;
        try {
            int x$12 = this.brokerCount();
            String x$2 = this.zkConnect();
            int x$3 = 3;
            boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
            boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
            int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
            Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
            Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
            Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
            boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
            boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
            int x$122 = TestUtils$.MODULE$.createBrokerConfig$default$11();
            boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
            int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
            boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
            int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
            Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
            boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
            int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
            short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19, x$20);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            logDir.createNewFile();
            Assert.assertTrue((boolean)logDir.isFile());
            server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(statusCodeOption)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
        catch (Throwable throwable) {
            Exit$.MODULE$.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon(server, (List)Nil$.MODULE$));
            }
            throw throwable;
        }
        Exit$.MODULE$.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        }
    }

    @Test
    public void testProduceErrorFromFailureOnCheckpoint() {
        this.testProduceErrorsFromLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(TestUtils$Checkpoint$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        void find_p;
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
        JFunction1.mcZI.sp & Serializable & scala.Serializable intersect = (JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != leaderServerId;
        ArrayOps.ofInt find_this = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())), (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))));
        int find_i = find_this.prefixLength(arg_0 -> IndexedSeqOptimized.$anonfun$find$1$adapted((Function1)find_p, arg_0));
        Object object = find_i < find_this.length() ? new Some(find_this.apply(find_i)) : None$.MODULE$;
        int followerServerId = BoxesRunTime.unboxToInt((Object)object.get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(n, this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            Option option = leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.topic(), i));
            if (option == null) {
                throw null;
            }
            Option flatMap_this = option;
            Object object = flatMap_this.isEmpty() ? None$.MODULE$ : ((Partition)flatMap_this.get()).leaderLogIfLocal();
            return object.isDefined();
        }).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.brokerCount(), (long)((Partition)leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        TestUtils$.MODULE$.causeLogDirFailure(failureType, leaderServer, partition);
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw Assertions$.MODULE$.fail("send() should fail with either KafkaStorageException or NotLeaderOrFollowerException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof KafkaStorageException) {
                return;
            }
            if (throwable instanceof NotLeaderOrFollowerException) {
                return;
            }
            if (throwable != null) {
                throw Assertions$.MODULE$.fail(new StringBuilder(96).append("send() should fail with either KafkaStorageException or NotLeaderOrFollowerException instead of ").append(throwable.toString()).toString(), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            throw new MatchError(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testProduceAfterLogDirFailureOnLeader(TestUtils.LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$10))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$11))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        TestUtils$.MODULE$.causeLogDirFailure(failureType, leaderServer, partition);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 6000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, leaderServerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
        Assert.assertTrue((boolean)((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(x$13))).get()).kafkaController().controllerContext().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$).contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
    }

    /*
     * WARNING - void declaration
     */
    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        void pollUntilTrue_action;
        consumer.subscribe(Collections.singletonList(topic));
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)pollUntilTrue_waitTimeMs, pollUntilTrue_x$3));
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(VolatileObjectRef statusCodeOption$1) {
        return ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ String $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4() {
        return "timed out waiting for broker to halt";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$3, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$12) {
        return x$12.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$1, ProducerRecord record$1, int leaderServerId$3) {
        producer$1.send(record$1);
        return ((PartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(producer$1.partitionsFor($this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$12))).get()).leader().id() != leaderServerId$3;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(KafkaServer x$13) {
        return x$13.kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }
}

