/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MBqA\u000e\u0001A\u0002\u0013\u0005q\u0007C\u0004V\u0001\u0001\u0007I\u0011\u0001,\t\rq\u0003\u0001\u0015)\u00039\u0011\u001di\u0006A1A\u0005\u0002yCaA\u0019\u0001!\u0002\u0013y\u0006bB2\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007K\u0002\u0001\u000b\u0011\u0002(\t\u000f\u0019\u0004!\u0019!C\u0001I\"1q\r\u0001Q\u0001\n9Cq\u0001\u001b\u0001C\u0002\u0013\u0005a\f\u0003\u0004j\u0001\u0001\u0006Ia\u0018\u0005\bU\u0002\u0011\r\u0011\"\u0001l\u0011\u0019!\b\u0001)A\u0005Y\"9Q\u000f\u0001b\u0001\n\u00031\bBB>\u0001A\u0003%q\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005\u001d\u0001\u0001)A\u0005}\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u000e!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002 !I\u0011\u0011\b\u0001A\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u000bB\u0001\"!\u0013\u0001A\u0003&\u0011Q\b\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0003\ti\u0005C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0004bCA6\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001fBq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002\u0000\u0001!\t!a\u001c\t\u000f\u0005%\u0005\u0001\"\u0001\u0002p!9\u00111\u0013\u0001\u0005\u0002\u0005=\u0004bBAL\u0001\u0011\u0005\u0011q\u000e\u0005\b\u00037\u0003A\u0011AA8\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!!6\u0001\t\u0013\t9NA\tJgJ,\u0005\u0010]5sCRLwN\u001c+fgRT!a\n\u0015\u0002\rM,'O^3s\u0015\u0005I\u0013!B6bM.\f7\u0001A\n\u0003\u00011\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00015!\t)\u0004!D\u0001'\u0003E!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]\u000b\u0002qA!\u0011H\u0010!R\u001b\u0005Q$BA\u001e=\u0003\u001diW\u000f^1cY\u0016T!!\u0010\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002@u\t\u0019Q*\u00199\u0011\t5\n5IT\u0005\u0003\u0005:\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001#L\u001d\t)\u0015\n\u0005\u0002G]5\tqI\u0003\u0002IU\u00051AH]8pizJ!A\u0013\u0018\u0002\rA\u0013X\rZ3g\u0013\taUJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0015:\u0002\"!L(\n\u0005As#aA%oiB\u0019!k\u0015(\u000e\u0003qJ!\u0001\u0016\u001f\u0003\u0007M+\u0017/A\u000bu_BL7\rU1si&$\u0018n\u001c8JgJ|F%Z9\u0015\u0005]S\u0006CA\u0017Y\u0013\tIfF\u0001\u0003V]&$\bbB.\u0004\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\n\u0014A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\%te\u0002\n1C]3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN,\u0012a\u0018\t\u0003[\u0001L!!\u0019\u0018\u0003\t1{gnZ\u0001\u0015e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj\u001d\u0011\u0002+I,\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=NgV\ta*\u0001\fsKBd\u0017nY1GKR\u001c\u0007nV1ji6\u000b\u00070T:!\u0003IaW-\u00193fe2{w-\u00128e\u001f\u001a47/\u001a;\u0002'1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\u0002-1,\u0017\rZ3s\u0019><\u0007*[4i/\u0006$XM]7be.\fq\u0003\\3bI\u0016\u0014Hj\\4IS\u001eDw+\u0019;fe6\f'o\u001b\u0011\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN,\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA!\u001e;jY*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005)\u0001&o\u001c9feRLWm]\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002\nqaY8oM&<7/F\u0001x!\r\u00116\u000b\u001f\t\u0003keL!A\u001f\u0014\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\tG>tg-[4tA\u0005)Ao\u001c9jGV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\r\u0001/\u0001\u0003mC:<\u0017b\u0001'\u0002\u0002\u00051Ao\u001c9jG\u0002\nA\u0001^5nKV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0015\u0002\u000bU$\u0018\u000e\\:\n\t\u0005]\u0011\u0011\u0003\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cXCAA\u0010!\u0011\t\t#a\r\u000e\u0005\u0005\r\"\u0002BA\u000e\u0003KQA!a\n\u0002*\u000511m\\7n_:T1!KA\u0016\u0015\u0011\ti#a\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t$A\u0002pe\u001eLA!!\u000e\u0002$\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011Q\b\t\u0004k\u0005}\u0012bAA!M\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$2aVA$\u0011!Y\u0006$!AA\u0002\u0005u\u0012a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u001f\u0005dG/\u001a:JgJl\u0015M\\1hKJ,\"!a\u0014\u0011\t\u0005E\u0013q\f\b\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005ecb\u0001$\u0002X%\t\u0011&C\u0002\u0002\u0014!JA!!\u0018\u0002\u0012\u0005IA+Z:u+RLGn]\u0005\u0005\u0003C\n\u0019GA\nN_\u000e\\\u0017\t\u001c;fe&\u001b(/T1oC\u001e,'O\u0003\u0003\u0002^\u0005E\u0011aE1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:`I\u0015\fHcA,\u0002j!A1lGA\u0001\u0002\u0004\ty%\u0001\tbYR,'/S:s\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\tq\u000bK\u0002\u001e\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0005\u0003s\ny#A\u0003kk:LG/\u0003\u0003\u0002~\u0005]$A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\rq\u00121\u0011\t\u0005\u0003k\n))\u0003\u0003\u0002\b\u0006]$!B!gi\u0016\u0014\u0018A\t;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'o\u0015;vG.4u\u000e\u001c7po\u0016\u00148\u000fK\u0002 \u0003\u001b\u0003B!!\u001e\u0002\u0010&!\u0011\u0011SA<\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f^%te\u0016C\b/\u001b:bi&|g.\u00134O_\u001a+Go\u00195SKF,Xm\u001d;NC\u0012,\u0007f\u0001\u0011\u0002\u000e\u0006\tC/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8G_J\u001cFn\\<G_2dwn^3sg\"\u001a\u0011%!$\u0002KQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s\u0007\u0006,x\r\u001b;Va\u001a{G\u000e\\8xKJ\u001c\bf\u0001\u0012\u0002\u000e\u0006\u0001s-\u001a;QCJ$\u0018\u000e^5p]^KG\u000f[!mYJ+\u0007\u000f\\5dCNLe.S:s)1\t\u0019+a,\u00022\u0006U\u0016\u0011YAc!\u0011\t)+a+\u000e\u0005\u0005\u001d&bAAUQ\u000591\r\\;ti\u0016\u0014\u0018\u0002BAW\u0003O\u0013\u0011\u0002U1si&$\u0018n\u001c8\t\u000bq\u001c\u0003\u0019A\"\t\r\u0005M6\u00051\u0001O\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\u0005%1\u00051\u0001\u00028B!\u0011\u0011XA_\u001b\t\tYL\u0003\u0003\u0002\u0014\u0005\u0015\u0012\u0002BA`\u0003w\u0013A\u0001V5nK\"1\u00111Y\u0012A\u0002a\faaY8oM&<\u0007bBAdG\u0001\u0007\u0011\u0011Z\u0001\tY>\u001c\u0017\r\u001c'pOB!\u00111ZAi\u001b\t\tiMC\u0002\u0002P\"\n1\u0001\\8h\u0013\u0011\t\u0019.!4\u0003\u00071{w-A\u0004m_\u001elunY6\u0016\u0005\u0005%\u0007")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final long leaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterIsrManager alterIsrManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long leaderLogHighWatermark() {
        return this.leaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    @Before
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.alterIsrManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), (AlterIsrManager)this.alterIsrManager(), ReplicaManager$.MODULE$.$lessinit$greater$default$13()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(75L);
        partition0.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR);
        partition0.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        partition.updateAssignmentAndIsr((Seq)this.configs().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Seq$.MODULE$.canBuildFrom()), ((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, time.milliseconds(), 0L);
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLogEndOffset())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLogHighWatermark())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        return var1_1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.leaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

