/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.network.RequestChannel;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u001c8\u0001qBQ!\u0011\u0001\u0005\u0002\tCq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004J\u0001\u0001\u0006IA\u0012\u0005\u0006\u0015\u0002!Ia\u0013\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\tI\u000b\u0001C\u0001\u0003+Cq!!,\u0001\t\u0003\t)\nC\u0004\u00022\u0002!\t!!&\t\u000f\u0005U\u0006\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0006bBAo\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003C\u0004A\u0011AAK\u0011\u001d\t)\u000f\u0001C\u0001\u0003+Cq!!;\u0001\t\u0003\t)\nC\u0004\u0002n\u0002!\t!!&\t\u000f\u0005E\b\u0001\"\u0001\u0002\u0016\"9\u0011Q\u001f\u0001\u0005\u0002\u0005U\u0005bBA}\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003{\u0004A\u0011AAK\r\u00119\u0006\u0001\u0012-\t\u0011\t$\"Q3A\u0005\u0002\rD\u0001b\u001c\u000b\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\taR\u0011)\u001a!C\u0001G\"A\u0011\u000f\u0006B\tB\u0003%A\r\u0003\u0005s)\tU\r\u0011\"\u0001t\u0011!9HC!E!\u0002\u0013!\b\u0002\u0003=\u0015\u0005+\u0007I\u0011A:\t\u0011e$\"\u0011#Q\u0001\nQDQ!\u0011\u000b\u0005\u0002iDaa \u000b\u0005\u0002\u0005\u0005\u0001\"CA\n)\u0005\u0005I\u0011AA\u000b\u0011%\ty\u0002FI\u0001\n\u0003\t\t\u0003C\u0005\u00028Q\t\n\u0011\"\u0001\u0002\"!I\u0011\u0011\b\u000b\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u007f!\u0012\u0013!C\u0001\u0003wA\u0011\"!\u0011\u0015\u0003\u0003%\t%a\u0011\t\u0013\u0005\u0015C#!A\u0005\u0002\u0005\u001d\u0003\"CA()\u0005\u0005I\u0011AA)\u0011%\ti\u0006FA\u0001\n\u0003\ny\u0006C\u0005\u0002nQ\t\t\u0011\"\u0001\u0002p!I\u0011\u0011\u0010\u000b\u0002\u0002\u0013\u0005\u00131\u0010\u0005\n\u0003{\"\u0012\u0011!C!\u0003\u007fB\u0011\"!!\u0015\u0003\u0003%\t%a!\b\u0013\t\u0005\u0001!!A\t\n\t\ra\u0001C,\u0001\u0003\u0003EIA!\u0002\t\r\u0005kC\u0011\u0001B\n\u0011%\ti(LA\u0001\n\u000b\ny\bC\u0005\u0003\u00165\n\t\u0011\"!\u0003\u0018!I!\u0011E\u0017\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0005Gi\u0013\u0013!C\u0001\u0003wA\u0011B!\n.\u0003\u0003%\tIa\n\t\u0013\tUR&%A\u0005\u0002\u0005m\u0002\"\u0003B\u001c[E\u0005I\u0011AA\u001e\u0005Y\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:UKN$(B\u0001\u001d:\u0003\u0019\u0019XM\u001d<fe*\t!(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0004C\u0001 @\u001b\u00059\u0014B\u0001!8\u0005i\u0011\u0015m]3DY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\t\u0005\u0002?\u0001\u000511m\u001c8gS\u001e,\u0012A\u0012\t\u0003}\u001dK!\u0001S\u001c\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002!Q,7\u000f^)v_R\f\u0007+\u0019:tS:<G#\u0003'S'\u0006\u001d\u00151RAH!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0011)f.\u001b;\t\u000b\u0011#\u0001\u0019\u0001$\t\u000bQ#\u0001\u0019A+\u0002\u000f\rd\u0017.\u001a8ucA\u0011a\u000bF\u0007\u0002\u0001\tQQk]3s\u00072LWM\u001c;\u0014\tQIFl\u0018\t\u0003\u001bjK!a\u0017(\u0003\r\u0005s\u0017PU3g!\tiU,\u0003\u0002_\u001d\n9\u0001K]8ek\u000e$\bCA'a\u0013\t\tgJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003vg\u0016\u0014X#\u00013\u0011\u0005\u0015dgB\u00014k!\t9g*D\u0001i\u0015\tI7(\u0001\u0004=e>|GOP\u0005\u0003W:\u000ba\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111NT\u0001\u0006kN,'\u000fI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u000bG>tg-[4Vg\u0016\u0014X#\u0001;\u0011\u00075+H-\u0003\u0002w\u001d\n1q\n\u001d;j_:\f1bY8oM&<Wk]3sA\u0005q1m\u001c8gS\u001e\u001cE.[3oi&#\u0017aD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0011\u0015\u000bU[H0 @\t\u000b\tl\u0002\u0019\u00013\t\u000bAl\u0002\u0019\u00013\t\u000fIl\u0002\u0013!a\u0001i\"9\u00010\bI\u0001\u0002\u0004!\u0018aF:b]&$\u0018N_3e\u0007>tg-[4DY&,g\u000e^%e+\t\t\u0019\u0001\u0005\u0003Nk\u0006\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0010\u0005!!.\u0019<b\u0013\ri\u0017\u0011B\u0001\u0005G>\u0004\u0018\u0010F\u0005V\u0003/\tI\"a\u0007\u0002\u001e!9!m\bI\u0001\u0002\u0004!\u0007b\u00029 !\u0003\u0005\r\u0001\u001a\u0005\be~\u0001\n\u00111\u0001u\u0011\u001dAx\u0004%AA\u0002Q\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002$)\u001aA-!\n,\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\rO\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\tYCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u\"f\u0001;\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0006\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\n\t\u0004\u001b\u0006-\u0013bAA'\u001d\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111KA-!\ri\u0015QK\u0005\u0004\u0003/r%aA!os\"I\u00111\f\u0014\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0004CBA2\u0003S\n\u0019&\u0004\u0002\u0002f)\u0019\u0011q\r(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0005\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001d\u0002xA\u0019Q*a\u001d\n\u0007\u0005UdJA\u0004C_>dW-\u00198\t\u0013\u0005m\u0003&!AA\u0002\u0005M\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0005\u0015\u0005\"CA.W\u0005\u0005\t\u0019AA*\u0011\u0019\tI\t\u0002a\u0001+\u000691\r\\5f]R\u0014\u0004BBAG\t\u0001\u0007Q+\u0001\u0007sC:$w.\\\"mS\u0016tG\u000f\u0003\u0004\u0002\u0012\u0012\u0001\r!V\u0001\u0014I\u00164\u0017-\u001e7u\u0007>tg-[4DY&,g\u000e^\u0001\u0019i\u0016\u001cHo\u00117jK:$\u0018\nZ)v_R\f\u0007+\u0019:tS:<G#\u0001')\u0007\u0015\tI\n\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\u000b),h.\u001b;\u000b\u0005\u0005\r\u0016aA8sO&!\u0011qUAO\u0005\u0011!Vm\u001d;\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\r1\u0011\u0011T\u0001\u001di\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b!\u0006\u00148/\u001b8hQ\r9\u0011\u0011T\u0001-i\u0016\u001cH/V:feF+x\u000e^1QCJ\u001c\u0018N\\4XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006D3\u0001CAM\u0003Q\"Xm\u001d;Vg\u0016\u00148\t\\5f]R\fVo\u001c;b!\u0006\u00148/\u001b8h\u0013\u0012<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004\u0013\u0005e\u0015AC2iK\u000e\\\u0017+^8uCRiA*!0\u0002H\u0006%\u00171ZAk\u00033Dq!a0\u000b\u0001\u0004\t\t-\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002?\u0003\u0007L1!!28\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u000b\tT\u0001\u0019\u00013\t\u000bAT\u0001\u0019\u00013\t\u000f\u00055'\u00021\u0001\u0002P\u0006iQ\r\u001f9fGR,GMQ8v]\u0012\u00042!TAi\u0013\r\t\u0019N\u0014\u0002\u0005\u0019>tw\rC\u0004\u0002X*\u0001\r!!\u0013\u0002\u000bY\fG.^3\t\u000f\u0005m'\u00021\u0001\u0002r\u0005qQ\r\u001f9fGR$\u0006N]8ui2,\u0017!\u000e;fgR<U\r^'bqZ\u000bG.^3J]F+x\u000e^1XS:$wn^,ji\"tuN\u001c#fM\u0006,H\u000e^)v_R\fw+\u001b8e_^D3aCAM\u0003\u0001\"Xm\u001d;TKR\fe\u000e\u001a*f[>4X\rR3gCVdG/V:feF+x\u000e^1)\u00071\tI*A\ruKN$8+\u001a;B]\u0012\u0014V-\\8wKV\u001bXM])v_R\f\u0007fA\u0007\u0002\u001a\u0006yB/Z:u'\u0016$\u0018I\u001c3SK6|g/Z+tKJ\u001cE.[3oiF+x\u000e^1)\u00079\tI*A\ruKN$\u0018+^8uC\u000e{gNZ5h!J,7-\u001a3f]\u000e,\u0007fA\b\u0002\u001a\u0006\u0011B/Z:u#V|G/\u0019,j_2\fG/[8oQ\r\u0001\u0012\u0011T\u0001\u001di\u0016\u001cH/\u0012=qSJ,G\u000b\u001b:piRdW\rV5nKN+gn]8sQ\r\t\u0012\u0011T\u0001\u0017i\u0016\u001cH/\u0012=qSJ,\u0017+^8uCN+gn]8sg\"\u001a!#!'\u00021Q,7\u000f^\"mS\u0016tG/\u00133O_R\u001c\u0016M\\5uSj,G\rK\u0002\u0014\u00033\u000b!\"V:fe\u000ec\u0017.\u001a8u!\t1Vf\u0005\u0003.\u0005\u000fy\u0006#\u0003B\u0005\u0005\u001f!G\r\u001e;V\u001b\t\u0011YAC\u0002\u0003\u000e9\u000bqA];oi&lW-\u0003\u0003\u0003\u0012\t-!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u0011!1A\u0001\u0006CB\u0004H.\u001f\u000b\n+\ne!1\u0004B\u000f\u0005?AQA\u0019\u0019A\u0002\u0011DQ\u0001\u001d\u0019A\u0002\u0011DqA\u001d\u0019\u0011\u0002\u0003\u0007A\u000fC\u0004yaA\u0005\t\u0019\u0001;\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IC!\r\u0011\t5+(1\u0006\t\b\u001b\n5B\r\u001a;u\u0013\r\u0011yC\u0014\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\tM2'!AA\u0002U\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\u0002")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder(33).append("Default producer quota should be ").append(config.quotaDefault()).toString(), (double)config.quotaDefault(), (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assert.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(Long.MAX_VALUE, numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assert.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assert.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, 10);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testQuotaViolation$1(this, clientQuotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)throttleTime);
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            int n2 = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range2 = RichInt$.MODULE$.until$extension0(n2, 10);
            if (range2 == null) {
                throw null;
            }
            Range foreach$mVc$sp_this2 = range2;
            if (!foreach$mVc$sp_this2.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
                while (true) {
                    ClientQuotaManagerTest.$anonfun$testQuotaViolation$3(this, clientQuotaManager, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
                }
            }
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0));
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaViolation$1(ClientQuotaManagerTest $this, ClientQuotaManager clientQuotaManager$1, int _) {
        Assert.assertEquals((long)0L, (long)$this.maybeRecord(clientQuotaManager$1, "ANONYMOUS", "unknown", 400.0));
        $this.time().sleep(1000L);
    }

    public static final /* synthetic */ void $anonfun$testQuotaViolation$3(ClientQuotaManagerTest $this, ClientQuotaManager clientQuotaManager$1, int _) {
        $this.maybeRecord(clientQuotaManager$1, "ANONYMOUS", "unknown", 400.0);
        $this.time().sleep(1000L);
    }

    public class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            Option<String> option = this.configClientId();
            if (option == null) {
                throw null;
            }
            Option<String> map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)UserClient.$anonfun$sanitizedConfigClientId$1((String)map_this.get()));
            return object;
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$sanitizedConfigClientId$1(String x) {
            String string = x;
            String string2 = ConfigEntityName$.MODULE$.Default();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ConfigEntityName$.MODULE$.Default();
            }
            return Sanitizer.sanitize((String)x);
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

