/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u001df\u0001B0a\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001C\u0002\u0013\u00051\u000f\u0003\u0004x\u0001\u0001\u0006I\u0001\u001e\u0005\bq\u0002\u0011\r\u0011\"\u0001t\u0011\u0019I\b\u0001)A\u0005i\"9!\u0010\u0001b\u0001\n\u0003\u0019\bBB>\u0001A\u0003%A\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005M\u0001\u0001)A\u0005}\"A\u0011Q\u0003\u0001C\u0002\u0013\u00051\u000fC\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u0002;\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u001d\u0001\u0001\u0006I!!\b\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0002\u0002CA&\u0001\u0001\u0006I!a\u0010\t\u0013\u00055\u0003A1A\u0005\u0002\u0005=\u0003\u0002CA.\u0001\u0001\u0006I!!\u0015\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA7\u0001\u0001\u0006I!!\u0019\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005E\u0004\u0002CA@\u0001\u0001\u0006I!a\u001d\t\u0013\u0005\u0005\u0005A1A\u0005\u0002\u0005\r\u0005\u0002CAH\u0001\u0001\u0006I!!\"\t\u0013\u0005E\u0005A1A\u0005\u0002\u0005M\u0005\u0002CAN\u0001\u0001\u0006I!!&\t\u0013\u0005u\u0005A1A\u0005\u0002\u0005}\u0005\u0002CAT\u0001\u0001\u0006I!!)\t\u0013\u0005%\u0006A1A\u0005\u0002\u0005-\u0006\u0002CAb\u0001\u0001\u0006I!!,\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005-\u0006\u0002CAd\u0001\u0001\u0006I!!,\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005-\u0007\u0002CAm\u0001\u0001\u0006I!!4\t\u0013\u0005m\u0007A1A\u0005\u0002\u0005-\u0007\u0002CAo\u0001\u0001\u0006I!!4\t\u0013\u0005}\u0007A1A\u0005\u0002\u0005\u0005\b\u0002CAy\u0001\u0001\u0006I!a9\t\u0013\u0005M\b\u00011A\u0005\u0002\u0005U\b\"CA\u007f\u0001\u0001\u0007I\u0011AA\u0000\u0011!\u0011Y\u0001\u0001Q!\n\u0005]\b\"\u0003B\u0007\u0001\u0001\u0007I\u0011AA{\u0011%\u0011y\u0001\u0001a\u0001\n\u0003\u0011\t\u0002\u0003\u0005\u0003\u0016\u0001\u0001\u000b\u0015BA|\u0011%\u00119\u0002\u0001a\u0001\n\u0003\u0011I\u0002C\u0005\u0003(\u0001\u0001\r\u0011\"\u0001\u0003*!A!Q\u0006\u0001!B\u0013\u0011Y\u0002C\u0004\u00030\u0001!\tA!\r\t\u000f\t\u0005\u0003\u0001\"\u0001\u00032!9!1\n\u0001\u0005\u0002\tE\u0002b\u0002B+\u0001\u0011\u0005!\u0011\u0007\u0005\b\u00053\u0002A\u0011\u0001B\u0019\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005cAqA!\u0019\u0001\t\u0003\u0011\t\u0004C\u0004\u0003f\u0001!\tA!\r\t\u000f\t%\u0004\u0001\"\u0001\u00032!9!Q\u000e\u0001\u0005\u0002\tE\u0002b\u0002B9\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005k\u0002A\u0011\u0001B\u0019\u0011\u001d\u0011I\b\u0001C\u0001\u0005cAqA! \u0001\t\u0003\u0011\t\u0004C\u0004\u0003\u0002\u0002!\tA!\r\t\u000f\te\u0005\u0001\"\u0001\u00032!9!Q\u0014\u0001\u0005\u0002\tE\u0002b\u0002BQ\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005K\u0003A\u0011\u0001B\u0019\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005cAqA!,\u0001\t\u0003\u0011\t\u0004C\u0004\u00032\u0002!\tA!\r\t\u000f\tU\u0006\u0001\"\u0001\u00032!9!\u0011\u0018\u0001\u0005\u0002\tE\u0002b\u0002B_\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005\u0003\u0004A\u0011\u0001B\u0019\u0011\u001d\u0011)\r\u0001C\u0001\u0005cAqA!3\u0001\t\u0003\u0011\t\u0004C\u0004\u0003N\u0002!\tA!\r\t\u000f\tE\u0007\u0001\"\u0003\u0003T\"9!q\u001e\u0001\u0005\n\tE\bb\u0002B|\u0001\u0011%!\u0011 \u0005\b\u0005w\u0004A\u0011\u0001B\u0019\u0011\u001d\u0011y\u0010\u0001C\u0001\u0005cAqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004\f\u0001!Ia!\u0004\t\u000f\rE\u0001\u0001\"\u0003\u0004\u0014!91Q\u0004\u0001\u0005\n\r}\u0001bBB\u001c\u0001\u0011%1\u0011\b\u0005\b\u0007\u0003\u0002A\u0011BB\"\u0011\u001d\u0019\u0019\u0006\u0001C\u0005\u0007+Bqaa\u0017\u0001\t\u0013\u0019i\u0006C\u0004\u0004b\u0001!Iaa\u0019\t\u0013\rE\u0004!%A\u0005\n\rM\u0004\"CBE\u0001E\u0005I\u0011BBF\u0011\u001d\u0019y\t\u0001C\u0005\u0007#Cqa!(\u0001\t\u0013\u0019y\nC\u0004\u0004$\u0002!\tA!\r\u00037Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\t'-A\u0006ue\u0006t7/Y2uS>t'BA2e\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u0015\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001QB\u0011\u0011\u000e\\\u0007\u0002U*\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00019\u0011\u0005E\u0004Q\"\u00011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u0002iB\u0011\u0011.^\u0005\u0003m*\u00141!\u00138u\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\u0010E\u0002\u0000\u0003\u001fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\f9A\u0003\u0003\u0002\n\u0005-\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u000e\u0005\u0019qN]4\n\t\u0005E\u0011\u0011\u0001\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u000bibt'+Z2pe\u0012\u001cXCAA\u000f!\u0019\ty\"!\u000b\u0002.5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u001d\".\u0001\u0006d_2dWm\u0019;j_:LA!a\u000b\u0002\"\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\ty#!\u000e\u000e\u0005\u0005E\"\u0002BA\u001a\u0003\u0003\taA]3d_J$\u0017\u0002BA\u001c\u0003c\u0011AbU5na2,'+Z2pe\u0012\f1\u0002\u001e=o%\u0016\u001cwN\u001d3tA\u0005!A/[7f+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\t)%!\u0001\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00131\t\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0003#\u0002B!a\u0015\u0002X5\u0011\u0011Q\u000b\u0006\u0004\u0003\u000b\"\u0017\u0002BA-\u0003+\u0012Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0011\f!A_6\n\t\u0005-\u0014Q\r\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013i\\7\t\\5f]R\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003s\"\u0017AB:feZ,'/\u0003\u0003\u0002~\u0005]$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u00059Q.\u001a;sS\u000e\u001cXCAAC!\u0011\t9)a#\u000e\u0005\u0005%%\u0002BAA\u0003\u0003IA!!$\u0002\n\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0013QDhnQ8oM&<WCAAK!\r\t\u0018qS\u0005\u0004\u00033\u0003'!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006QA\u000f\u001f8D_:4\u0017n\u001a\u0011\u0002%Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM]\u000b\u0003\u0003C\u00032!]AR\u0013\r\t)\u000b\u0019\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f1\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4fe\u0002\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0019\u0016\u0005\u00055\u0006\u0003BAX\u0003{sA!!-\u0002:B\u0019\u00111\u00176\u000e\u0005\u0005U&bAA\\M\u00061AH]8pizJ1!a/k\u0003\u0019\u0001&/\u001a3fM&!\u0011qXAa\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00186\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0005\tBO]1og\u0006\u001cG/[8oC2LEM\r\u0011\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019\u0016\u0005\u00055\u0007#B5\u0002P\u0006M\u0017bAAiU\n)\u0011I\u001d:bsB\u0019\u0011.!6\n\u0007\u0005]'N\u0001\u0003CsR,\u0017\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\f\u0004%A\nuq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c('\u0001\u000buq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c(\u0007I\u0001\faJ|G-^2fe&#7/\u0006\u0002\u0002dBA\u0011Q]At\u0003[\u000bY/\u0004\u0002\u0002&%!\u0011\u0011^A\u0013\u0005\ri\u0015\r\u001d\t\u0004S\u00065\u0018bAAxU\n!Aj\u001c8h\u00031\u0001(o\u001c3vG\u0016\u0014\u0018\nZ:!\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\t9\u0010E\u0002r\u0003sL1!a?a\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0003A!\bP\\'fi\u0006$\u0017\r^12?\u0012*\u0017\u000f\u0006\u0003\u0003\u0002\t\u001d\u0001cA5\u0003\u0004%\u0019!Q\u00016\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u00139\u0013\u0011!a\u0001\u0003o\f1\u0001\u001f\u00132\u00035!\bP\\'fi\u0006$\u0017\r^12A\u0005aA\u000f\u001f8NKR\fG-\u0019;be\u0005\u0001B\u000f\u001f8NKR\fG-\u0019;be}#S-\u001d\u000b\u0005\u0005\u0003\u0011\u0019\u0002C\u0005\u0003\n)\n\t\u00111\u0001\u0002x\u0006iA\u000f\u001f8NKR\fG-\u0019;be\u0001\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014XC\u0001B\u000e!\u0011\u0011iBa\t\u000e\u0005\t}!\u0002\u0002B\u0011\u0003\u0003\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005K\u0011yB\u0001\u0004FeJ|'o]\u0001\u0012Kb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:`I\u0015\fH\u0003\u0002B\u0001\u0005WA\u0011B!\u0003.\u0003\u0003\u0005\rAa\u0007\u0002\u001d\u0015D\b/Z2uK\u0012,%O]8sA\u0005)1/\u001a;VaR\u0011!\u0011\u0001\u0015\u0004_\tU\u0002\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\t\tm\u00121B\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005\u007f\u0011ID\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001G!\u0012\u0011\t\t]\"qI\u0005\u0005\u0005\u0013\u0012IDA\u0003BMR,'/\u0001\u0010uKN$h+\u00197jI\u0006$X\r\u0016:b]N\f7\r^5p]RKW.Z8vi\"\u001a\u0011Ga\u0014\u0011\t\t]\"\u0011K\u0005\u0005\u0005'\u0012ID\u0001\u0003UKN$\u0018A\u0004;fgR\fE\rZ$fiBKGm\u001d\u0015\u0004e\t=\u0013a\u0005;fgR$U\r\\3uKB\u000b'\u000f^5uS>t\u0007fA\u001a\u0003P\u0005QB/Z:u\t\u0016dW\r^3M_\u0006$\u0017N\\4QCJ$\u0018\u000e^5p]\"\u001aAGa\u0014\u0002SQ,7\u000f\u001e'pC\u0012\fe\u000e\u001a*f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d)beRLG/[8oQ\r)$qJ\u0001*i\u0016\u001cHoQ8na2,G/\u001a+sC:\u001c\u0018\u000e^5p]^CWM\\!qa\u0016tGmU;dG\u0016,G-\u001a3)\u0007Y\u0012y%\u0001\u0017uKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_\u000e{wN\u001d3j]\u0006$xN\u001d(pi\u00063\u0018-\u001b7bE2,WI\u001d:pe\"\u001aqGa\u0014\u0002GQ,7\u000f^!qa\u0016tGMR1jYR{gj\u001c;D_>\u0014H-\u001b8bi>\u0014XI\u001d:pe\"\u001a\u0001Ha\u0014\u0002OQ,7\u000f^!qa\u0016tGMR1jYR{7i\\8sI&t\u0017\r^8s\u0019>\fG-\u001b8h\u000bJ\u0014xN\u001d\u0015\u0004s\t=\u0013\u0001\b;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p+:\\gn\\<o\u000bJ\u0014xN\u001d\u0015\u0004u\t=\u0013!\n;fgR\u0004VM\u001c3j]\u001e\u001cF/\u0019;f\u001d>$(+Z:fi>s'+\u001a;ss\u0006\u0003\b/\u001a8eQ\rY$qJ\u0001.i\u0016\u001cH/\u00119qK:$GK]1og\u0006\u001cG/[8o)>dunZ,iS2,\u0007K]8ek\u000e,'OR3oG\u0016$\u0007f\u0001\u001f\u0003P\u0005\u0011D/Z:u\u0003B\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pO^C\u0017\u000e\\3QK:$\u0017N\\4Ti\u0006$Xm\u00115b]\u001e,G\rK\u0004>\u0005\u001f\u0012)Ia\"\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#A!#\u0011\t\t-%QS\u0007\u0003\u0005\u001bSAAa$\u0003\u0012\u0006!A.\u00198h\u0015\t\u0011\u0019*\u0001\u0003kCZ\f\u0017\u0002\u0002BL\u0005\u001b\u0013Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g.A tQ>,H\u000e\u001a*fiV\u0014hNT8u\u0007>|'/\u001b3oCR|'/\u0012:s_JLe\r\u0016:b]N\f7\r^5p]&#\u0007+\u0019:uSRLwN\u001c(pi>;h.\u001a3)\u0007y\u0012y%\u0001\u001ctQ>,H\u000eZ(oYf\u001cuN\\:jI\u0016\u0014HK]1og\u0006\u001cG/[8og&sG\u000b[3P]\u001e|\u0017N\\4Ti\u0006$X\rV8BE>\u0014H\u000fK\u0002@\u0005\u001f\n\u0001h\u001d5pk2$wK]5uKRCh.T1sW\u0016\u00148OR8s)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3e\u0007>lW.\u001b;Ti\u0006$X\rK\u0002A\u0005\u001f\nqg\u001d5pk2$wK]5uKRCh.T1sW\u0016\u00148OR8s)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3e\u0003\n|'\u000f^*uCR,\u0007fA!\u0003P\u0005\t4\u000f[8vY\u0012\u0014V-\\8wK\u000e{W\u000e\u001d7fi\u0016\u001cu.\\7ji\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001\"\u0003P\u0005\u00014\u000f[8vY\u0012\u0014V-\\8wK\u000e{W\u000e\u001d7fi\u0016\f%m\u001c:u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIND3a\u0011B(\u0003!\u001a\bn\\;mIJ+Wn\u001c<f\u000b6\u0004H/_#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\r!%qJ\u00017g\"|W\u000f\u001c3O_R\u0014V-\\8wK\u0016C\b/\u001b:fIR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\u0018J\u001a'pO\u0006\u0003\b/\u001a8e\r\u0006LGn\u001d\u0015\u0004\u000b\n=\u0013AJ:i_VdGMT8u%\u0016lwN^3P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001aaIa\u0014\u0002WMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\f%m\u001c:u)J\fgn]1di&|g.\u00197JIND3a\u0012B(\u00031\u001a\bn\\;mI:{GOU3n_Z,\u0007K]3qCJ,7i\\7nSR$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002I\u0005\u001f\n\u0001\u0007^3tiR\u0013\u0018M\\:bGRLwN\\1m\u000bb\u0004\u0018N]1uS>tw+\u001b;i)>|7+\\1mY\n\u000bGo\u00195TSj,\u0007fA%\u0003P\u0005aC/Z:u)J\fgn]1di&|g.\u00197FqBL'/\u0019;j_:<\u0016\u000e\u001e5PM\u001ad\u0017N\\3M_\u001e$\u0015N\u001d\u0015\u0004\u0015\n=\u0013a\f;fgR$&/\u00198tC\u000e$\u0018n\u001c8FqBL'/\u0019;j_:\u001c\u0006n\\;mIJ+7\u000f]3di\n\u000bGo\u00195TSj,\u0007fA&\u0003P\u0005)3m\u001c7mK\u000e$HK]1og\u0006\u001cG/[8oC2LEm\u001d$s_6$v.\u001c2ti>tWm\u001d\u000b\u0005\u0005+\u0014Y\u000e\u0005\u0004\u00020\n]\u0017QV\u0005\u0005\u00053\f\tMA\u0002TKRDqA!8M\u0001\u0004\u0011y.A\bbaB,g\u000eZ3e%\u0016\u001cwN\u001d3t!\u001d\tyB!9\u007f\u0005GLA!!;\u0002\"A1\u0011q\u0004Bs\u0005SLAAa:\u0002\"\t1!)\u001e4gKJ\u0004B!a\f\u0003l&!!Q^A\u0019\u00055iU-\\8ssJ+7m\u001c:eg\u0006YBn\\1e\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIN$BA!6\u0003t\"1!Q_'A\u0002Q\f1C\\;n)J\fgn]1di&|g.\u00197JIN\fQ\u0004\\5ti\u0016C\b/\u001b:bE2,GK]1og\u0006\u001cG/[8oC2LEm\u001d\u000b\u0003\u0005+\f1\u0004^3tiN+8mY3tg\u001a,HNU3j[6LwM]1uS>t\u0007fA(\u0003P\u0005YC/Z:u\u0019>\fG\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;fI2{w\rK\u0002Q\u0005\u001f\n!E^3sS\u001aLX*\u001a;bI\u0006$\u0018\rR8fg\u0016C\u0018n\u001d;B]\u0012L5/V:bE2,G\u0003\u0002B\u0001\u0007\u000fAqa!\u0003R\u0001\u0004\ti+A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0003e1XM]5gs6+G/\u00193bi\u0006$u.Z:oi\u0016C\u0018n\u001d;\u0015\t\t\u00051q\u0002\u0005\b\u0007\u0013\u0011\u0006\u0019AAW\u0003})\u0007\u0010]3diR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\u0007\u0005\u0003\u0019)b!\u0007\t\u000f\r]1\u000b1\u0001\u0003\u001c\u0005Y\u0011\r\u001d9f]\u0012,%O]8s\u0011\u001d\u0019Yb\u0015a\u0001\u0005?\fqbY1qiV\u0014X\rZ!qa\u0016tGm]\u0001\u001eY>\fG\r\u0016:b]N\f7\r^5p]N4uN\u001d)beRLG/[8ogR!!\u0011AB\u0011\u0011\u001d\u0019\u0019\u0003\u0016a\u0001\u0007K\tA\u0002]1si&$\u0018n\u001c8JIN\u0004Raa\n\u00042QtAa!\u000b\u0004.9!\u00111WB\u0016\u0013\u0005Y\u0017bAB\u0018U\u00069\u0001/Y2lC\u001e,\u0017\u0002BB\u001a\u0007k\u00111aU3r\u0015\r\u0019yC[\u0001\u0010Kb\u0004Xm\u0019;M_\u001e\u001cuN\u001c4jOR1!\u0011AB\u001e\u0007{Aqaa\tV\u0001\u0004\u0019)\u0003\u0003\u0004\u0004@U\u0003\r\u0001^\u0001\r[\u0006D()\u0019;dQNK'0Z\u0001%g\u0016$X\u000f]!oIJ+h\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]R1!\u0011AB#\u0007\u0013Bqaa\u0012W\u0001\u0004\u0011Y\"A\u0003feJ|'\u000fC\u0004\u0004LY\u0003\ra!\u0014\u0002\u0011QDhn\u0015;bi\u0016\u00042!]B(\u0013\r\u0019\t\u0006\u0019\u0002\u0011)J\fgn]1di&|gn\u0015;bi\u0016\fAE^3sS\u001aLxK]5uKN$\u0006P\\'be.,'o]%o!J,\u0007/\u0019:f'R\fG/\u001a\u000b\u0005\u0005\u0003\u00199\u0006C\u0004\u0004Z]\u0003\ra!\u0014\u0002\u000bM$\u0018\r^3\u0002\u001d\u0005\u001c8/\u001a:u\u0007\u0006dGNY1dWR!!\u0011AB0\u0011\u001d\u00199\u0005\u0017a\u0001\u00057\t1\u0003\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006$\"\"a>\u0004f\r\u001d41NB7\u0011\u001d\u0019I!\u0017a\u0001\u0003[Cqa!\u001bZ\u0001\u0004\tY/\u0001\u0006qe>$WoY3s\u0013\u0012D\u0011b!\u0017Z!\u0003\u0005\ra!\u0014\t\u0011\r=\u0014\f%AA\u0002Q\f!\u0002\u001e=o)&lWm\\;u\u0003u!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTCAB;U\u0011\u0019iea\u001e,\u0005\re\u0004\u0003BB>\u0007\u000bk!a! \u000b\t\r}4\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa!k\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u000f\u001biHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u001bS3\u0001^B<\u00035\u0001(/\u001a9be\u0016$\u0006P\u001c'pORA!\u0011ABJ\u0007+\u001bI\nC\u0003}9\u0002\u0007a\u0010C\u0004\u0004\u0018r\u0003\r!a;\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u00077c\u0006\u0019\u0001Bu\u0003\u001d\u0011XmY8sIN\f!\u0004\u001d:fa\u0006\u0014XMR8s)btW*Z:tC\u001e,\u0017\t\u001d9f]\u0012$BA!\u0001\u0004\"\"91qI/A\u0002\tm\u0011a\u0006;fgR\u0004\u0016M\u001d;ji&|g\u000eT8bI6+GO]5dQ\rq&q\n")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        Assert.assertEquals((long)0L, (long)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assert.assertEquals((long)1L, (long)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    @Test
    public void testDeleteLoadingPartition() {
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))});
        CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, latch, bufferCapture, records){
            private final CountDownLatch latch$1;
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                this.latch$1.await();
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.latch$1 = latch$1;
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable & scala.Serializable)(x$2, x$3, x$4, x$5) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$2(BoxesRunTime.unboxToInt((Object)x$2), x$3, x$4, x$5);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$3 = 10L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                throw Assertions$.MODULE$.fail(TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(x$4, x$3));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assert.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assert.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        Either either = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either == null) {
            throw null;
        }
        Either fold_this = either;
        if (fold_this instanceof Right) {
            Option option = (Option)((Right)fold_this).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        }
        if (!(fold_this instanceof Left)) {
            throw new MatchError((Object)fold_this);
        }
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1((Errors)((Left)fold_this).value());
        Either either2 = this.transactionManager().getTransactionState(this.transactionalId2());
        if (either2 == null) {
            throw null;
        }
        Either fold_this2 = either2;
        if (fold_this2 instanceof Right) {
            Option option = (Option)((Right)fold_this2).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }
        if (!(fold_this2 instanceof Left)) {
            throw new MatchError((Object)fold_this2);
        }
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3((Errors)((Left)fold_this2).value());
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$8, x$9, x$10, x$11) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$8), x$9, x$10, x$11);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Either either3 = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either3 == null) {
            throw null;
        }
        Either fold_this3 = either3;
        if (!(fold_this3 instanceof Right)) {
            if (fold_this3 instanceof Left) {
                Errors errors = (Errors)((Left)fold_this3).value();
                throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(errors).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            }
            throw new MatchError((Object)fold_this3);
        }
        Option option = (Option)((Right)fold_this3).value();
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$7(this, option);
        Either either4 = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either4 == null) {
            throw null;
        }
        Either fold_this4 = either4;
        if (!(fold_this4 instanceof Right)) {
            if (fold_this4 instanceof Left) {
                Errors errors = (Errors)((Left)fold_this4).value();
                throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(errors).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            }
            throw new MatchError((Object)fold_this4);
        }
        Option option2 = (Option)((Right)fold_this4).value();
        CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata = TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$10(this, option2);
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = coordinatorEpochAndTxnMetadata;
        Either either5 = this.transactionManager().getTransactionState(this.transactionalId2());
        if (either5 == null) {
            throw null;
        }
        Either fold_this5 = either5;
        if (!(fold_this5 instanceof Right)) {
            if (fold_this5 instanceof Left) {
                Errors errors = (Errors)((Left)fold_this5).value();
                throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(errors).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            }
            throw new MatchError((Object)fold_this5);
        }
        Option option3 = (Option)((Right)fold_this5).value();
        CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata2 = TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$13(this, option3);
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = coordinatorEpochAndTxnMetadata2;
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        Either either6 = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either6 == null) {
            throw null;
        }
        Either fold_this6 = either6;
        if (fold_this6 instanceof Right) {
            Option option4 = (Option)((Right)fold_this6).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }
        if (!(fold_this6 instanceof Left)) {
            throw new MatchError((Object)fold_this6);
        }
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15((Errors)((Left)fold_this6).value());
        Either either7 = this.transactionManager().getTransactionState(this.transactionalId2());
        if (either7 == null) {
            throw null;
        }
        Either fold_this7 = either7;
        if (fold_this7 instanceof Right) {
            Option option5 = (Option)((Right)fold_this7).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        }
        if (fold_this7 instanceof Left) {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17((Errors)((Left)fold_this7).value());
            return;
        }
        throw new MatchError((Object)fold_this7);
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$14)));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        Either either = this.transactionManager().getTransactionState(this.transactionalId1());
        if (either == null) {
            throw null;
        }
        Either fold_this = either;
        if (fold_this instanceof Right) {
            Option option = (Option)((Right)fold_this).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        }
        if (fold_this instanceof Left) {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1((Errors)((Left)fold_this).value());
            return;
        }
        throw new MatchError((Object)fold_this);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.numPartitions());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TransactionStateManagerTest.$anonfun$shouldOnlyConsiderTransactionsInTheOngoingStateToAbort$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range partitionIds = RichInt$.MODULE$.until$extension0(n, this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        attemptedAppends.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        EasyMock.expect((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).andStubReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.partition()), scala.collection.Set$.MODULE$.canBuildFrom()));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set set = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)tuple2._2();
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = set;
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = set2;
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assert.assertEquals((Object)transactionalIdsForOnlinePartition, expiredTransactionalIds);
        Assert.assertEquals((Object)transactionalIdsForOfflinePartition, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range partitionIds = RichInt$.MODULE$.until$extension0(n, this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assert.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partition()), Iterable$.MODULE$.canBuildFrom()));
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assert.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable & scala.Serializable)batches -> {
            batches.foreach((Function1 & Serializable & scala.Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = Set$.MODULE$.empty();
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, numTransactionalIds);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach_this = inclusive;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((TraversableOnce)((Iterable)this.transactionManager().transactionMetadataCache().values().flatMap((Function1 & Serializable & scala.Serializable)x$20 -> (Iterable)x$20.metadataPerTransactionalId().values().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.transactionalId(), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$3(this, transactionalId)))).toSet();
    }

    @Test
    public void testSuccessfulReimmigration() {
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$22, x$23, x$24, x$25) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$22), x$23, x$24, x$25);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable & scala.Serializable)(x$26, x$27, x$28, x$29) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$26), x$27, x$28, x$29);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
        Assert.assertTrue((boolean)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).isDefined());
        Assert.assertEquals((long)1L, (long)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$30, x$31, x$32, x$33) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$30), x$31, x$32, x$33);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{logMock});
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assert.assertEquals((long)0L, (long)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            Assert.assertTrue((String)"metadata shouldn't be in a pending state", (boolean)metadata.transactionMetadata().pendingState().isEmpty());
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError);
            return BoxedUnit.UNIT;
        }).anyTimes();
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)EasyMock.mock(LogConfig.class);
        EasyMock.expect((Object)logConfig.maxMessageSize()).andStubReturn((Object)Predef$.MODULE$.int2Integer(maxBatchSize));
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> EasyMock.expect((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).andStubReturn((Object)new Some((Object)logConfig)));
        EasyMock.replay((Object[])new Object[]{logConfig});
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range partitionIds = RichInt$.MODULE$.until$extension0(n, this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, Defaults$.MODULE$.MaxMessageSize());
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        boolean bl = Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState));
        boolean bl2 = bl;
        if (bl2) {
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            MemoryRecords expectedRecords = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{expectedTombstone});
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assert.assertEquals((Object)new .colon.colon((Object)expectedRecords, (List)Nil$.MODULE$), (Object)((SeqLike)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assert.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$2;
            private final MemoryRecords records$2;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$2.getValue();
                buffer.put(this.records$2.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$2 = bufferCapture$2;
                this.records$2 = records$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testPartitionLoadMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assert.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assert.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable & scala.Serializable)(x$34, x$35, x$36, x$37) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$34), x$35, x$36, x$37);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        Option option = this.transactionManager().getTransactionState(transactionalId).toOption().flatten(Predef$.MODULE$.$conforms());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1((CoordinatorEpochAndTxnMetadata)map_this.get())));
        return object;
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$2(int x$2, TransactionResult x$3, TransactionMetadata x$4, TxnTransitMetadata x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$3(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$4() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$8, TransactionResult x$9, TransactionMetadata x$10, TxnTransitMetadata x$11) {
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$testLoadAndRemoveTransactionsForPartition$7(TransactionStateManagerTest $this, Option entry) {
        if (entry == null) {
            throw null;
        }
        if (entry.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(50).append($this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }
        return (CoordinatorEpochAndTxnMetadata)entry.get();
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$testLoadAndRemoveTransactionsForPartition$10(TransactionStateManagerTest $this, Option entry) {
        if (entry == null) {
            throw null;
        }
        if (entry.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(50).append($this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }
        return (CoordinatorEpochAndTxnMetadata)entry.get();
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$testLoadAndRemoveTransactionsForPartition$13(TransactionStateManagerTest $this, Option entry) {
        if (entry == null) {
            throw null;
        }
        if (entry.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(50).append($this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        }
        return (CoordinatorEpochAndTxnMetadata)entry.get();
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$14) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$shouldOnlyConsiderTransactionsInTheOngoingStateToAbort$1(TransactionStateManagerTest $this, int partitionId) {
        $this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assert.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$19) {
        return x$19.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assert.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)batches.forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$19))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assert.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = new StringBuilder(3).append("id_").append(i).toString();
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, $this.transactionMetadata$default$3(), $this.transactionMetadata$default$4());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$3(TransactionStateManagerTest $this, String transactionalId) {
        boolean bl;
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            bl = $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$22, TransactionResult x$23, TransactionMetadata x$24, TxnTransitMetadata x$25) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$26, TransactionResult x$27, TransactionMetadata x$28, TxnTransitMetadata x$29) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$30, TransactionResult x$31, TransactionMetadata x$32, TxnTransitMetadata x$33) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(Capture callbackCapture$1, Capture recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((TraversableOnce)((TraversableLike)recordsCapture$1.getValue()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                MemoryRecords records = (MemoryRecords)x0$1._2();
                ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                    void var2_2;
                    void $minus$greater$extension_$this;
                    Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    capturedAppends$1.$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)batches));
                    return var2_2;
                })).$plus$eq((Object)records);
                ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, Capture capturedArgument$1, Errors error$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ((Function1)capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$34, TransactionResult x$35, TransactionMetadata x$36, TxnTransitMetadata x$37) {
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManagerTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = BoxesRunTime.boxToLong((long)1L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l2 = BoxesRunTime.boxToLong((long)2L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$1$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$3$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$15$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadAndRemoveTransactionsForPartition$17$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1$adapted(Errors err) {
        TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1$adapted(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, Object i) {
        return TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1($this, allTransactionalIds$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testDeletePartition$1$adapted(CoordinatorEpochAndTxnMetadata x$1) {
        return BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1));
    }
}

