/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u00193\u0001]BQ\u0001\u0010\u0001\u0005\u0002uBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u0019\u0011\u0006\u0001)A\u0005\u0019\"91\u000b\u0001b\u0001\n\u0003Y\u0005B\u0002+\u0001A\u0003%A\nC\u0003V\u0001\u0011\u0005c\u000bC\u0003f\u0001\u0011%a\rC\u0003v\u0001\u0011%a\u000f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\u000b\u0001\t\u0003\t\t\u0002C\u0004\u00020\u0001!\t!!\u0005\t\u000f\u0005M\u0002\u0001\"\u0001\u0002\u0012!9\u0011q\u0007\u0001\u0005\u0002\u0005E\u0001bBA\u001e\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u007f\u0001A\u0011AA\t\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003#Aq!a\u0012\u0001\t\u0003\t\t\u0002C\u0004\u0002L\u0001!\t!!\u0005\t\u000f\u0005=\u0003\u0001\"\u0001\u0002\u0012!9\u00111\u000b\u0001\u0005\u0002\u0005E\u0001bBA,\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u00037\u0002A\u0011AA\t\u0011\u001d\ty\u0006\u0001C\u0001\u0003#Aq!a\u0019\u0001\t\u0003\t\t\u0002C\u0004\u0002h\u0001!\t!!\u0005\t\u000f\u0005-\u0004\u0001\"\u0001\u0002\u0012!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0001bBA:\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003o\u0002A\u0011AA\t\u0011\u001d\tY\b\u0001C\u0001\u0003#Aq!a \u0001\t\u0003\t\t\u0002C\u0004\u0002\u0004\u0002!\t!!\u0005\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0006\"CA]\u0001E\u0005I\u0011BA^\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'D\u0011\"a9\u0001#\u0003%I!!:\t\u0013\u0005%\b!%A\u0005\n\u0005\u0015\bbBAv\u0001\u0011%\u0011Q\u001e\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011%\u0011\u0019\u0003AI\u0001\n\u0013\u0011)\u0003C\u0005\u0003*\u0001\t\n\u0011\"\u0003\u0003,!9!q\u0006\u0001\u0005\n\tE\u0002b\u0002B*\u0001\u0011%!Q\u000b\u0002\u001d%\u0016\u001cX\r^\"p]N,X.\u001a:He>,\bo\u00144gg\u0016$H+Z:u\u0015\t\u0019D'A\u0003bI6LgNC\u00016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005eRT\"\u0001\u001a\n\u0005m\u0012$\u0001G\"p]N,X.\u001a:He>,\boQ8n[\u0006tG\rV3ti\u00061A(\u001b8jiz\"\u0012A\u0010\t\u0003s\u0001\tqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005kRLGNC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!aT#\u0002\t1\fgnZ\u0005\u0003#:\u0013aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001X!\rAVlX\u0007\u00023*\u0011!lW\u0001\u000bG>dG.Z2uS>t'\"\u0001/\u0002\u000bM\u001c\u0017\r\\1\n\u0005yK&aA*fcB\u0011\u0001mY\u0007\u0002C*\u0011!\rN\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0011\f'aC&bM.\f7i\u001c8gS\u001e\f\u0011BY1tS\u000e\f%oZ:\u0016\u0003\u001d\u00042\u0001[5l\u001b\u0005Y\u0016B\u00016\\\u0005\u0015\t%O]1z!\ta7O\u0004\u0002ncB\u0011anW\u0007\u0002_*\u0011\u0001ON\u0001\u0007yI|w\u000e\u001e \n\u0005I\\\u0016A\u0002)sK\u0012,g-\u0003\u0002Ri*\u0011!oW\u0001\u0013EVLG\u000eZ!sON4uN]$s_V\u00048\u000fF\u0002hojDQ\u0001\u001f\u0006A\u0002e\faa\u001a:pkB\u001c\bc\u0001-^W\")1P\u0003a\u0001y\u0006!\u0011M]4t!\rAWp[\u0005\u0003}n\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003E\u0011W/\u001b7e\u0003J<7OR8s\u000fJ|W\u000f\u001d\u000b\u0006O\u0006\r\u0011q\u0001\u0005\u0007\u0003\u000bY\u0001\u0019A6\u0002\u000b\u001d\u0014x.\u001e9\t\u000bm\\\u0001\u0019\u0001?\u0002+\t,\u0018\u000e\u001c3Be\u001e\u001chi\u001c:BY2<%o\\;qgR\u0019q-!\u0004\t\u000bmd\u0001\u0019\u0001?\u0002AQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001chj\u001c;Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u000b\u0003\u0003'\u00012\u0001[A\u000b\u0013\r\t9b\u0017\u0002\u0005+:LG\u000fK\u0002\u000e\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0003kk:LGO\u0003\u0002\u0002&\u0005\u0019qN]4\n\t\u0005%\u0012q\u0004\u0002\u0005)\u0016\u001cH/A\u000fuKN$(+Z:fi>3gm]3ug\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\rq\u00111D\u0001,i\u0016\u001cHOU3tKR|eMZ:fiN,\u00050[:uS:<Gk\u001c9jGN+G.Z2uK\u0012<%o\\;qg\"\u001aq\"a\u0007\u0002MQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cX\t_5ti&tw\rV8qS\u000e\fE\u000e\\$s_V\u00048\u000fK\u0002\u0011\u00037\t!\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:BY2$v\u000e]5dg\u0006cGn\u0012:pkB\u001c\bfA\t\u0002\u001c\u0005yB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3)\u0007I\tY\"A\u0010uKN$(+Z:fi>3gm]3ugR{'l\u001c8fI\u0012\u000bG/\u001a+j[\u0016D3aEA\u000e\u0003i!Xm\u001d;SKN,Go\u00144gg\u0016$8OQ=EkJ\fG/[8oQ\r!\u00121D\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN\u0014\u0015\u0010R;sCRLwN\u001c+p\u000b\u0006\u0014H.[3ti\"\u001aQ#a\u0007\u00025Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\\#be2LWm\u001d;)\u0007Y\tY\"\u0001\ruKN$(+Z:fi>3gm]3ugR{G*\u0019;fgRD3aFA\u000e\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0015\u00041\u0005m\u0011\u0001\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>\u001c\u0006/Z2jM&\u001cwJ\u001a4tKRD3!GA\u000e\u0003e!Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMR\u0004F.^:)\u0007i\tY\"\u0001\u000euKN$(+Z:fi>3gm]3ugNC\u0017N\u001a;NS:,8\u000fK\u0002\u001c\u00037\t\u0001\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=M_^,'\u000f\u00165b]\u0016\u000b'\u000f\\5fgRD3\u0001HA\u000e\u0003\u001d\"Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMR\u0014\u0015\u0010S5hQ\u0016\u0014H\u000b[1o\u0019\u0006$Xm\u001d;)\u0007u\tY\"\u0001\u0013uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148P]\u0016$v\u000e]5dQ\rq\u00121D\u00011i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8)\u0007}\tY\"\u0001\u0012uKN$(+Z:fi>3gm]3ugR{W)\u0019:mS\u0016\u001cHo\u00148U_BL7m\u001d\u0015\u0004A\u0005m\u0011a\f;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\u001c+pa&\u001c7/\u00118e!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0011\u0002\u001c\u0005qC/Z:u%\u0016\u001cX\r^(gMN,Go]#ya>\u0014H/S7q_J$\b\u000b\\1o'&tw\r\\3He>,\b/\u0011:hQ\r\u0011\u00131D\u0001!i\u0016\u001cHOU3tKR|eMZ:fiN,\u0005\u0010]8si&k\u0007o\u001c:u!2\fg\u000eK\u0002$\u00037\t!\u0006^3tiJ+7/\u001a;XSRDWK\u001c:fG><g.\u001b>fI:+woQ8ogVlWM](qi&|g\u000eK\u0004%\u00037\t9)!#\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!a#\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS!!!%\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0003\u0002\u0016\u0006=%aD(qi&|g.\u0012=dKB$\u0018n\u001c8\u0002\u001fA\u0014x\u000eZ;dK6+7o]1hKN$b!a\u0005\u0002\u001c\u0006}\u0005BBAOK\u0001\u00071.A\u0003u_BL7\rC\u0004\u0002\"\u0016\u0002\r!a)\u0002\u00179,X.T3tg\u0006<Wm\u001d\t\u0004Q\u0006\u0015\u0016bAAT7\n\u0019\u0011J\u001c;\u00023A\u0014x\u000eZ;dK\u000e{gn];nK\u0006sGm\u00155vi\u0012|wO\u001c\u000b\u000b\u0003'\ti+a,\u00022\u0006U\u0006BBAOM\u0001\u00071\u000e\u0003\u0004\u0002\u0006\u0019\u0002\ra\u001b\u0005\b\u0003g3\u0003\u0019AAR\u00035!x\u000e^1m\u001b\u0016\u001c8/Y4fg\"I\u0011q\u0017\u0014\u0011\u0002\u0003\u0007\u00111U\u0001\r]Vl7i\u001c8tk6,'o]\u0001$aJ|G-^2f\u0007>t7/^7f\u0003:$7\u000b[;uI><h\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\tiL\u000b\u0003\u0002$\u0006}6FAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-7,\u0001\u0006b]:|G/\u0019;j_:LA!a4\u0002F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\u0005<\u0018-\u001b;D_:\u001cX/\\3s!J|wM]3tgRA\u00111CAk\u0003/\fI\u000e\u0003\u0005\u0002\u001e\"\u0002\n\u00111\u0001l\u0011!\t)\u0001\u000bI\u0001\u0002\u0004Y\u0007bBAnQ\u0001\u0007\u0011Q\\\u0001\u0006G>,h\u000e\u001e\t\u0004Q\u0006}\u0017bAAq7\n!Aj\u001c8h\u0003}\tw/Y5u\u0007>t7/^7feB\u0013xn\u001a:fgN$C-\u001a4bk2$H%M\u000b\u0003\u0003OT3a[A`\u0003}\tw/Y5u\u0007>t7/^7feB\u0013xn\u001a:fgN$C-\u001a4bk2$HEM\u0001\u001bC^\f\u0017\u000e^\"p]N,X.\u001a:He>,\b/\u00138bGRLg/\u001a\u000b\u0007\u0003'\tyO!\u0003\t\u000f\u0005E8\u00061\u0001\u0002t\u0006!2m\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016\u0004B!!>\u0003\u00049!\u0011q_A\u0000\u001d\u0011\tI0!@\u000f\u00079\fY0C\u00016\u0013\t\u0019D'C\u0002\u0003\u0002I\nAcQ8ogVlWM]$s_V\u00048i\\7nC:$\u0017\u0002\u0002B\u0003\u0005\u000f\u0011AcQ8ogVlWM]$s_V\u00048+\u001a:wS\u000e,'b\u0001B\u0001e!1\u0011QA\u0016A\u0002-\fQC]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000f\u0006\u0006\u0002\u0014\t=!\u0011\u0003B\u000b\u0005?AQa\u001f\u0017A\u0002\u001dDqAa\u0005-\u0001\u0004\ti.\u0001\bfqB,7\r^3e\u001f\u001a47/\u001a;\t\u0013\t]A\u0006%AA\u0002\te\u0011A\u00023ssJ+h\u000eE\u0002i\u00057I1A!\b\\\u0005\u001d\u0011un\u001c7fC:D\u0001B!\t-!\u0003\u0005\r!_\u0001\u0007i>\u0004\u0018nY:\u0002?I,7/\u001a;B]\u0012\f5o]3si>3gm]3ug\u0012\"WMZ1vYR$3'\u0006\u0002\u0003()\"!\u0011DA`\u0003}\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005[Q3!_A`\u0003y\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN\u001cu.\\7jiR,G\r\u0006\u0005\u0002\u0014\tM\"Q\u0007B)\u0011\u001d\t\tp\fa\u0001\u0003gDqAa\u000e0\u0001\u0004\u0011I$A\bfqB,7\r^3e\u001f\u001a47/\u001a;t!\u001da'1\bB \u0003;L1A!\u0010u\u0005\ri\u0015\r\u001d\t\u0005\u0005\u0003\u0012i%\u0004\u0002\u0003D)!!Q\tB$\u0003\u0019\u0019w.\\7p]*\u0019QG!\u0013\u000b\t\t-\u00131E\u0001\u0007CB\f7\r[3\n\t\t=#1\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tij\fa\u0001W\u0006a!/Z:fi>3gm]3ugR!!q\u000bB7!\u0019A&\u0011L6\u0003\\%\u0019!QH-\u0011\u000fa\u0013IFa\u0010\u0003^A!!q\fB5\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001C2p]N,X.\u001a:\u000b\t\t\u001d$qI\u0001\bG2LWM\u001c;t\u0013\u0011\u0011YG!\u0019\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0002rB\u0002\r!a=")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private String[] basicArgs() {
        return (String[])((Object[])new String[]{"--reset-offsets", "--bootstrap-server", this.brokerList(), "--timeout", ((Object)BoxesRunTime.boxToLong((long)15000L)).toString()});
    }

    private String[] buildArgsForGroups(Seq<String> groups, Seq<String> args) {
        String[] groupArgs = (String[])((TraversableOnce)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> new .colon.colon((Object)"--group", (List)new .colon.colon(group, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupArgs)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private String[] buildArgsForGroup(String group, Seq<String> args) {
        return this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group, (List)Nil$.MODULE$), args);
    }

    private String[] buildArgsForAllGroups(Seq<String> args) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.basicArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--all-groups"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus(args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsNotExistingGroup() {
        String group = "missing.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNotExistingGroup$1(consumerGroupCommand, group)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNotExistingGroup$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Map resetOffsets = (Map)consumerGroupCommand.resetOffsets().apply((Object)group);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$2 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets, this.committedOffsets(x$2, group));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String group = "new.group";
        String[] args = this.buildArgsForGroup(group, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsExistingTopicSelectedGroups() {
        void map_bf;
        void map_f;
        this.produceMessages(this.topic(), 100);
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)id -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicSelectedGroups$1(this, BoxesRunTime.unboxToInt((Object)id));
        if (inclusive == null) {
            throw null;
        }
        IndexedSeq groups = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
        String[] args = this.buildArgsForGroups((Seq<String>)groups, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsExistingTopicAllGroups() {
        void map_bf;
        void map_f;
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-offset", "50"}));
        this.produceMessages(this.topic(), 100);
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$2 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$2));
        if (inclusive == null) {
            throw null;
        }
        ((IterableLike)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf)).foreach((Function1 & Serializable & scala.Serializable)group -> {
            ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$2(this, group);
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsAllTopicsAllGroups() {
        void map_bf;
        void map_f;
        void map_bf2;
        void map_f2;
        String[] args = this.buildArgsForAllGroups((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "50"}));
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$3 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$3));
        if (inclusive == null) {
            throw null;
        }
        IndexedSeq topics = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f2, (CanBuildFrom)map_bf2);
        int n2 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive2 = RichInt$.MODULE$.to$extension0(n2, 3);
        CanBuildFrom canBuildFrom2 = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$2(this, BoxesRunTime.unboxToInt((Object)x$4));
        if (inclusive2 == null) {
            throw null;
        }
        IndexedSeq groups = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive2, (Function1)map_f, (CanBuildFrom)map_bf);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.produceMessages(topic, 100);
            return BoxedUnit.UNIT;
        });
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
                ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$5($this, topic, group);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, (Seq<String>)topics);
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, (Seq<String>)topics);
        String[] x$42 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$5 = 50L;
        boolean x$7 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$42, x$5, x$7, (Seq<String>)topics);
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"}));
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-datetime", format.format(checkpoint), "--execute"}));
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT1M", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--by-duration", "PT0.1S", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-latest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-current", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "1", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-50", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "-150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--shift-by", "150", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", this.topic(), "--to-earliest", "--execute"}));
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = priorCommittedOffsets.apply((Object)tp0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l = BoxesRunTime.boxToLong((long)0L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map expectedOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (scala.collection.immutable.Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 1);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map allResetOffsets = (Map)((TraversableLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = BoxesRunTime.boxToLong((long)0L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Long l2 = BoxesRunTime.boxToLong((long)0L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)allResetOffsets);
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Long l3 = BoxesRunTime.boxToLong((long)0L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Long l4 = BoxesRunTime.boxToLong((long)0L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 2);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map allResetOffsets = (Map)((TraversableLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Tuple2[] tuple2Array = new Tuple2[2];
        Integer n = BoxesRunTime.boxToInteger((int)0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)allResetOffsets);
        Long l = BoxesRunTime.boxToLong((long)0L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((Object)priorCommittedOffsets1.toMap(Predef$.MODULE$.$conforms()).$plus(new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2)), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Long l2 = BoxesRunTime.boxToLong((long)0L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((Object)priorCommittedOffsets2.toMap(Predef$.MODULE$.$conforms()).$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y)), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsExportImportPlanSingleGroupArg() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = BoxesRunTime.boxToLong((long)2L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Long l2 = BoxesRunTime.boxToLong((long)2L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)((TraversableLike)exportedOffsets.apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        String[] cgcArgsExec = this.buildArgsForGroup(this.group(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets = this.getConsumerGroupService(cgcArgsExec).resetOffsets();
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Long l3 = BoxesRunTime.boxToLong((long)2L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l4 = BoxesRunTime.boxToLong((long)2L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)((TraversableLike)importedOffsets.apply((Object)this.group())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$2 != null) {
                TopicPartition k = (TopicPartition)x0$2._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$2._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        this.adminZkClient().deleteTopic(topic);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResetOffsetsExportImportPlan() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        String group1 = new StringBuilder(1).append(this.group()).append("1").toString();
        String group2 = new StringBuilder(1).append(this.group()).append("2").toString();
        String topic1 = "bar1";
        String topic2 = "bar2";
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        TopicPartition t1p1 = new TopicPartition(topic1, 1);
        TopicPartition t2p0 = new TopicPartition(topic2, 0);
        TopicPartition t2p1 = new TopicPartition(topic2, 1);
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--to-offset", "2", "--export"}));
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic1, group1, 100, this.produceConsumeAndShutdown$default$4());
        this.produceConsumeAndShutdown(topic2, group2, 100, this.produceConsumeAndShutdown$default$4());
        this.awaitConsumerGroupInactive(consumerGroupCommand, group1);
        this.awaitConsumerGroupInactive(consumerGroupCommand, group2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = BoxesRunTime.boxToLong((long)2L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)t1p0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        Long l2 = BoxesRunTime.boxToLong((long)2L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)t1p1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)((TraversableLike)exportedOffsets.apply((Object)group1)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Long l3 = BoxesRunTime.boxToLong((long)2L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)t2p0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        Long l4 = BoxesRunTime.boxToLong((long)2L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)t2p1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)((TraversableLike)exportedOffsets.apply((Object)group2)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$2 != null) {
                TopicPartition k = (TopicPartition)x0$2._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$2._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        String[] cgcArgsExec = this.buildArgsForGroups((Seq<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets = this.getConsumerGroupService(cgcArgsExec).resetOffsets();
        Tuple2[] tuple2Array3 = new Tuple2[2];
        Long l5 = BoxesRunTime.boxToLong((long)2L);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)t1p0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Long l6 = BoxesRunTime.boxToLong((long)2L);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)t1p1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)), (Object)((TraversableLike)importedOffsets.apply((Object)group1)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$3 != null) {
                TopicPartition k = (TopicPartition)x0$3._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$3._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        Tuple2[] tuple2Array4 = new Tuple2[2];
        Long l7 = BoxesRunTime.boxToLong((long)2L);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)t2p0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Long l8 = BoxesRunTime.boxToLong((long)2L);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)t2p1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)), (Object)((TraversableLike)importedOffsets.apply((Object)group2)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$4 != null) {
                TopicPartition k = (TopicPartition)x0$4._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$4._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        String[] cgcArgsExec2 = this.buildArgsForGroup(group1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"}));
        Map importedOffsets2 = this.getConsumerGroupService(cgcArgsExec2).resetOffsets();
        Tuple2[] tuple2Array5 = new Tuple2[2];
        Long l9 = BoxesRunTime.boxToLong((long)2L);
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)t1p0);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l10 = BoxesRunTime.boxToLong((long)2L);
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)t1p1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5)), (Object)((TraversableLike)importedOffsets2.apply((Object)group1)).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$5 != null) {
                TopicPartition k = (TopicPartition)x0$5._1();
                OffsetAndMetadata v = (OffsetAndMetadata)x0$5._2();
                Long l = BoxesRunTime.boxToLong((long)v.offset());
                Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        this.adminZkClient().deleteTopic(this.topic());
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    private void produceMessages(String topic, int numMessages) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, numMessages).map((Function1 & Serializable & scala.Serializable)x$5 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, String group, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, group, this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        this.awaitConsumerProgress(topic, group, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$4() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitConsumerProgress(String topic, String group, long count) {
        try (KafkaConsumer<String, String> consumer = this.createNoAutoCommitConsumer(group);){
            scala.collection.immutable.Set partitions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).map((Function1 & Serializable & scala.Serializable)partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition()), Buffer$.MODULE$.canBuildFrom())).toSet();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$2(consumer, partitions, count)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$6(this, count, topic, group), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private String awaitConsumerProgress$default$2() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitConsumerGroupInactive(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, String group) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerGroupInactive$1(consumerGroupService, group)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerGroupInactive$2(consumerGroupService, group), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, boolean dryRun, Seq<String> topics) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        scala.collection.immutable.Map expectedOffsets = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            Tuple2[] tuple2Array = new Tuple2[1];
            Long l = BoxesRunTime.boxToLong((long)expectedOffset);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenMap genMap = Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            Object object2 = Predef$.MODULE$.ArrowAssoc(topic);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsetsResultByGroup = this.resetOffsets(consumerGroupCommand);
        try {
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$2(this, resetOffsetsResultByGroup, expectedOffsets, dryRun, topic);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            consumerGroupCommand.close();
        }
    }

    private boolean resetAndAssertOffsets$default$3() {
        return false;
    }

    private Seq<String> resetAndAssertOffsets$default$4() {
        return new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$);
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, scala.collection.immutable.Map<TopicPartition, Object> expectedOffsets, String topic) {
        this.resetOffsets(consumerGroupService).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$2(this, expectedOffsets, topic, x$9);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets();
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsNotExistingGroup$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand$1, String group$1) {
        String string = consumerGroupCommand$1.collectGroupState(group$1).coordinator().host();
        String string2 = "localhost";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsNotExistingGroup$2() {
        return "Can't find a coordinator";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicSelectedGroups$1(ResetConsumerGroupOffsetTest $this, int id) {
        void var2_2;
        String group = new StringBuilder(0).append($this.group()).append(id).toString();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, group, x$1);
        executor.shutdown();
        return var2_2;
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$2) {
        return new StringBuilder(0).append($this.group()).append(x$2).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsExistingTopicAllGroups$2(ResetConsumerGroupOffsetTest $this, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$1 = 100L;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, group, x$1);
        executor.shutdown();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$3) {
        return new StringBuilder(0).append($this.topic()).append(x$3).toString();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$2(ResetConsumerGroupOffsetTest $this, int x$4) {
        return new StringBuilder(0).append($this.group()).append(x$4).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsAllTopicsAllGroups$5(ResetConsumerGroupOffsetTest $this, String topic$1, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(3, topic$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        long x$2 = 100L;
        $this.awaitConsumerProgress(topic$1, group, x$2);
        executor.shutdown();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$2, int x$5) {
        return new ProducerRecord(topic$2, (Object)new byte[100000]);
    }

    public static final /* synthetic */ long $anonfun$awaitConsumerProgress$5() {
        return 0L;
    }

    public static final /* synthetic */ long $anonfun$awaitConsumerProgress$3(long x0$1, OffsetAndMetadata x1$1) {
        Option option = Option$.MODULE$.apply((Object)x1$1);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((OffsetAndMetadata)map_this.get()).offset()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$5()) : object.get();
        return x0$1 + BoxesRunTime.unboxToLong((Object)object2);
    }

    public static final /* synthetic */ boolean $anonfun$awaitConsumerProgress$2(KafkaConsumer consumer$1, scala.collection.immutable.Set partitions$1, long count$1) {
        return BoxesRunTime.unboxToLong((Object)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(consumer$1.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)partitions$1).asJava()).values()).asScala()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$awaitConsumerProgress$3(BoxesRunTime.unboxToLong((Object)x0$1), x1$1)))) == count$1;
    }

    public static final /* synthetic */ String $anonfun$awaitConsumerProgress$6(ResetConsumerGroupOffsetTest $this, long count$1, String topic$3, String group$2) {
        return new StringBuilder(111).append("Expected that consumer group has consumed all messages from topic/partition. ").append("Expected offset: ").append(count$1).append(". Actual offset: ").append($this.committedOffsets(topic$3, group$2).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitConsumerGroupInactive$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1, String group$3) {
        block3: {
            block2: {
                String state;
                String string = state = consumerGroupService$1.collectGroupState(group$3).state();
                String string2 = "Empty";
                if (string != null && string.equals(string2)) break block2;
                String string3 = state;
                String string4 = "Dead";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitConsumerGroupInactive$2(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1, String group$3) {
        return new StringBuilder(56).append("Expected that consumer group is inactive. Actual state: ").append(consumerGroupService$1.collectGroupState(group$3).state()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$5(String topic$4, Tuple2 partitionInfo) {
        String string = ((TopicPartition)partitionInfo._1()).topic();
        return !(string != null ? !string.equals(topic$4) : topic$4 != null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$4(ResetConsumerGroupOffsetTest $this, String topic$4, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, Tuple2 x$7) {
        if (x$7 != null) {
            String group = (String)x$7._1();
            Map partitionInfo2 = (Map)x$7._2();
            Map<TopicPartition, Object> priorOffsets = $this.committedOffsets(topic$4, group);
            Assert.assertEquals((Object)expectedOffsets$1.apply((Object)topic$4), (Object)((TraversableLike)partitionInfo2.filter((Function1 & Serializable & scala.Serializable)partitionInfo -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$5(topic$4, partitionInfo)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if (x0$1 != null) {
                    TopicPartition k = (TopicPartition)x0$1._1();
                    OffsetAndMetadata v = (OffsetAndMetadata)x0$1._2();
                    Long l = BoxesRunTime.boxToLong((long)v.offset());
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)k);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom()));
            Assert.assertEquals(dryRun$1 ? priorOffsets : expectedOffsets$1.apply((Object)topic$4), $this.committedOffsets(topic$4, group));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$2(ResetConsumerGroupOffsetTest $this, Map resetOffsetsResultByGroup$1, scala.collection.immutable.Map expectedOffsets$1, boolean dryRun$1, String topic) {
        resetOffsetsResultByGroup$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$4($this, topic, expectedOffsets$1, dryRun$1, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$4(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, String group$4, Tuple2 x$8) {
        if (x$8 != null) {
            TopicPartition tp = (TopicPartition)x$8._1();
            Assert.assertEquals((long)((OffsetAndMetadata)x$8._2()).offset(), (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$2.apply((Object)tp)));
            Assert.assertEquals((Object)expectedOffsets$2, $this.committedOffsets(topic$5, group$4));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$2(ResetConsumerGroupOffsetTest $this, scala.collection.immutable.Map expectedOffsets$2, String topic$5, Tuple2 x$9) {
        if (x$9 != null) {
            String group = (String)x$9._1();
            ((Map)x$9._2()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$4($this, expectedOffsets$2, topic$5, group, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }

    public static final /* synthetic */ Object $anonfun$awaitConsumerProgress$4$adapted(OffsetAndMetadata x$6) {
        return BoxesRunTime.boxToLong((long)x$6.offset());
    }
}

