/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.controller.StateChangeLogger;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u0001\u001d\u0011Q\"T3uC\u0012\fG/Y\"bG\",'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0005ce>\\WM]%e!\tIq#\u0003\u0002\u0019\u0015\t\u0019\u0011J\u001c;\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\tab\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003\u00163\u0001\u0007a\u0003C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u000b\r\f7\r[3\u0016\u0003\t\u0002Ba\t\u0015+k5\tAE\u0003\u0002&M\u00059Q.\u001e;bE2,'BA\u0014\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003S\u0011\u00121!T1q!\tY#G\u0004\u0002-aA\u0011QFC\u0007\u0002])\u0011qFB\u0001\u0007yI|w\u000e\u001e \n\u0005ER\u0011A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0006\u0011\t\rBcC\u000e\t\u0003o\u0011s!\u0001\u000f\"\u000e\u0003eR!AO\u001e\u0002\u0011I,\u0017/^3tiNT!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\t)aH\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<\u0017BA\":\u0003U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgRL!!\u0012$\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK*\u00111)\u000f\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u0012\u0002\r\r\f7\r[3!\u0011\u001dQ\u0005\u00011A\u0005\n-\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012\u0001\u0014\t\u0004\u001353\u0012B\u0001(\u000b\u0005\u0019y\u0005\u000f^5p]\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0016\u0001E2p]R\u0014x\u000e\u001c7fe&#w\fJ3r)\t\u0011V\u000b\u0005\u0002\n'&\u0011AK\u0003\u0002\u0005+:LG\u000fC\u0004W\u001f\u0006\u0005\t\u0019\u0001'\u0002\u0007a$\u0013\u0007\u0003\u0004Y\u0001\u0001\u0006K\u0001T\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000fi\u0003!\u0019!C\u00057\u0006a\u0011\r\\5wK\n\u0013xn[3sgV\tA\f\u0005\u0003$QYi\u0006C\u00010b\u001b\u0005y&B\u00011\u0005\u0003\u001d\u0019G.^:uKJL!AY0\u0003\r\t\u0013xn[3s\u0011\u0019!\u0007\u0001)A\u00059\u0006i\u0011\r\\5wK\n\u0013xn[3sg\u0002BqA\u001a\u0001C\u0002\u0013%q-\u0001\u0006bY&4XMT8eKN,\u0012\u0001\u001b\t\u0005G!2\u0012\u000e\u0005\u0003kW2\u0014X\"\u0001\u0014\n\u0005%2\u0003CA7q\u001b\u0005q'BA8<\u0003\u001dqW\r^<pe.L!!\u001d8\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\u0005M$X\"A\u001e\n\u0005U\\$\u0001\u0002(pI\u0016Daa\u001e\u0001!\u0002\u0013A\u0017aC1mSZ,gj\u001c3fg\u0002Bq!\u001f\u0001C\u0002\u0013%!0A\u000bqCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006dunY6\u0016\u0003m\u00042\u0001`A\u0006\u001b\u0005i(B\u0001@\u0000\u0003\u0015awnY6t\u0015\u0011\t\t!a\u0001\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001B;uS2T!!!\u0003\u0002\t)\fg/Y\u0005\u0004\u0003\u001bi(A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\u000f\u0005E\u0001\u0001)A\u0005w\u00061\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\\u0007\u0005C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018\u0005\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}A!\u0001\u0006d_:$(o\u001c7mKJLA!a\t\u0002\u001e\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u00033\t!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA!9\u00111\u0006\u0001\u0005\n\u00055\u0012\u0001D4fi\u0016sG\r]8j]R\u001cH\u0003CA\u0018\u0003k\tY%a\u0014\u0011\t)\f\tD]\u0005\u0004\u0003g1#aA*fc\"A\u0011qGA\u0015\u0001\u0004\tI$A\u0004ce>\\WM]:\u0011\u000b\u0005m\u0012Q\t\f\u000f\t\u0005u\u0012\u0011\t\b\u0004[\u0005}\u0012\"A\u0006\n\u0007\u0005\r#\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0013\u0011\n\u0002\t\u0013R,'/\u00192mK*\u0019\u00111\t\u0006\t\u000f\u00055\u0013\u0011\u0006a\u0001Y\u0006aA.[:uK:,'OT1nK\"A\u0011\u0011KA\u0015\u0001\u0004\t\u0019&\u0001\u000egS2$XM]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000fE\u0002\n\u0003+J1!a\u0016\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a\u0017\u0001\t\u0013\ti&\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\t\u0003?\n\t(!\u001e\u0002xA!\u0011\"TA1!\u0019\tY$!\u0012\u0002dA!\u0011QMA6\u001d\rA\u0014qM\u0005\u0004\u0003SJ\u0014\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0013\u0011\ti'a\u001c\u0003#A\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018MC\u0002\u0002jeBq!a\u001d\u0002Z\u0001\u0007!&A\u0003u_BL7\rC\u0004\u0002N\u0005e\u0003\u0019\u00017\t\u0011\u0005e\u0014\u0011\fa\u0001\u0003'\n\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3F]\u0012\u0004x.\u001b8ug\"9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0014\u0001E4fi\u0006c\u0017N^3F]\u0012\u0004x.\u001b8u)\u0019\t\t)a!\u0002\u0006B\u0019\u0011\"\u0014:\t\rU\tY\b1\u0001\u0017\u0011\u001d\ti%a\u001fA\u00021Dq!!#\u0001\t\u0003\tY)\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRA\u0011QRAK\u0003?\u000b\t\u000bE\u0003k\u0003c\ty\t\u0005\u0003\u0002f\u0005E\u0015\u0002BAJ\u0003_\u0012Q\u0002V8qS\u000elU\r^1eCR\f\u0007\u0002CAL\u0003\u000f\u0003\r!!'\u0002\rQ|\u0007/[2t!\u0011Q\u00171\u0014\u0016\n\u0007\u0005ueEA\u0002TKRDq!!\u0014\u0002\b\u0002\u0007A\u000e\u0003\u0006\u0002z\u0005\u001d\u0005\u0013!a\u0001\u0003'Bq!!*\u0001\t\u0003\t9+\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0002\u001a\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0016\u0001F4fi:{g.\u0012=jgRLgn\u001a+pa&\u001c7\u000f\u0006\u0003\u0002\u001a\u0006=\u0006\u0002CAL\u0003S\u0003\r!!'\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006i\u0011n\u001d\"s_.,'/\u00117jm\u0016$B!a\u0015\u00028\"1Q#!-A\u0002YAq!a/\u0001\t\u0003\ti,A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t+\t\ty\f\u0005\u0003k\u0003ci\u0006bBAb\u0001\u0011%\u0011QY\u0001\u0019C\u0012$wJ]+qI\u0006$X\rU1si&$\u0018n\u001c8J]\u001a|Gc\u0002*\u0002H\u0006%\u0017Q\u001a\u0005\b\u0003g\n\t\r1\u0001+\u0011\u001d\tY-!1A\u0002Y\t1\u0002]1si&$\u0018n\u001c8JI\"9\u0011qZAa\u0001\u00041\u0014!C:uCR,\u0017J\u001c4p\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\u0005]\u0017\u0011\\An!\rIQJ\u000e\u0005\b\u0003g\n\t\u000e1\u0001+\u0011\u001d\tY-!5A\u0002YAq!a8\u0001\t\u0003\t\t/\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0002\u0002\u0006\r\u0018Q]At\u0011\u001d\t\u0019(!8A\u0002)Bq!a3\u0002^\u0002\u0007a\u0003C\u0004\u0002N\u0005u\u0007\u0019\u00017\t\r\u0005-\b\u0001\"\u0001L\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#\u0007bBAx\u0001\u0011\u0005\u0011\u0011_\u0001\fkB$\u0017\r^3DC\u000eDW\r\u0006\u0004\u0002t\u0006m\u0018q \t\u0006U\u0006E\u0012Q\u001f\t\u0004g\u0006]\u0018bAA}w\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\u007f\u0003[\u0004\rAF\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u0011\t\u0005\u0011Q\u001ea\u0001\u0005\u0007\tQ#\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fE\u00029\u0005\u000bI1Aa\u0002:\u0005U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgRDqAa\u0003\u0001\t\u0003\u0011i!\u0001\u0005d_:$\u0018-\u001b8t)\u0011\t\u0019Fa\u0004\t\u000f\u0005M$\u0011\u0002a\u0001U!9!1\u0002\u0001\u0005\u0002\tMA\u0003BA*\u0005+A\u0001Ba\u0006\u0003\u0012\u0001\u0007\u0011Q_\u0001\u0003iBDqAa\u0007\u0001\t\u0013\u0011i\"A\nsK6|g/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0004\u0002T\t}!\u0011\u0005\u0005\b\u0003g\u0012I\u00021\u0001+\u0011\u001d\tYM!\u0007A\u0002YA\u0011B!\n\u0001#\u0003%\tAa\n\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t%\"\u0006BA*\u0005WY#A!\f\u0011\t\t=\"\u0011H\u0007\u0003\u0005cQAAa\r\u00036\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005oQ\u0011AC1o]>$\u0018\r^5p]&!!1\bB\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class MetadataCache
implements Logging {
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, UpdateMetadataRequest.PartitionState>> cache;
    private Option<Object> controllerId;
    private final scala.collection.mutable.Map<Object, Broker> aliveBrokers;
    private final scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private final StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, UpdateMetadataRequest.PartitionState>> cache() {
        return this.cache;
    }

    private Option<Object> controllerId() {
        return this.controllerId;
    }

    private void controllerId_$eq(Option<Object> x$1) {
        this.controllerId = x$1;
    }

    private scala.collection.mutable.Map<Object, Broker> aliveBrokers() {
        return this.aliveBrokers;
    }

    private scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes() {
        return this.aliveNodes;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(this.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(String topic, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int partitionId = tuple2._1$mcI$sp();
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
            TopicAndPartition topicPartition = new TopicAndPartition(topic, partitionId);
            Option<Node> maybeLeader = this.getAliveEndpoint(partitionState.basePartitionState.leader, listenerName);
            Buffer replicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom());
            Seq<Node> replicaInfo = this.getEndpoints((Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints((Iterable<Object>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom())), listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": leader not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, partitionId, Node.noNode(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                Buffer isr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom());
                Seq<Node> isrInfo = this.getEndpoints((Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": in sync replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    public Option<Node> getAliveEndpoint(int brokerId, ListenerName listenerName) {
        return this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)brokerId)).map((Function1 & Serializable & scala.Serializable)nodeMap -> (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker `", "` does not have listener with name `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), listenerName})));
        }));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata((String)topic, listenerName, errorUnavailableEndpoints).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom()));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public Set<String> getAllTopics() {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().keySet().toSet());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Set)topics.$minus$minus((GenTraversableOnce)this.cache().keySet()));
    }

    public boolean isBrokerAlive(int brokerId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.aliveBrokers().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))));
    }

    public Seq<Broker> getAliveBrokers() {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveBrokers().values().toBuffer());
    }

    private void addOrUpdatePartitionInfo(String topic, int partitionId, UpdateMetadataRequest.PartitionState stateInfo) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map infos = (scala.collection.mutable.Map)this.cache().getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            infos.update((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)stateInfo);
        });
    }

    public Option<UpdateMetadataRequest.PartitionState> getPartitionInfo(String topic, int partitionId) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((Object)BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get((Object)BoxesRunTime.boxToInteger((int)partitionId))).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.basePartitionState.leader;
            Option option = this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)leaderId));
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        }));
    }

    public Option<Object> getControllerId() {
        return this.controllerId();
    }

    public Seq<TopicPartition> updateCache(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            this.controllerId_$eq((Option<Object>)(n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n))));
            this.aliveNodes().clear();
            this.aliveBrokers().clear();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateCache$2(this, broker);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    UpdateMetadataRequest.PartitionState info = (UpdateMetadataRequest.PartitionState)tuple2._2();
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    if (info.basePartitionState.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo(tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted partition ", " from metadata cache in response to UpdateMetadata "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        this.addOrUpdatePartitionInfo(tp.topic(), tp.partition(), info);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cached leader info ", " for partition ", " in response to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info, tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UpdateMetadata request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cache().contains((Object)topic)));
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(String topic, int partitionId) {
        return this.cache().get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(this, topic, partitionId, infos)));
    }

    public static final /* synthetic */ void $anonfun$updateCache$2(MetadataCache $this, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        $this.aliveBrokers().update((Object)BoxesRunTime.boxToInteger((int)broker.id), (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        $this.aliveNodes().update((Object)BoxesRunTime.boxToInteger((int)broker.id), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(MetadataCache $this, String topic$6, int partitionId$4, scala.collection.mutable.Map infos) {
        infos.remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        Object object = infos.isEmpty() ? $this.cache().remove((Object)topic$6) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        Logging.$init$(this);
        this.cache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.controllerId = None$.MODULE$;
        this.aliveBrokers = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aliveNodes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[MetadataCache brokerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

