/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEventManager;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.server.ConfigType$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0007fm\u0016tG/T1oC\u001e,'\u000f\u0005\u0002\u00179%\u0011QD\u0001\u0002\u0017\u0007>tGO]8mY\u0016\u0014XI^3oi6\u000bg.Y4fe\")q\u0004\u0001C\u0001A\u00051A(\u001b8jiz\"2!\t\u0012$!\t1\u0002\u0001C\u0003\u0004=\u0001\u0007Q\u0003C\u0003\u001b=\u0001\u00071\u0004C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001(!\t1\u0002&\u0003\u0002*\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r-\u0002\u0001\u0015!\u0003(\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f5\u0002!\u0019!C\u0001]\u0005)\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,W#A\u0018\u0011\u0005Y\u0001\u0014BA\u0019\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016Daa\r\u0001!\u0002\u0013y\u0013A\u00069beRLG/[8o'R\fG/Z'bG\"Lg.\u001a\u0011\t\u000fU\u0002!\u0019!C\u0001m\u0005\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKV\tq\u0007\u0005\u0002\u0017q%\u0011\u0011H\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u001c\u0002)I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3!\u0011\u001di\u0004A1A\u0005\u0002y\nA#[:EK2,G/\u001a+pa&\u001cWI\\1cY\u0016$W#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n9!i\\8mK\u0006t\u0007B\u0002%\u0001A\u0003%q(A\u000bjg\u0012+G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006\tBo\u001c9jGN$vNQ3EK2,G/\u001a3\u0016\u00031\u00032!\u0014*U\u001b\u0005q%BA(Q\u0003\u001diW\u000f^1cY\u0016T!!\u0015\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002T\u001d\n\u00191+\u001a;\u0011\u0005UcfB\u0001,[!\t9&\"D\u0001Y\u0015\tIf!\u0001\u0004=e>|GOP\u0005\u00037*\ta\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111L\u0003\u0005\u0007A\u0002\u0001\u000b\u0011\u0002'\u0002%Q|\u0007/[2t)>\u0014U\rR3mKR,G\r\t\u0005\bE\u0002\u0011\r\u0011\"\u0001d\u0003U\u0001\u0018M\u001d;ji&|gn\u001d+p\u0005\u0016$U\r\\3uK\u0012,\u0012\u0001\u001a\t\u0004\u001bJ+\u0007C\u00014j\u001b\u00059'B\u00015\u0005\u0003\u0019\u0019w.\\7p]&\u0011!n\u001a\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007B\u00027\u0001A\u0003%A-\u0001\fqCJ$\u0018\u000e^5p]N$vNQ3EK2,G/\u001a3!\u0011\u001dq\u0007A1A\u0005\u0002-\u000b1\u0004^8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007B\u00029\u0001A\u0003%A*\u0001\u000fu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0011\t\u000bI\u0004A\u0011A:\u0002\t%t\u0017\u000e\u001e\u000b\u0004i^d\bCA\u0005v\u0013\t1(B\u0001\u0003V]&$\b\"\u0002=r\u0001\u0004I\u0018\u0001G5oSRL\u0017\r\u001c+pa&\u001c7\u000fV8CK\u0012+G.\u001a;fIB\u0019!p\u001f+\u000e\u0003AK!a\u0015)\t\u000bu\f\b\u0019A=\u0002E%t\u0017\u000e^5bYR{\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005\u0001BO]=U_BL7\rR3mKRLwN\u001c\u000b\u0002i\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u0005\u0011!\u0002:fg\u0016$\bbBA\u0005\u0001\u0011\u0005\u00111B\u0001\u0019K:\fX/Z;f)>\u0004\u0018nY:G_J$U\r\\3uS>tGc\u0001;\u0002\u000e!9\u0011qBA\u0004\u0001\u0004I\u0018A\u0002;pa&\u001c7\u000fC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002/I,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cHc\u0001;\u0002\u0018!I\u0011qBA\t!\u0003\u0005\r!\u001f\u0005\b\u00037\u0001A\u0011AA\u000f\u0003M1\u0017-\u001b7SKBd\u0017nY1EK2,G/[8o)\r!\u0018q\u0004\u0005\t\u0003C\tI\u00021\u0001\u0002$\u0005A!/\u001a9mS\u000e\f7\u000f\u0005\u0003{w\u0006\u0015\u0002c\u0001\f\u0002(%\u0019\u0011\u0011\u0006\u0002\u0003'A\u000b'\u000f^5uS>t\u0017I\u001c3SKBd\u0017nY1\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u0005qR.\u0019:l)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004i\u0006E\u0002bBA\b\u0003W\u0001\r!\u001f\u0005\b\u0003k\u0001A\u0011BA\u001c\u0003qI7\u000fV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$B!!\u000f\u0002>A\u0019\u0011\"a\u000f\n\u0005\u0019S\u0001bBA \u0003g\u0001\r\u0001V\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003\u0007\u0002A\u0011BA#\u0003eI7\u000fV8qS\u000e$U\r\\3uS>t\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\t\u0005e\u0012q\t\u0005\b\u0003\u007f\t\t\u00051\u0001U\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\na#[:QCJ$\u0018\u000e^5p]R{')\u001a#fY\u0016$X\r\u001a\u000b\u0005\u0003s\ty\u0005C\u0004\u0002R\u0005%\u0003\u0019A3\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002V\u0001!\t!a\u0016\u00025%\u001cHk\u001c9jGF+X-^3e+B4uN\u001d#fY\u0016$\u0018n\u001c8\u0015\t\u0005e\u0012\u0011\f\u0005\b\u0003\u007f\t\u0019\u00061\u0001U\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nqcY8na2,G/\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8\u0015\u0007Q\f\t\u0007\u0003\u0005\u0002\"\u0005m\u0003\u0019AA\u0012\u0011\u001d\t)\u0007\u0001C\u0005\u0003O\n!$[:U_BL7-\u00127jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$B!!\u000f\u0002j!9\u0011qHA2\u0001\u0004!\u0006bBA7\u0001\u0011%\u0011qN\u0001\u001a[\u0006\u00148\u000eV8qS\u000e4uN\u001d#fY\u0016$\u0018n\u001c8SKR\u0014\u0018\u0010F\u0002u\u0003cBq!a\u0010\u0002l\u0001\u0007A\u000bC\u0004\u0002v\u0001!I!a\u001e\u0002'\r|W\u000e\u001d7fi\u0016$U\r\\3uKR{\u0007/[2\u0015\u0007Q\fI\bC\u0004\u0002@\u0005M\u0004\u0019\u0001+\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000\u0005yqN\u001c+pa&\u001cG)\u001a7fi&|g\u000eF\u0002u\u0003\u0003Cq!a\u0004\u0002|\u0001\u0007\u0011\u0010C\u0004\u0002\u0006\u0002!I!a\"\u0002)M$\u0018M\u001d;SKBd\u0017nY1EK2,G/[8o)\r!\u0018\u0011\u0012\u0005\t\u0003\u0017\u000b\u0019\t1\u0001\u0002$\u0005a\"/\u001a9mS\u000e\f7OR8s)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007bBAH\u0001\u0011%\u0011\u0011S\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0004i\u0006M\u0005b\u00022\u0002\u000e\u0002\u0007\u0011Q\u0013\t\u0004un,\u0007bBAM\u0001\u0011%\u0011\u0011A\u0001\u0010e\u0016\u001cX/\\3EK2,G/[8og\"I\u0011Q\u0014\u0001\u0012\u0002\u0013\u0005\u0011qT\u0001\"e\u0016\u001cX/\\3EK2,G/[8o\r>\u0014Hk\u001c9jGN$C-\u001a4bk2$H%M\u000b\u0003\u0003CS3!_ARW\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0013Ut7\r[3dW\u0016$'bAAX\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0016\u0011\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TopicDeletionManager
implements Logging {
    private final KafkaController controller;
    private final ControllerEventManager eventManager;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final Boolean isDeleteTopicEnabled;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(initialTopicsToBeDeleted);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)this.topicsToBeDeleted().flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), scala.collection.mutable.Set$.MODULE$.canBuildFrom()));
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.topicsToBeDeleted()));
        } else {
            ZkUtils zkUtils = this.controllerContext().zkUtils();
            initialTopicsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$init$2(this, zkUtils, topic)));
        }
    }

    public void tryTopicDeletion() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.resumeDeletions();
        }
    }

    public void reset() {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block0;
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom()));
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).nonEmpty()) break block0;
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasThatFailedToDelete.mkString(","), topics})));
            this.controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics);
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        block1: {
            if (!Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newTopicsToHaltDeletion.mkString(",")})));
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains((Object)topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains((Object)topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{successfullyDeletedReplicas.mkString(",")})));
        this.controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, failedReplicas.mkString(",")})));
        this.controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.controller.replicaStateMachine().handleStateChanges$default$3());
    }

    private void completeDeleteTopic(String topic) {
        this.controller.deregisterPartitionModificationsListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.partitionsToBeDeleted().retain((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$completeDeleteTopic$1(topic, x$2)));
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.deletePathRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.deletePathRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.deletePath(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.mkString(",")})));
        Set partitions = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> this.controllerContext().partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
        this.controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicAndPartition>)partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy((Function1 & Serializable & scala.Serializable)p -> ((TopicAndPartition)p._1()).topic());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.onPartitionDeletion((Set<TopicAndPartition>)((MapLike)partitionReplicaAssignmentByTopic.apply((Object)topic)).keySet());
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic()).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeDeleted.mkString(",")})));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handling deletion for topics " + topicsQueuedForDeletion.mkString(","));
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicDeletionManager.$anonfun$resumeDeletions$2(this, topic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$init$2(TopicDeletionManager $this, ZkUtils zkUtils$1, String topic) {
        String deleteTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath(topic);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Removing " + deleteTopicPath + " since delete topic is disabled");
        return zkUtils$1.deletePath(deleteTopicPath);
    }

    public static final /* synthetic */ boolean $anonfun$completeDeleteTopic$1(String topic$2, TopicAndPartition x$2) {
        String string = x$2.topic();
        String string2 = topic$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$3, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext().allLiveReplicas().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, $this.replicaStateMachine().handleStateChanges$default$3());
            $this.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, OfflineReplica$.MODULE$, $this.replicaStateMachine().handleStateChanges$default$3());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicasForDeletionRetry.mkString(",")})));
            $this.controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(stopReplicaResponseObj, replicaId) -> {
                $this.eventManager.put(new KafkaController.TopicDeletionStopReplicaResponseReceived($this.controller, stopReplicaResponseObj, BoxesRunTime.unboxToInt((Object)replicaId)));
                return BoxedUnit.UNIT;
            }).build());
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deadReplicasForTopic.mkString(","), topic})));
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$2(TopicDeletionManager $this, String topic) {
        block6: {
            block5: {
                if ($this.controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                    $this.completeDeleteTopic(topic);
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                } else if ($this.controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                    Set<PartitionAndReplica> replicasInDeletionStartedState = $this.controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                    Set replicaIds = (Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.replica()), Set$.MODULE$.canBuildFrom());
                    Set partitions = (Set)replicasInDeletionStartedState.map((Function1 & Serializable & scala.Serializable)r -> new TopicAndPartition(r.topic(), r.partition()), Set$.MODULE$.canBuildFrom());
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaIds.mkString(","), partitions.mkString(","), topic})));
                } else if ($this.controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    $this.markTopicForDeletionRetry(topic);
                }
                if (!$this.isTopicEligibleForDeletion(topic)) break block5;
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                $this.onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                break block6;
            }
            if (!$this.isTopicIneligibleForDeletion(topic)) break block6;
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public TopicDeletionManager(KafkaController controller, ControllerEventManager eventManager) {
        this.controller = controller;
        this.eventManager = eventManager;
        Logging.$init$(this);
        this.logIdent_$eq("[Topic Deletion Manager " + controller.config().brokerId() + "], ");
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.partitionsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
    }
}

