/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005Q\u0001O]8ek\u000e,'/\u00133\u0004\u0001U\t\u0011\u0003\u0005\u0002\t%%\u00111#\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0012\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011]\u0001!Q1A\u0005\u0002a\tAbY;se\u0016tG/\u00128uef,\u0012!\u0007\t\u00035mi\u0011AA\u0005\u00039\t\u0011!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ss\"Aa\u0004\u0001B\u0001B\u0003%\u0011$A\u0007dkJ\u0014XM\u001c;F]R\u0014\u0018\u0010\t\u0005\tA\u0001\u0011)\u0019!C\u0001C\u0005qa/\u00197jI\u0006$\u0018n\u001c8UsB,W#\u0001\u0012\u0011\u0005i\u0019\u0013B\u0001\u0013\u0003\u000591\u0016\r\\5eCRLwN\u001c+za\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0010m\u0006d\u0017\u000eZ1uS>tG+\u001f9fA!)\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"BAK\u0016-[A\u0011!\u0004\u0001\u0005\u0006\u001d\u001d\u0002\r!\u0005\u0005\u0006/\u001d\u0002\r!\u0007\u0005\u0006A\u001d\u0002\rA\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u00031!(/\u00198tC\u000e$\u0018n\u001c8t+\u0005\t\u0004c\u0001\u001a8s5\t1G\u0003\u00025k\u00059Q.\u001e;bE2,'B\u0001\u001c\n\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003qM\u0012!\u0002T5ti\n+hMZ3s!\tQ\"(\u0003\u0002<\u0005\tYA\u000b\u001f8NKR\fG-\u0019;b\u0011\u0019i\u0004\u0001)A\u0005c\u0005iAO]1og\u0006\u001cG/[8og\u0002Bqa\u0010\u0001C\u0002\u0013%\u0001$\u0001\u0007va\u0012\fG/\u001a3F]R\u0014\u0018\u0010\u0003\u0004B\u0001\u0001\u0006I!G\u0001\u000ekB$\u0017\r^3e\u000b:$(/\u001f\u0011\t\u000b\r\u0003A\u0011\u0002#\u0002'5\f\u0017PY3WC2LG-\u0019;f\u0003B\u0004XM\u001c3\u0015\u0007\u0015CU\n\u0005\u0002\t\r&\u0011q)\u0003\u0002\u0005+:LG\u000fC\u0003J\u0005\u0002\u0007!*A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0003\u0011-K!\u0001T\u0005\u0003\u000bMCwN\u001d;\t\u000b9\u0013\u0005\u0019A(\u0002\u0011\u0019L'o\u001d;TKF\u0004\"\u0001\u0003)\n\u0005EK!aA%oi\")1\u000b\u0001C\u0005)\u0006\u00112\r[3dWB\u0013x\u000eZ;dKJ,\u0005o\\2i)\t)U\u000bC\u0003J%\u0002\u0007!\nC\u0003X\u0001\u0011%\u0001,A\u0007dQ\u0016\u001c7nU3rk\u0016t7-\u001a\u000b\u0004\u000bfS\u0006\"B%W\u0001\u0004Q\u0005\"B.W\u0001\u0004y\u0015AD1qa\u0016tGMR5sgR\u001cV-\u001d\u0005\u0006;\u0002!IAX\u0001\u000bS:\u001cV-];f]\u000e,GcA0cIB\u0011\u0001\u0002Y\u0005\u0003C&\u0011qAQ8pY\u0016\fg\u000eC\u0003d9\u0002\u0007q*A\u0004mCN$8+Z9\t\u000b\u0015d\u0006\u0019A(\u0002\u000f9,\u0007\u0010^*fc\")q\r\u0001C\u0001Q\u00061\u0011\r\u001d9f]\u0012$\"![8\u0011\u0007!QG.\u0003\u0002l\u0013\t1q\n\u001d;j_:\u0004\"AG7\n\u00059\u0014!\u0001D\"p[BdW\r^3e)bt\u0007\"\u00029g\u0001\u0004\t\u0018!\u00022bi\u000eD\u0007C\u0001:}\u001b\u0005\u0019(B\u0001;v\u0003\u0019\u0011XmY8sI*\u0011ao^\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015A(BA={\u0003\u0019\t\u0007/Y2iK*\t10A\u0002pe\u001eL!!`:\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\u0006O\u0002!\ta \u000b\u0010\u000b\u0006\u0005\u0011QAA\u0004\u0003\u0013\ti!!\u0005\u0002\u0016!1\u00111\u0001@A\u0002)\u000bQ!\u001a9pG\"DQA\u0014@A\u0002=CQa\u0019@A\u0002=Ca!a\u0003\u007f\u0001\u0004\t\u0012!\u00047bgR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0002\u0010y\u0004\r!E\u0001\fM&\u00148\u000f^(gMN,G\u000f\u0003\u0004\u0002\u0014y\u0004\r!E\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\bBBA\f}\u0002\u0007q,A\bjgR\u0013\u0018M\\:bGRLwN\\1m\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\t!#\u00199qK:$WI\u001c3Uq:l\u0015M]6feRIA.a\b\u0002*\u0005-\u0012q\u0006\u0005\t\u0003C\tI\u00021\u0001\u0002$\u0005aQM\u001c3Uq:l\u0015M]6feB\u0019!/!\n\n\u0007\u0005\u001d2O\u0001\u000bF]\u0012$&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM\u001d\u0005\u0007\u0013\u0006e\u0001\u0019\u0001&\t\u000f\u00055\u0012\u0011\u0004a\u0001#\u00051qN\u001a4tKRDq!!\r\u0002\u001a\u0001\u0007\u0011#A\u0005uS6,7\u000f^1na\"1\u0011Q\u0007\u0001\u0005\u0002a\tq\u0001^8F]R\u0014\u0018\u0010C\u0004\u0002:\u0001!\t!a\u000f\u0002'M$\u0018M\u001d;fIR\u0013\u0018M\\:bGRLwN\\:\u0016\u0005\u0005u\u0002#BA \u0003\u001fJd\u0002BA!\u0003\u0017rA!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fz\u0011A\u0002\u001fs_>$h(C\u0001\u000b\u0013\r\ti%C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t&a\u0015\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u001bJ\u0001bBA,\u0001\u0011\u0005\u0011\u0011L\u0001![\u0006L(-Z\"bG\",G\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rF\u0002F\u00037B\u0001\"!\u0018\u0002V\u0001\u0007\u0011qL\u0001\u0012Y><wJ\u001a4tKRlU\r^1eCR\f\u0007\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015D!\u0001\u0004tKJ4XM]\u0005\u0005\u0003S\n\u0019GA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006Dq!!\u001c\u0001\t\u0003\ny'\u0001\u0005u_N#(/\u001b8h)\t\t\t\b\u0005\u0003\u0002t\u0005edb\u0001\u0005\u0002v%\u0019\u0011qO\u0005\u0002\rA\u0013X\rZ3g\u0013\u0011\tY(! \u0003\rM#(/\u001b8h\u0015\r\t9(\u0003")
public class ProducerAppendInfo {
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq) {
        ValidationType validationType;
        block5: {
            block3: {
                block4: {
                    block2: {
                        validationType = this.validationType();
                        if (!ValidationType$None$.MODULE$.equals(validationType)) break block2;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!ValidationType$EpochOnly$.MODULE$.equals(validationType)) break block4;
                    this.checkProducerEpoch(producerEpoch);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!ValidationType$Full$.MODULE$.equals(validationType)) break block5;
                this.checkProducerEpoch(producerEpoch);
                this.checkSequence(producerEpoch, firstSeq);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)validationType);
    }

    private void checkProducerEpoch(short producerEpoch) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch is no longer valid. There is probably another producer "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with a newer epoch. ", " (request epoch), ", " (server epoch)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.updatedEntry().producerEpoch())}))).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq) {
        int currentLastSeq;
        block9: {
            block8: {
                block7: {
                    if (producerEpoch == this.updatedEntry().producerEpoch()) break block7;
                    if (appendFirstSeq != 0) {
                        if (this.updatedEntry().producerEpoch() != -1) {
                            throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).toString());
                        }
                        throw new UnknownProducerIdException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found no record of producerId=", " on the broker. It is possible "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"that the last message with the producerId=", " has been removed due to hitting the retention limit."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).toString());
                    }
                    break block8;
                }
                int n = this.updatedEntry().isEmpty() ? (producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1) : (currentLastSeq = this.updatedEntry().lastSeq());
                if (currentLastSeq == -1 && appendFirstSeq != 0) {
                    throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": found ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), but expected 0"})).s((Seq)Nil$.MODULE$)).toString());
                }
                if (!this.inSequence(currentLastSeq, appendFirstSeq)) break block9;
            }
            return;
        }
        throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), ", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentLastSeq)}))).toString());
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record2 = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record2);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record2.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.baseOffset(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long firstOffset, long lastOffset, boolean isTransactional) {
        this.maybeValidateAppend(epoch, firstSeq);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset2, long timestamp2) {
        Option<Object> option;
        block6: {
            long l;
            block5: {
                block4: {
                    long txnFirstOffset;
                    this.checkProducerEpoch(producerEpoch);
                    if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
                        throw new TransactionCoordinatorFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().coordinatorEpoch())}))).toString());
                    }
                    this.updatedEntry().maybeUpdateEpoch(producerEpoch);
                    option = this.updatedEntry().currentTxnFirstOffset();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.x());
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset2));
                l = offset2;
            }
            long firstOffset = l;
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
            this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
            ControlRecordType controlRecordType = endTxnMarker.controlType();
            ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
            return new CompletedTxn(this.producerId(), firstOffset, offset2, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
        }
        throw new MatchError(option);
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1)new Serializable(this, logOffsetMetadata){
            public static final long serialVersionUID = 0L;
            private final LogOffsetMetadata logOffsetMetadata$1;

            public final void apply(TxnMetadata txn) {
                if (txn.firstOffset().messageOffset() == this.logOffsetMetadata$1.messageOffset()) {
                    txn.firstOffset_$eq(this.logOffsetMetadata$1);
                }
            }
            {
                this.logOffsetMetadata$1 = logOffsetMetadata$1;
            }
        });
    }

    public String toString() {
        return new StringBuilder().append((Object)"ProducerAppendInfo(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.updatedEntry().producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().firstSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().lastSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updatedEntry().currentTxnFirstOffset()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updatedEntry().coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}))).toString();
    }

    public ProducerAppendInfo(long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

