/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u001b^\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003\u00111\u0017\u000e\\3\u0016\u0003a\u0001\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u0005%|'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011AAR5mK\"A\u0011\u0005\u0001BA\u0002\u0013\u0005!%\u0001\u0005gS2,w\fJ3r)\t\u0019c\u0005\u0005\u0002\u000bI%\u0011Qe\u0003\u0002\u0005+:LG\u000fC\u0004(A\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005*\u0001\t\u0005\t\u0015)\u0003\u0019\u0003\u00151\u0017\u000e\\3!Q\tA3\u0006\u0005\u0002\u000bY%\u0011Qf\u0003\u0002\tm>d\u0017\r^5mK\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\r\t\u0003\u0015IJ!aM\u0006\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005Y!-Y:f\u001f\u001a47/\u001a;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001D7bq&sG-\u001a=TSj,W#A\u001d\u0011\u0005)Q\u0014BA\u001e\f\u0005\rIe\u000e\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005s\u0005iQ.\u0019=J]\u0012,\u0007pU5{K\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\toJLG/\u00192mKV\t\u0011\t\u0005\u0002\u000b\u0005&\u00111i\u0003\u0002\b\u0005>|G.Z1o\u0011!)\u0005A!A!\u0002\u0013\t\u0015!C<sSR\f'\r\\3!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q)\u0011*\u0017.\\9B!!\nA&W\u001b\u0005\u0011\u0001C\u0001'N\u0019\u0001!QA\u0014\u0001C\u0002=\u0013\u0011aS\t\u0003!N\u0003\"AC)\n\u0005I[!a\u0002(pi\"Lgn\u001a\t\u0003\u0015QK!!V\u0006\u0003\u0007\u0005s\u0017\u0010\u0005\u0002M/\u0012)\u0001\f\u0001b\u0001\u001f\n\ta\u000bC\u0003\u0017\r\u0002\u0007\u0001\u0004C\u00030\r\u0002\u0007\u0011\u0007C\u00048\rB\u0005\t\u0019A\u001d\t\u000b}2\u0005\u0019A!\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0014aB0mK:<G\u000f\u001b\u0005\nA\u0002\u0001\r\u00111A\u0005\n\u0005\f1b\u00187f]\u001e$\bn\u0018\u0013fcR\u00111E\u0019\u0005\bO}\u000b\t\u00111\u00012\u0011\u0019!\u0007\u0001)Q\u0005c\u0005Aq\f\\3oORD\u0007\u0005\u000b\u0002dW!)q\r\u0001D\tq\u0005IQM\u001c;ssNK'0\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0005k\u0003\u0011awnY6\u0016\u0003-\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\u000b1|7m[:\u000b\u0005A\f\u0018AC2p]\u000e,(O]3oi*\u0011!\u000fH\u0001\u0005kRLG.\u0003\u0002u[\ni!+Z3oiJ\fg\u000e\u001e'pG.DaA\u001e\u0001!\u0002\u0013Y\u0017!\u00027pG.\u0004\u0003b\u0002=\u0001\u0001\u0004%\t\"_\u0001\u0005[6\f\u0007/F\u0001{!\tYh0D\u0001}\u0015\tiH$A\u0002oS>L!a ?\u0003!5\u000b\u0007\u000f]3e\u0005f$XMQ;gM\u0016\u0014\b\"CA\u0002\u0001\u0001\u0007I\u0011CA\u0003\u0003!iW.\u00199`I\u0015\fHcA\u0012\u0002\b!Aq%!\u0001\u0002\u0002\u0003\u0007!\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0015\u0002>\u0002\u000b5l\u0017\r\u001d\u0011)\u0007\u0005%1\u0006C\u0004\u0002\u0012\u0001\u0001\u000b\u0015B\u001d\u0002\u0017}k\u0017\r_#oiJLWm\u001d\u0015\u0004\u0003\u001fY\u0003\u0002CA\f\u0001\u0001\u0007I\u0011\u0003\u001d\u0002\u0011}+g\u000e\u001e:jKND\u0011\"a\u0007\u0001\u0001\u0004%\t\"!\b\u0002\u0019}+g\u000e\u001e:jKN|F%Z9\u0015\u0007\r\ny\u0002\u0003\u0005(\u00033\t\t\u00111\u0001:\u0011\u001d\t\u0019\u0003\u0001Q!\ne\n\u0011bX3oiJLWm\u001d\u0011)\u0007\u0005\u00052\u0006\u0003\u0004\u0002*\u0001!\t\u0001Q\u0001\u0007SN4U\u000f\u001c7\t\r\u00055\u0002\u0001\"\u00019\u0003)i\u0017\r_#oiJLWm\u001d\u0005\u0007\u0003c\u0001A\u0011\u0001\u001d\u0002\u000f\u0015tGO]5fg\"1\u0011Q\u0007\u0001\u0005\u0002A\na\u0001\\3oORD\u0007bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0007e\u0016\u001c\u0018N_3\u0015\u0007\u0005\u000bi\u0004C\u0004\u0002@\u0005]\u0002\u0019A\u001d\u0002\u000f9,woU5{K\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013\u0001\u0003:f]\u0006lW\rV8\u0015\u0007\r\n9\u0005C\u0004\u0002J\u0005\u0005\u0003\u0019\u0001\r\u0002\u0003\u0019Dq!!\u0014\u0001\t\u0003\ty%A\u0003gYV\u001c\b\u000eF\u0001$\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\na\u0002Z3mKR,\u0017JZ#ySN$8\u000fF\u0001B\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u001f\nq\u0002\u001e:j[R{g+\u00197jINK'0\u001a\u0005\u0007\u0003;\u0002A\u0011\u0001\u001d\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u0005\b\u0003C\u0002A\u0011AA(\u0003\u0015\u0019Gn\\:f\u0011\u001d\t)\u0007\u0001C\u0001\u0003\u001f\nAb\u00197pg\u0016D\u0015M\u001c3mKJDq!!\u001b\u0001\r\u0003\ty%A\u0006tC:LG/_\"iK\u000e\\\u0007bBA7\u0001\u0019E\u0011qJ\u0001\tiJ,hnY1uK\"9\u0011\u0011\u000f\u0001\u0007\u0002\u0005M\u0014A\u0003;sk:\u001c\u0017\r^3U_R\u00191%!\u001e\t\u000f\u0005]\u0014q\u000ea\u0001c\u00051qN\u001a4tKRDq!a\u001f\u0001\t\u0003\ty%A\u0003sKN,G\u000fC\u0004\u0002\u0000\u0001!\t\"a\u0014\u0002\u001dM\fg-\u001a$pe\u000e,WK\\7ba\"A\u00111\u0011\u0001\u0005\u0012\t\ty%\u0001\u0006g_J\u001cW-\u00168nCBDq!a\"\u0001\t#\tI)A\u0005nCf\u0014W\rT8dWV!\u00111RAI)\u0011\ti)a(\u0015\t\u0005=\u0015Q\u0013\t\u0004\u0019\u0006EEaBAJ\u0003\u000b\u0013\ra\u0014\u0002\u0002)\"I\u0011qSAC\t\u0003\u0007\u0011\u0011T\u0001\u0004MVt\u0007#\u0002\u0006\u0002\u001c\u0006=\u0015bAAO\u0017\tAAHY=oC6,g\bC\u0004j\u0003\u000b\u0003\r!!)\u0011\u00071\f\u0019+C\u0002\u0002&6\u0014A\u0001T8dW\"9\u0011\u0011\u0016\u0001\u0007\u0012\u0005-\u0016A\u00039beN,WI\u001c;ssR1\u0011QVAZ\u0003{\u00032ASAX\u0013\r\t\tL\u0001\u0002\u000b\u0013:$W\r_#oiJL\b\u0002CA[\u0003O\u0003\r!a.\u0002\r\t,hMZ3s!\rY\u0018\u0011X\u0005\u0004\u0003wc(A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u0011qXAT\u0001\u0004I\u0014!\u00018\t\u000f\u0005\r\u0007\u0001\"\u0005\u0002F\u0006AB.\u0019:hKN$Hj\\<fe\n{WO\u001c3TY>$hi\u001c:\u0015\u000fe\n9-a3\u0002P\"A\u0011\u0011ZAa\u0001\u0004\t9,A\u0002jIbDq!!4\u0002B\u0002\u0007\u0011'\u0001\u0004uCJ<W\r\u001e\u0005\t\u0003#\f\t\r1\u0001\u0002T\u0006a1/Z1sG\",e\u000e^5usB!\u0011Q[Au\u001d\u0011\t9.!:\u000f\t\u0005e\u00171\u001d\b\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\u001c\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0002\u0005\u0013\r\t9OA\u0001\u0010\u0013:$W\r_*fCJ\u001c\u0007\u000eV=qK&!\u00111^Aw\u0005EIe\u000eZ3y'\u0016\f'o\u00195F]RLG/\u001f\u0006\u0004\u0003O\u0014\u0001bBAy\u0001\u0011E\u00111_\u0001\u001ag6\fG\u000e\\3tiV\u0003\b/\u001a:C_VtGm\u00157pi\u001a{'\u000fF\u0004:\u0003k\f90!?\t\u0011\u0005%\u0017q\u001ea\u0001\u0003oCq!!4\u0002p\u0002\u0007\u0011\u0007\u0003\u0005\u0002R\u0006=\b\u0019AAj\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007f\f\u0011#\u001b8eKb\u001cFn\u001c;SC:<WMR8s)!\u0011\tAa\u0002\u0003\n\t-\u0001#\u0002\u0006\u0003\u0004eJ\u0014b\u0001B\u0003\u0017\t1A+\u001e9mKJB\u0001\"!3\u0002|\u0002\u0007\u0011q\u0017\u0005\b\u0003\u001b\fY\u00101\u00012\u0011!\t\t.a?A\u0002\u0005M\u0007b\u0002B\b\u0001\u0011%!\u0011C\u0001\u0012G>l\u0007/\u0019:f\u0013:$W\r_#oiJLHcB\u001d\u0003\u0014\t]!\u0011\u0004\u0005\t\u0005+\u0011i\u00011\u0001\u0002.\u0006Q\u0011N\u001c3fq\u0016sGO]=\t\u000f\u00055'Q\u0002a\u0001c!A\u0011\u0011\u001bB\u0007\u0001\u0004\t\u0019\u000eC\u0004\u0003\u001e\u0001!IAa\b\u00021I|WO\u001c3E_^tGk\\#yC\u000e$X*\u001e7uSBdW\rF\u0003:\u0005C\u0011)\u0003C\u0004\u0003$\tm\u0001\u0019A\u001d\u0002\r9,XNY3s\u0011\u001d\u00119Ca\u0007A\u0002e\naAZ1di>\u0014x!\u0003B\u0016\u0005\u0005\u0005\t\u0012\u0001B\u0017\u00035\t%m\u001d;sC\u000e$\u0018J\u001c3fqB\u0019!Ja\f\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005c\u00192Aa\f\n\u0011\u001d9%q\u0006C\u0001\u0005k!\"A!\f\t\u0015\te\"qFI\u0001\n\u0003\u0011Y$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0007\u0005{\u0011\u0019F!\u0016\u0016\u0005\t}\"fA\u001d\u0003B-\u0012!1\t\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003%)hn\u00195fG.,GMC\u0002\u0003N-\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tFa\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004O\u0005o\u0011\ra\u0014\u0003\u00071\n]\"\u0019A(")
public abstract class AbstractIndex<K, V>
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long kafka$log$AbstractIndex$$_length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public long kafka$log$AbstractIndex$$_length() {
        return this.kafka$log$AbstractIndex$$_length;
    }

    public void kafka$log$AbstractIndex$$_length_$eq(long x$1) {
        this.kafka$log$AbstractIndex$$_length = x$1;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this.kafka$log$AbstractIndex$$_length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean apply$mcZ$sp() {
                boolean bl;
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                if (this.$outer.kafka$log$AbstractIndex$$_length() == (long)roundedNewSize) {
                    this.$outer.debug((Function0<String>)new Serializable(this, roundedNewSize){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resize$1 $outer;
                        private final int roundedNewSize$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Index ", " was not resized because it already has size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.roundedNewSize$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.roundedNewSize$1 = roundedNewSize$1;
                        }
                    });
                    return false;
                }
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                try {
                    int position = this.$outer.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.$outer.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this.$outer.kafka$log$AbstractIndex$$_length_$eq(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    this.$outer.mmap().position(position);
                    this.$outer.debug((Function0<String>)new Serializable(this, roundedNewSize){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$resize$1 $outer;
                        private final int roundedNewSize$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resized ", " to ", ", position is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.roundedNewSize$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap().position())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and limit is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap().limit())}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.roundedNewSize$1 = roundedNewSize$1;
                        }
                    });
                    bl = true;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }, this.$outer, CoreUtils$.MODULE$.swallow$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this.$outer, CoreUtils$.MODULE$.swallow$default$3());
                    throw throwable;
                }
                return bl;
            }

            public /* synthetic */ AbstractIndex kafka$log$AbstractIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean deleteIfExists() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
            return;
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (OperatingSystem.IS_WINDOWS) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this.kafka$log$AbstractIndex$$_length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.kafka$log$AbstractIndex$$_length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.kafka$log$AbstractIndex$$_length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }, this, CoreUtils$.MODULE$.swallow$default$3());
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var7_6;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, this, CoreUtils$.MODULE$.swallow$default$3());
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

