/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.api.PartitionMetadata$;
import kafka.api.TopicMetadata$;
import kafka.cluster.BrokerEndPoint;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005Ex!B\u0001\u0003\u0011\u00039\u0011!\u0005)beRLG/[8o\u001b\u0016$\u0018\rZ1uC*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0014\u0007%a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bYIA\u0011A\f\u0002\rqJg.\u001b;?)\u00059\u0001\"B\r\n\t\u0003Q\u0012\u0001\u0003:fC\u00124%o\\7\u0015\u000bm\t9+!+\u0011\u0005!ab\u0001\u0002\u0006\u0003\u0001v\u0019R\u0001\b\u0007\u001fII\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005\r\u0002#a\u0002'pO\u001eLgn\u001a\t\u0003\u001b\u0015J!A\n\b\u0003\u000fA\u0013x\u000eZ;di\"A\u0001\u0006\bBK\u0002\u0013\u0005\u0011&A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\u0016\u0011\u00055Y\u0013B\u0001\u0017\u000f\u0005\rIe\u000e\u001e\u0005\t]q\u0011\t\u0012)A\u0005U\u0005a\u0001/\u0019:uSRLwN\\%eA!A\u0001\u0007\bBK\u0002\u0013\u0005\u0011'\u0001\u0004mK\u0006$WM]\u000b\u0002eA\u0019QbM\u001b\n\u0005Qr!AB(qi&|g\u000e\u0005\u00027s5\tqG\u0003\u00029\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u001e8\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001\u0002\u0010\u000f\u0003\u0012\u0003\u0006IAM\u0001\bY\u0016\fG-\u001a:!\u0011!qDD!f\u0001\n\u0003y\u0014\u0001\u0003:fa2L7-Y:\u0016\u0003\u0001\u00032!Q%6\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002F\r\u00051AH]8pizJ\u0011aD\u0005\u0003\u0011:\tq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\n\u00191+Z9\u000b\u0005!s\u0001\u0002C'\u001d\u0005#\u0005\u000b\u0011\u0002!\u0002\u0013I,\u0007\u000f\\5dCN\u0004\u0003\u0002C(\u001d\u0005+\u0007I\u0011A \u0002\u0007%\u001c(\u000f\u0003\u0005R9\tE\t\u0015!\u0003A\u0003\u0011I7O\u001d\u0011\t\u0011Mc\"Q3A\u0005\u0002Q\u000bQ!\u001a:s_J,\u0012!\u0016\t\u0003-\u0002l\u0011a\u0016\u0006\u00031f\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u00035n\u000baaY8n[>t'BA\u0003]\u0015\tif,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005<&AB#se>\u00148\u000f\u0003\u0005d9\tE\t\u0015!\u0003V\u0003\u0019)'O]8sA!)a\u0003\bC\u0001KR11DZ4iS*DQ\u0001\u000b3A\u0002)BQ\u0001\r3A\u0002IBQA\u00103A\u0002\u0001Cqa\u00143\u0011\u0002\u0003\u0007\u0001\tC\u0004TIB\u0005\t\u0019A+\t\u000b1dB\u0011A\u0015\u0002\u0017ML'0Z%o\u0005f$Xm\u001d\u0005\u0006]r!\ta\\\u0001\boJLG/\u001a+p)\t\u00018\u000f\u0005\u0002\u000ec&\u0011!O\u0004\u0002\u0005+:LG\u000fC\u0003u[\u0002\u0007Q/\u0001\u0004ck\u001a4WM\u001d\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f1A\\5p\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003\u007f9\u0011\u0005s0\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005%abA\u0007\u0002\u0006%\u0019\u0011q\u0001\b\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9A\u0004\u0005\n\u0003#a\u0012\u0011!C\u0001\u0003'\tAaY8qsRY1$!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0011!A\u0013q\u0002I\u0001\u0002\u0004Q\u0003\u0002\u0003\u0019\u0002\u0010A\u0005\t\u0019\u0001\u001a\t\u0011y\ny\u0001%AA\u0002\u0001C\u0001bTA\b!\u0003\u0005\r\u0001\u0011\u0005\t'\u0006=\u0001\u0013!a\u0001+\"I\u0011\u0011\u0005\u000f\u0012\u0002\u0013\u0005\u00111E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)CK\u0002+\u0003OY#!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003gq\u0011AC1o]>$\u0018\r^5p]&!\u0011qGA\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003wa\u0012\u0013!C\u0001\u0003{\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002@)\u001a!'a\n\t\u0013\u0005\rC$%A\u0005\u0002\u0005\u0015\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fR3\u0001QA\u0014\u0011%\tY\u0005HI\u0001\n\u0003\t)%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005=C$%A\u0005\u0002\u0005E\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003'R3!VA\u0014\u0011%\t9\u0006HA\u0001\n\u0003\nI&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003CJ\u0018\u0001\u00027b]\u001eLA!a\u0003\u0002`!A\u0011q\r\u000f\u0002\u0002\u0013\u0005\u0011&\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002lq\t\t\u0011\"\u0001\u0002n\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA8\u0003k\u00022!DA9\u0013\r\t\u0019H\u0004\u0002\u0004\u0003:L\b\"CA<\u0003S\n\t\u00111\u0001+\u0003\rAH%\r\u0005\n\u0003wb\u0012\u0011!C!\u0003{\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0002b!!!\u0002\b\u0006=TBAAB\u0015\r\t)ID\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAE\u0003\u0007\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001bc\u0012\u0011!C\u0001\u0003\u001f\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\u000b9\nE\u0002\u000e\u0003'K1!!&\u000f\u0005\u001d\u0011un\u001c7fC:D!\"a\u001e\u0002\f\u0006\u0005\t\u0019AA8\u0011%\tY\nHA\u0001\n\u0003\ni*\u0001\u0005iCND7i\u001c3f)\u0005Q\u0003\"CAQ9\u0005\u0005I\u0011IAR\u0003\u0019)\u0017/^1mgR!\u0011\u0011SAS\u0011)\t9(a(\u0002\u0002\u0003\u0007\u0011q\u000e\u0005\u0006ib\u0001\r!\u001e\u0005\b\u0003WC\u0002\u0019AAW\u0003\u001d\u0011'o\\6feN\u0004b!a\u0001\u00020**\u0014\u0002BAY\u0003\u001b\u00111!T1q\u0011%\t),CA\u0001\n\u0003\u000b9,A\u0003baBd\u0017\u0010F\u0006\u001c\u0003s\u000bY,!0\u0002@\u0006\u0005\u0007B\u0002\u0015\u00024\u0002\u0007!\u0006\u0003\u00041\u0003g\u0003\rA\r\u0005\u0007}\u0005M\u0006\u0019\u0001!\t\u0011=\u000b\u0019\f%AA\u0002\u0001C\u0001bUAZ!\u0003\u0005\r!\u0016\u0005\n\u0003\u000bL\u0011\u0011!CA\u0003\u000f\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002J\u0006E\u0007\u0003B\u00074\u0003\u0017\u0004\u0002\"DAgUI\u0002\u0005)V\u0005\u0004\u0003\u001ft!A\u0002+va2,W\u0007C\u0005\u0002T\u0006\r\u0017\u0011!a\u00017\u0005\u0019\u0001\u0010\n\u0019\t\u0013\u0005]\u0017\"%A\u0005\u0002\u0005\u0015\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007C\u0005\u0002\\&\t\n\u0011\"\u0001\u0002R\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIUB\u0011\"a8\n#\u0003%\t!!\u0012\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQB\u0011\"a9\n#\u0003%\t!!\u0015\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIUB\u0011\"a:\n\u0003\u0003%I!!;\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003W\u0004B!!\u0018\u0002n&!\u0011q^A0\u0005\u0019y%M[3di\u0002")
public class PartitionMetadata
implements Logging,
Product,
Serializable {
    private final int partitionId;
    private final Option<BrokerEndPoint> leader;
    private final Seq<BrokerEndPoint> replicas;
    private final Seq<BrokerEndPoint> isr;
    private final Errors error;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Errors apply$default$5() {
        return PartitionMetadata$.MODULE$.apply$default$5();
    }

    public static Seq<BrokerEndPoint> apply$default$4() {
        return PartitionMetadata$.MODULE$.apply$default$4();
    }

    public static Errors $lessinit$greater$default$5() {
        return PartitionMetadata$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<BrokerEndPoint> $lessinit$greater$default$4() {
        return PartitionMetadata$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Object, Option<BrokerEndPoint>, Seq<BrokerEndPoint>, Seq<BrokerEndPoint>, Errors>> unapply(PartitionMetadata partitionMetadata) {
        return PartitionMetadata$.MODULE$.unapply(partitionMetadata);
    }

    public static PartitionMetadata apply(int n, Option<BrokerEndPoint> option, Seq<BrokerEndPoint> seq, Seq<BrokerEndPoint> seq2, Errors errors) {
        return PartitionMetadata$.MODULE$.apply(n, option, seq, seq2, errors);
    }

    public static PartitionMetadata readFrom(ByteBuffer byteBuffer, Map<Object, BrokerEndPoint> map) {
        return PartitionMetadata$.MODULE$.readFrom(byteBuffer, map);
    }

    private Logger logger$lzycompute() {
        PartitionMetadata partitionMetadata = this;
        synchronized (partitionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Option<BrokerEndPoint> leader() {
        return this.leader;
    }

    public Seq<BrokerEndPoint> replicas() {
        return this.replicas;
    }

    public Seq<BrokerEndPoint> isr() {
        return this.isr;
    }

    public Errors error() {
        return this.error;
    }

    public int sizeInBytes() {
        return 14 + 4 * this.replicas().size() + 4 + 4 * this.isr().size();
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.putShort(this.error().code());
        buffer.putInt(this.partitionId());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.leader().fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return TopicMetadata$.MODULE$.NoLeaderNodeId();
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerEndPoint leader) {
                return leader.id();
            }
        }));
        buffer.putInt(leaderId);
        buffer.putInt(this.replicas().size());
        this.replicas().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$4;

            public final ByteBuffer apply(BrokerEndPoint r) {
                return this.buffer$4.putInt(r.id());
            }
            {
                this.buffer$4 = buffer$4;
            }
        });
        buffer.putInt(this.isr().size());
        this.isr().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$4;

            public final ByteBuffer apply(BrokerEndPoint r) {
                return this.buffer$4.putInt(r.id());
            }
            {
                this.buffer$4 = buffer$4;
            }
        });
    }

    public String toString() {
        StringBuilder partitionMetadataString = new StringBuilder();
        partitionMetadataString.append(new StringBuilder().append((Object)"\tpartition ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tleader: ").append(this.leader().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "none";
            }
        })).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\treplicas: ").append((Object)this.replicas().mkString(",")).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tisr: ").append((Object)this.isr().mkString(",")).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tisUnderReplicated: ").append((Object)BoxesRunTime.boxToBoolean((this.isr().size() < this.replicas().size() ? 1 : 0) != 0)).toString());
        return partitionMetadataString.toString();
    }

    public PartitionMetadata copy(int partitionId, Option<BrokerEndPoint> leader, Seq<BrokerEndPoint> replicas, Seq<BrokerEndPoint> isr, Errors error) {
        return new PartitionMetadata(partitionId, leader, replicas, isr, error);
    }

    public int copy$default$1() {
        return this.partitionId();
    }

    public Option<BrokerEndPoint> copy$default$2() {
        return this.leader();
    }

    public Seq<BrokerEndPoint> copy$default$3() {
        return this.replicas();
    }

    public Seq<BrokerEndPoint> copy$default$4() {
        return this.isr();
    }

    public Errors copy$default$5() {
        return this.error();
    }

    public String productPrefix() {
        return "PartitionMetadata";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = this.error();
                break;
            }
            case 3: {
                object = this.isr();
                break;
            }
            case 2: {
                object = this.replicas();
                break;
            }
            case 1: {
                object = this.leader();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.partitionId());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PartitionMetadata;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.partitionId());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.leader()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.replicas()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.isr()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.error()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PartitionMetadata)) return false;
        boolean bl = true;
        if (!bl) return false;
        PartitionMetadata partitionMetadata = (PartitionMetadata)x$1;
        if (this.partitionId() != partitionMetadata.partitionId()) return false;
        Option<BrokerEndPoint> option = this.leader();
        Option<BrokerEndPoint> option2 = partitionMetadata.leader();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<BrokerEndPoint> seq = this.replicas();
        Seq<BrokerEndPoint> seq2 = partitionMetadata.replicas();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<BrokerEndPoint> seq3 = this.isr();
        Seq<BrokerEndPoint> seq4 = partitionMetadata.isr();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Errors errors = this.error();
        Errors errors2 = partitionMetadata.error();
        if (errors == null) {
            if (errors2 != null) {
                return false;
            }
        } else if (!errors.equals(errors2)) return false;
        if (!partitionMetadata.canEqual(this)) return false;
        return true;
    }

    public PartitionMetadata(int partitionId, Option<BrokerEndPoint> leader, Seq<BrokerEndPoint> replicas, Seq<BrokerEndPoint> isr, Errors error) {
        this.partitionId = partitionId;
        this.leader = leader;
        this.replicas = replicas;
        this.isr = isr;
        this.error = error;
        Logging$class.$init$(this);
        Product.class.$init$((Product)this);
    }
}

