/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.RequestMetrics;
import kafka.network.RequestMetrics$;
import kafka.network.SocketServer;
import kafka.network.SocketServerTest$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU8dW\u0016$8+\u001a:wKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003\u0015\u0001(o\u001c9t+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011)H/\u001b7\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0012\u0001A\u0003%!$\u0001\u0004qe>\u00048\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003\u0019\u0019wN\u001c4jOV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u000511/\u001a:wKJL!\u0001L\u0015\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u000f\r|gNZ5hA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014aB7fiJL7m]\u000b\u0002eA\u00111GO\u0007\u0002i)\u0011\u0001'\u000e\u0006\u0003m]\naaY8n[>t'BA\u00039\u0015\tId\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003wQ\u0012q!T3ue&\u001c7\u000f\u0003\u0004>\u0001\u0001\u0006IAM\u0001\t[\u0016$(/[2tA!9q\b\u0001b\u0001\n\u0003\u0001\u0015AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\t\u0001b]3dkJLG/_\u0005\u0003\r\u000e\u0013!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\"1\u0001\n\u0001Q\u0001\n\u0005\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BqA\u000b\u0001C\u0002\u0013\u0005!*F\u0001L!\t1B*\u0003\u0002N\u0005\ta1k\\2lKR\u001cVM\u001d<fe\"1q\n\u0001Q\u0001\n-\u000bqa]3sm\u0016\u0014\b\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u000fM|7m[3ugV\t1\u000bE\u0002U7vk\u0011!\u0016\u0006\u0003-^\u000bq!\\;uC\ndWM\u0003\u0002Y3\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X+\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Az\t1A\\3u\u0013\t\u0011wL\u0001\u0004T_\u000e\\W\r\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B*\u0002\u0011M|7m[3ug\u0002BQA\u001a\u0001\u0005\u0002\u001d\f1b]3oIJ+\u0017/^3tiR)\u0001\u000e\u001c8w}B\u0011\u0011N[\u0007\u00023&\u00111.\u0017\u0002\u0005+:LG\u000fC\u0003nK\u0002\u0007Q,\u0001\u0004t_\u000e\\W\r\u001e\u0005\u0006_\u0016\u0004\r\u0001]\u0001\be\u0016\fX/Z:u!\rI\u0017o]\u0005\u0003ef\u0013Q!\u0011:sCf\u0004\"!\u001b;\n\u0005UL&\u0001\u0002\"zi\u0016Dqa^3\u0011\u0002\u0003\u0007\u00010\u0001\u0002jIB\u0019\u0011._>\n\u0005iL&AB(qi&|g\u000e\u0005\u0002jy&\u0011Q0\u0017\u0002\u0006'\"|'\u000f\u001e\u0005\t\u007f\u0016\u0004\n\u00111\u0001\u0002\u0002\u0005)a\r\\;tQB\u0019\u0011.a\u0001\n\u0007\u0005\u0015\u0011LA\u0004C_>dW-\u00198\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u0005y!/Z2fSZ,'+Z:q_:\u001cX\rF\u0002q\u0003\u001bAa!\\A\u0004\u0001\u0004i\u0006bBA\t\u0001\u0011%\u00111C\u0001\u000fe\u0016\u001cW-\u001b<f%\u0016\fX/Z:u)\u0019\t)\"a\t\u0002.A!\u0011qCA\u000f\u001d\r1\u0012\u0011D\u0005\u0004\u00037\u0011\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003?\t\tCA\u0004SKF,Xm\u001d;\u000b\u0007\u0005m!\u0001\u0003\u0005\u0002&\u0005=\u0001\u0019AA\u0014\u0003\u001d\u0019\u0007.\u00198oK2\u00042AFA\u0015\u0013\r\tYC\u0001\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0011)\ty#a\u0004\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\bi&lWm\\;u!\rI\u00171G\u0005\u0004\u0003kI&\u0001\u0002'p]\u001eDq!!\u000f\u0001\t\u0003\tY$\u0001\bqe>\u001cWm]:SKF,Xm\u001d;\u0015\u0007!\fi\u0004\u0003\u0005\u0002&\u0005]\u0002\u0019AA\u0014\u0011\u001d\tI\u0004\u0001C\u0001\u0003\u0003\"R\u0001[A\"\u0003\u000bB\u0001\"!\n\u0002@\u0001\u0007\u0011q\u0005\u0005\b_\u0006}\u0002\u0019AA\u000b\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nqaY8o]\u0016\u001cG\u000fF\u0003^\u0003\u001b\n\t\u0006C\u0005\u0002P\u0005\u001d\u0003\u0013!a\u0001\u0017\u0006\t1\u000f\u0003\u0006\u0002T\u0005\u001d\u0003\u0013!a\u0001\u0003+\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u0019\u00111K\u001b\n\t\u0005u\u0013\u0011\f\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2Dq!!\u0019\u0001\t\u0003\t\u0019'\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005A\u0007\u0006BA0\u0003O\u0002B!!\u001b\u0002n5\u0011\u00111\u000e\u0006\u0003\u00179IA!a\u001c\u0002l\t)\u0011I\u001a;fe\"9\u00111\u000f\u0001\u0005\n\u0005U\u0014\u0001\u00069s_\u0012,8-\u001a:SKF,Xm\u001d;CsR,7\u000fF\u0002q\u0003oB\u0011\"!\u001f\u0002rA\u0005\t\u0019A>\u0002\u0007\u0005\u001c7\u000eC\u0004\u0002~\u0001!I!a \u0002=M,g\u000e\u001a*fcV,7\u000f^:V]RLGn\u0015;bO\u0016$'+Z2fSZ,G\u0003CA\u000b\u0003\u0003\u000b\u0019)!\"\t\r)\nY\b1\u0001L\u0011\u0019i\u00171\u0010a\u0001;\"9\u0011qQA>\u0001\u0004\u0001\u0018\u0001\u0004:fcV,7\u000f\u001e\"zi\u0016\u001c\bbBAF\u0001\u0011\u0005\u00111M\u0001\u000eg&l\u0007\u000f\\3SKF,Xm\u001d;)\t\u0005%\u0015q\u0012\t\u0005\u0003S\n\t*\u0003\u0003\u0002\u0014\u0006-$\u0001\u0002+fgRDq!a&\u0001\t\u0003\t\u0019'A\fu_>\u0014\u0015n\u001a*fcV,7\u000f^%t%\u0016TWm\u0019;fI\"\"\u0011QSAH\u0011\u001d\ti\n\u0001C\u0001\u0003G\n\u0011\u0003^3ti\u001e\u0013\u0018mY3gk2\u001cEn\\:fQ\u0011\tY*a$\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002d\u0005QB/Z:u'>\u001c7.\u001a;t\u00072|7/Z(o'\",H\u000fZ8x]\"\"\u0011\u0011UAH\u0011\u001d\tI\u000b\u0001C\u0001\u0003G\nq\u0003^3ti6\u000b\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139)\t\u0005\u001d\u0016q\u0012\u0005\b\u0003_\u0003A\u0011AA2\u0003\u0001\"Xm\u001d;NCb\u001cuN\u001c8fGRLwN\\:QKJL\u0005o\u0014<feJLG-Z:)\t\u00055\u0016q\u0012\u0005\b\u0003k\u0003A\u0011AA2\u0003M!Xm\u001d;Tg2\u001cvnY6fiN+'O^3sQ\u0011\t\u0019,a$\t\u000f\u0005m\u0006\u0001\"\u0001\u0002d\u0005!B/Z:u'\u0016\u001c8/[8o!JLgnY5qC2DC!!/\u0002\u0010\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0014\u0001\f;fgR\u001cE.[3oi\u0012K7oY8o]\u0016\u001cG/[8o+B$\u0017\r^3t%\u0016\fX/Z:u\u001b\u0016$(/[2tQ\u0011\ty,a$\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002d\u00059D/Z:u\u00072LWM\u001c;ESN\u001cwN\u001c8fGRLwN\\,ji\"\u001cF/Y4fIJ+7-Z5wKN4U\u000f\u001c7z!J|7-Z:tK\u0012DC!!2\u0002\u0010\"9\u0011Q\u001a\u0001\u0005\u0002\u0005\r\u0014!\u000e;fgR\u0014%o\\6feN+g\u000eZ!gi\u0016\u00148\t[1o]\u0016d7\t\\8tK\u0012,\u0006\u000fZ1uKN\u0014V-];fgRlU\r\u001e:jGNDC!a3\u0002\u0010\"9\u00111\u001b\u0001\u0005\u0002\u0005\r\u0014!\t;fgRlU\r\u001e:jG\u000e{G\u000e\\3di&|g.\u00114uKJ\u001c\u0006.\u001e;e_^t\u0007\u0006BAi\u0003\u001fCq!!7\u0001\t\u0003\t\u0019'\u0001\ruKN$\bK]8dKN\u001cxN]'fiJL7m\u001d+bONDC!a6\u0002\u0010\"I\u0011q\u001c\u0001\u0012\u0002\u0013\u0005\u0011\u0011]\u0001\u0016g\u0016tGMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019OK\u0002y\u0003K\\#!a:\u0011\t\u0005%\u00181_\u0007\u0003\u0003WTA!!<\u0002p\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003cL\u0016AC1o]>$\u0018\r^5p]&!\u0011Q_Av\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003s\u0004\u0011\u0013!C\u0001\u0003w\fQc]3oIJ+\u0017/^3ti\u0012\"WMZ1vYR$C'\u0006\u0002\u0002~*\"\u0011\u0011AAs\u0011%\u0011\t\u0001AI\u0001\n\u0013\u0011\u0019!\u0001\rsK\u000e,\u0017N^3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\"A!\u0002+\t\u0005E\u0012Q\u001d\u0005\n\u0005\u0013\u0001\u0011\u0013!C\u0001\u0005\u0017\t\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iAK\u0002L\u0003KD\u0011B!\u0005\u0001#\u0003%\tAa\u0005\u0002#\r|gN\\3di\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0016)\"\u0011QKAs\u0011%\u0011I\u0002AI\u0001\n\u0013\u0011Y\"\u0001\u0010qe>$WoY3s%\u0016\fX/Z:u\u0005f$Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0004\u0016\u0004w\u0006\u0015\b")
public class SocketServerTest
extends JUnitSuite {
    private final Properties props;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final SocketServer server;
    private final ArrayBuffer<Socket> sockets;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public SocketServer server() {
        return this.server;
    }

    public ArrayBuffer<Socket> sockets() {
        return this.sockets;
    }

    public void sendRequest(Socket socket, byte[] request, Option<Object> id, boolean flush) {
        Option<Object> option;
        block6: {
            DataOutputStream outgoing;
            block5: {
                block4: {
                    outgoing = new DataOutputStream(socket.getOutputStream());
                    option = id;
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    short id2 = BoxesRunTime.unboxToShort((Object)some.x());
                    outgoing.writeInt(request.length + 2);
                    outgoing.writeShort(id2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                outgoing.writeInt(request.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            outgoing.write(request);
            if (flush) {
                outgoing.flush();
            }
            return;
        }
        throw new MatchError(option);
    }

    public Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    public boolean sendRequest$default$4() {
        return true;
    }

    public byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    private RequestChannel.Request receiveRequest(RequestChannel channel, long timeout) {
        RequestChannel.Request request = channel.receiveRequest(timeout);
        Assert.assertNotNull((String)"receiveRequest timed out", (Object)request);
        return request;
    }

    private long receiveRequest$default$2() {
        return 2000L;
    }

    public void processRequest(RequestChannel channel) {
        RequestChannel.Request request = this.receiveRequest(channel, this.receiveRequest$default$2());
        this.processRequest(channel, request);
    }

    public void processRequest(RequestChannel channel, RequestChannel.Request request) {
        ByteBuffer byteBuffer = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())).serialize(request.header());
        byteBuffer.rewind();
        NetworkSend send = new NetworkSend(request.connectionId(), byteBuffer);
        channel.sendResponse(RequestChannel.Response$.MODULE$.apply(request, (Send)send));
    }

    /*
     * WARNING - void declaration
     */
    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        void var3_3;
        Socket socket = new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
        this.sockets().$plus$eq((Object)socket);
        return var3_3;
    }

    public SocketServer connect$default$1() {
        return this.server();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    @After
    public void tearDown() {
        this.metrics().close();
        this.server().shutdown();
        this.sockets().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$1) {
                x$1.close();
            }
        });
        this.sockets().clear();
    }

    private byte[] producerRequestBytes(short ack) {
        short apiKey = 0;
        int correlationId = -1;
        String clientId = "";
        int ackTimeoutMs = 10000;
        ProduceRequest emptyRequest = (ProduceRequest)new ProduceRequest.Builder(2, ack, ackTimeoutMs, new HashMap()).build();
        RequestHeader emptyHeader = new RequestHeader(apiKey, emptyRequest.version(), clientId, correlationId);
        ByteBuffer byteBuffer = emptyRequest.serialize(emptyHeader);
        byteBuffer.rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        return serializedBytes;
    }

    private short producerRequestBytes$default$1() {
        return 0;
    }

    private RequestChannel.Request sendRequestsUntilStagedReceive(SocketServer server, Socket socket, byte[] requestBytes) {
        Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue(new Serializable(this, server, socket, requestBytes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final SocketServer server$1;
            private final Socket socket$1;
            private final byte[] requestBytes$1;

            public final RequestChannel.Request apply() {
                return this.$outer.kafka$network$SocketServerTest$$sendTwoRequestsReceiveOne$1(this.server$1, this.socket$1, this.requestBytes$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.server$1 = server$1;
                this.socket$1 = socket$1;
                this.requestBytes$1 = requestBytes$1;
            }
        }, TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final SocketServer server$1;

            /*
             * WARNING - void declaration
             */
            public final boolean apply(RequestChannel.Request req) {
                void var3_3;
                boolean hasStagedReceives;
                String connectionId = req.connectionId();
                boolean bl = hasStagedReceives = this.server$1.processor(0).numStagedReceives(connectionId) > 0;
                if (!hasStagedReceives) {
                    this.$outer.processRequest(this.server$1.requestChannel(), req);
                    this.$outer.processRequest(this.server$1.requestChannel());
                }
                return (boolean)var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.server$1 = server$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            RequestChannel.Request request = (RequestChannel.Request)tuple2._1();
            boolean hasStagedReceives = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)request, (Object)BoxesRunTime.boxToBoolean((boolean)hasStagedReceives));
            RequestChannel.Request request2 = (RequestChannel.Request)tuple23._1();
            boolean hasStagedReceives2 = tuple23._2$mcZ$sp();
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receives not staged for ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)15000L)})), (boolean)hasStagedReceives2);
            return request2;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void simpleRequest() {
        SecurityProtocol x$31 = SecurityProtocol.PLAINTEXT;
        SocketServer x$32 = this.connect$default$1();
        Socket plainSocket = this.connect(x$32, x$31);
        SecurityProtocol x$33 = SecurityProtocol.TRACE;
        SocketServer x$34 = this.connect$default$1();
        Socket traceSocket = this.connect(x$34, x$33);
        byte[] serializedBytes = this.producerRequestBytes(this.producerRequestBytes$default$1());
        this.sendRequest(plainSocket, serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(plainSocket)).toSeq());
        this.sendRequest(traceSocket, serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(traceSocket)).toSeq());
    }

    @Test
    public void tooBigRequestIsRejected() {
        byte[] tooManyBytes = new byte[Predef$.MODULE$.Integer2int(this.server().config().socketRequestMaxBytes()) + 1];
        new Random().nextBytes(tooManyBytes);
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(tooManyBytes.length);
        try {
            outgoing.write(tooManyBytes);
            outgoing.flush();
            this.receiveResponse(socket);
        }
        catch (IOException iOException) {}
    }

    @Test
    public void testGracefulClose() {
        SecurityProtocol x$35 = SecurityProtocol.PLAINTEXT;
        SocketServer x$36 = this.connect$default$1();
        Socket plainSocket = this.connect(x$36, x$35);
        byte[] serializedBytes = this.producerRequestBytes(this.producerRequestBytes$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, plainSocket, serializedBytes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final Socket plainSocket$1;
            private final byte[] serializedBytes$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.$outer.sendRequest(this.plainSocket$1, this.serializedBytes$1, this.$outer.sendRequest$default$3(), this.$outer.sendRequest$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.plainSocket$1 = plainSocket$1;
                this.serializedBytes$1 = serializedBytes$1;
            }
        });
        plainSocket.close();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                RequestChannel.Request request = this.$outer.server().requestChannel().receiveRequest(2000L);
                Assert.assertNotNull((String)"receiveRequest timed out", (Object)request);
                this.$outer.server().requestChannel().sendResponse(new RequestChannel.Response(request, (Option)None$.MODULE$, (RequestChannel.ResponseAction)RequestChannel.NoOpAction$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testSocketsCloseOnShutdown() {
        SecurityProtocol x$37 = SecurityProtocol.PLAINTEXT;
        SocketServer x$38 = this.connect$default$1();
        Socket plainSocket = this.connect(x$38, x$37);
        plainSocket.setTcpNoDelay(true);
        SecurityProtocol x$39 = SecurityProtocol.TRACE;
        SocketServer x$40 = this.connect$default$1();
        Socket traceSocket = this.connect(x$40, x$39);
        traceSocket.setTcpNoDelay(true);
        byte[] bytes = new byte[40];
        this.sendRequest(plainSocket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)), this.sendRequest$default$4());
        this.sendRequest(traceSocket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)), this.sendRequest$default$4());
        this.processRequest(this.server().requestChannel());
        Thread.sleep(200L);
        this.server().acceptors().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Acceptor acceptor) {
                Assert.assertFalse((boolean)acceptor.serverChannel().socket().isClosed());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        this.server().shutdown();
        byte[] largeChunkOfBytes = new byte[1000000];
        try {
            this.sendRequest(plainSocket, largeChunkOfBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)), this.sendRequest$default$4());
            throw this.fail("expected exception when writing to closed plain socket", new Position("SocketServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        }
        catch (IOException iOException) {
            try {
                this.sendRequest(traceSocket, largeChunkOfBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)), this.sendRequest$default$4());
                throw this.fail("expected exception when writing to closed trace socket", new Position("SocketServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            }
            catch (IOException iOException2) {
                return;
            }
        }
    }

    @Test
    public void testMaxConnectionsPerIp() {
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final Socket apply(int x$3) {
                return this.$outer.connect(this.$outer.connect$default$1(), this.$outer.connect$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Socket conn = this.connect(this.connect$default$1(), this.connect$default$2());
        conn.setSoTimeout(3000);
        Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
        conn.close();
        InetAddress address = ((Socket)conns.head()).getInetAddress();
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, conns, address){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final IndexedSeq conns$1;
            private final InetAddress address$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server().connectionCount(this.address$1) < this.conns$1.length();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conns$1 = conns$1;
                this.address$1 = address$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to decrement connection count after close";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Socket conn2 = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] serializedBytes = this.producerRequestBytes(this.producerRequestBytes$default$1());
        this.sendRequest(conn2, serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
        RequestChannel.Request request = this.server().requestChannel().receiveRequest(2000L);
        Assert.assertNotNull((Object)request);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxConnectionsPerIpOverrides() {
        int overrideNum = Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp()) + 1;
        int x$41 = 0;
        String x$42 = TestUtils$.MODULE$.MockZkConnect();
        int x$43 = 0;
        boolean x$44 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$46 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$47 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$48 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$49 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$51 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$53 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$54 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$55 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$56 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$41, x$42, x$44, x$45, x$43, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56);
        overrideProps.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)overrideNum)})));
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), overrideNum).map((Function1)new Serializable(this, overrideServer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final SocketServer overrideServer$1;

                public final Socket apply(int x$4) {
                    return this.$outer.connect(this.overrideServer$1, this.$outer.connect$default$2());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.overrideServer$1 = overrideServer$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            byte[] serializedBytes = this.producerRequestBytes(this.producerRequestBytes$default$1());
            this.sendRequest((Socket)conns.last(), serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
            RequestChannel.Request request = overrideServer.requestChannel().receiveRequest(2000L);
            Assert.assertNotNull((Object)request);
            Socket conn = this.connect(overrideServer, this.connect$default$2());
            conn.setSoTimeout(3000);
            Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
        }
        catch (Throwable throwable) {
            void var19_19;
            void var20_20;
            var20_20.shutdown();
            var19_19.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSslSocketServer() {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        int x$57 = 0;
        String x$58 = TestUtils$.MODULE$.MockZkConnect();
        Some x$59 = new Some((Object)SecurityProtocol.SSL);
        Some x$60 = new Some((Object)trustStoreFile);
        boolean x$61 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$62 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$63 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<Properties> x$64 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$65 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$66 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$67 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$68 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$69 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$70 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$71 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$72 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$57, x$58, x$61, x$62, x$63, (Option<SecurityProtocol>)x$59, (Option<File>)x$60, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72);
        overrideProps.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{TestUtils$.MODULE$.trustAllCerts()}), new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket("localhost", overrideServer.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL)));
            sslSocket.setNeedClientAuth(false);
            short apiKey = ApiKeys.PRODUCE.id;
            int correlationId = -1;
            String clientId = "";
            int ackTimeoutMs = 10000;
            short ack = 0;
            ProduceRequest emptyRequest = (ProduceRequest)new ProduceRequest.Builder(2, ack, ackTimeoutMs, new HashMap()).build();
            RequestHeader emptyHeader = new RequestHeader(apiKey, emptyRequest.version(), clientId, correlationId);
            ByteBuffer byteBuffer = emptyRequest.serialize(emptyHeader);
            byteBuffer.rewind();
            byte[] serializedBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(serializedBytes);
            this.sendRequest(sslSocket, serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
            this.processRequest(overrideServer.requestChannel());
            Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(sslSocket)).toSeq());
            sslSocket.close();
        }
        catch (Throwable throwable) {
            void var19_19;
            void var20_20;
            var20_20.shutdown();
            var19_19.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    @Test
    public void testSessionPrincipal() {
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] bytes = new byte[40];
        this.sendRequest(socket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)), this.sendRequest$default$4());
        Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)this.server().requestChannel().receiveRequest(2000L).session().principal());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientDisconnectionUpdatesRequestMetrics() {
        int x$73 = 0;
        String x$74 = TestUtils$.MODULE$.MockZkConnect();
        int x$75 = 0;
        boolean x$76 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$77 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$78 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$79 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$80 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$81 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$82 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$83 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$84 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$85 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$86 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$87 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$88 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$73, x$74, x$76, x$77, x$75, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88);
        Metrics serverMetrics = new Metrics();
        ObjectRef conn = ObjectRef.create(null);
        SocketServer overrideServer = new SocketServer(this, props, serverMetrics, conn){
            public final ObjectRef conn$1;

            public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol protocol) {
                return new Processor(this, id, connectionQuotas, listenerName, protocol){
                    private final /* synthetic */ $anon$2 $outer;

                    public void sendResponse(RequestChannel.Response response, Send responseSend) {
                        ((Socket)this.$outer.conn$1.elem).close();
                        super.sendResponse(response, responseSend);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(id$1, $outer.time(), Predef$.MODULE$.Integer2int($outer.config().socketRequestMaxBytes()), $outer.requestChannel(), connectionQuotas$1, Predef$.MODULE$.Long2long($outer.config().connectionsMaxIdleMs()), listenerName$1, protocol$1, $outer.config(), $outer.metrics(), $outer.credentialProvider());
                    }
                };
            }
            {
                this.conn$1 = conn$1;
                super(KafkaConfig$.MODULE$.fromProps(props$1), serverMetrics$1, Time.SYSTEM, $outer.credentialProvider());
            }
        };
        try {
            overrideServer.startup();
            conn.elem = this.connect(overrideServer, this.connect$default$2());
            byte[] serializedBytes = this.producerRequestBytes(this.producerRequestBytes$default$1());
            this.sendRequest((Socket)conn.elem, serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
            RequestChannel channel = overrideServer.requestChannel();
            RequestChannel.Request request = channel.receiveRequest(2000L);
            RequestMetrics requestMetrics = (RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)ApiKeys.forId((int)request.requestId()).name);
            long expectedTotalTimeCount = this.kafka$network$SocketServerTest$$totalTimeHistCount$1(requestMetrics) + 1L;
            NetworkSend send = new NetworkSend(request.connectionId(), ByteBuffer.allocate(550000));
            channel.sendResponse(RequestChannel.Response$.MODULE$.apply(request, (Send)send));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$1;
                private final long expectedTotalTimeCount$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$1(this.requestMetrics$1) == this.expectedTotalTimeCount$1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$1 = requestMetrics$1;
                    this.expectedTotalTimeCount$1 = expectedTotalTimeCount$1;
                }
            }, (Function0<String>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$1;
                private final long expectedTotalTimeCount$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request metrics not updated, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedTotalTimeCount$1), BoxesRunTime.boxToLong((long)this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$1(this.requestMetrics$1))}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$1 = requestMetrics$1;
                    this.expectedTotalTimeCount$1 = expectedTotalTimeCount$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var18_18;
            void var20_20;
            var20_20.shutdown();
            var18_18.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    @Test
    public void testClientDisconnectionWithStagedReceivesFullyProcessed() {
        Socket socket = this.connect(this.server(), this.connect$default$2());
        byte[] serializedBytes = this.producerRequestBytes((short)1);
        RequestChannel.Request request = this.sendRequestsUntilStagedReceive(this.server(), socket, serializedBytes);
        String connectionId = request.connectionId();
        socket.setSoLinger(true, 0);
        socket.close();
        this.processRequest(this.server().requestChannel(), request);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, connectionId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final String connectionId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server().processor(0).openOrClosingChannel(this.connectionId$1).isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connectionId$1 = connectionId$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Channel not closed after failed send";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerSendAfterChannelClosedUpdatesRequestMetrics() {
        int x$89 = 0;
        String x$90 = TestUtils$.MODULE$.MockZkConnect();
        int x$91 = 0;
        boolean x$92 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$93 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$94 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$95 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$96 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$97 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$98 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$99 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$100 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$101 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$102 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$103 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$104 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$89, x$90, x$92, x$93, x$91, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104);
        props.setProperty(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), "100");
        Metrics serverMetrics = new Metrics();
        Socket conn = null;
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(props), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            conn = this.connect(overrideServer, this.connect$default$2());
            byte[] serializedBytes = this.producerRequestBytes(this.producerRequestBytes$default$1());
            this.sendRequest(conn, serializedBytes, this.sendRequest$default$3(), this.sendRequest$default$4());
            RequestChannel channel = overrideServer.requestChannel();
            RequestChannel.Request request = channel.receiveRequest(2000L);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, overrideServer, request){
                public static final long serialVersionUID = 0L;
                private final SocketServer overrideServer$2;
                private final RequestChannel.Request request$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.overrideServer$2.processor(this.request$1.processor()).channel(this.request$1.connectionId()).isEmpty();
                }
                {
                    this.overrideServer$2 = overrideServer$2;
                    this.request$1 = request$1;
                }
            }, (Function0<String>)new Serializable(this, request){
                public static final long serialVersionUID = 0L;
                private final RequestChannel.Request request$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Idle connection `", "` was not closed by selector"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.request$1.connectionId()}));
                }
                {
                    this.request$1 = request$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            RequestMetrics requestMetrics = (RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)ApiKeys.forId((int)request.requestId()).name);
            long expectedTotalTimeCount = this.kafka$network$SocketServerTest$$totalTimeHistCount$2(requestMetrics) + 1L;
            this.processRequest(channel, request);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$2;
                private final long expectedTotalTimeCount$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$2(this.requestMetrics$2) == this.expectedTotalTimeCount$2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$2 = requestMetrics$2;
                    this.expectedTotalTimeCount$2 = expectedTotalTimeCount$2;
                }
            }, (Function0<String>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$2;
                private final long expectedTotalTimeCount$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request metrics not updated, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedTotalTimeCount$2), BoxesRunTime.boxToLong((long)this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$2(this.requestMetrics$2))}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestMetrics$2 = requestMetrics$2;
                    this.expectedTotalTimeCount$2 = expectedTotalTimeCount$2;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var18_18;
            void var20_20;
            var20_20.shutdown();
            var18_18.close();
            throw throwable;
        }
        overrideServer.shutdown();
        serverMetrics.close();
    }

    @Test
    public void testMetricCollectionAfterShutdown() {
        this.server().shutdown();
        Map nonZeroMetricNamesAndValues = (Map)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(com.yammer.metrics.core.MetricName k) {
                return k.getName().endsWith("IdlePercent") || k.getName().endsWith("NetworkProcessorAvgIdlePercent");
            }
        }).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<com.yammer.metrics.core.MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    com.yammer.metrics.core.MetricName k = (com.yammer.metrics.core.MetricName)A1._1();
                    Metric metric = (Metric)A1._2();
                    if (metric instanceof Gauge) {
                        Gauge gauge = (Gauge)metric;
                        object = new Tuple2((Object)k, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)gauge.value())));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<com.yammer.metrics.core.MetricName, Metric> x1) {
                Metric metric;
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x1;
                boolean bl = tuple2 != null && (metric = (Metric)tuple2._2()) instanceof Gauge;
                return bl;
            }
        }, Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<com.yammer.metrics.core.MetricName, Object> x0$1) {
                Tuple2<com.yammer.metrics.core.MetricName, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double value = tuple2._2$mcD$sp();
                    boolean bl = value != 0.0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)nonZeroMetricNamesAndValues);
    }

    @Test
    public void testProcessorMetricsTags() {
        Set kafkaMetricNames = (Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.metrics().metrics().keySet()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$5) {
                return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$5.tags()).asScala()).get((Object)"listener").nonEmpty();
            }
        });
        Assert.assertFalse((boolean)kafkaMetricNames.isEmpty());
        scala.collection.immutable.Set expectedListeners = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAINTEXT", "TRACE"}));
        kafkaMetricNames.foreach((Function1)new Serializable(this, expectedListeners){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set expectedListeners$1;

            public final void apply(MetricName kafkaMetricName) {
                Assert.assertTrue((boolean)this.expectedListeners$1.contains(kafkaMetricName.tags().get("listener")));
            }
            {
                this.expectedListeners$1 = expectedListeners$1;
            }
        });
        Iterable yammerMetricsNames = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(com.yammer.metrics.core.MetricName x$6) {
                return x$6.getType().equals("Processor");
            }
        }).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<com.yammer.metrics.core.MetricName, Metric>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    com.yammer.metrics.core.MetricName k = (com.yammer.metrics.core.MetricName)A1._1();
                    if (A1._2() instanceof Gauge) {
                        object = k;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<com.yammer.metrics.core.MetricName, Metric> x2) {
                Tuple2<com.yammer.metrics.core.MetricName, Metric> tuple2 = x2;
                boolean bl = tuple2 != null && tuple2._2() instanceof Gauge;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Assert.assertFalse((boolean)yammerMetricsNames.isEmpty());
        yammerMetricsNames.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(com.yammer.metrics.core.MetricName yammerMetricName) {
                Assert.assertFalse((boolean)yammerMetricName.getMBeanName().contains("listener="));
            }
        });
    }

    public final RequestChannel.Request kafka$network$SocketServerTest$$sendTwoRequestsReceiveOne$1(SocketServer server$1, Socket socket$1, byte[] requestBytes$1) {
        Socket x$23 = socket$1;
        byte[] x$24 = requestBytes$1;
        boolean x$25 = false;
        Option<Object> x$26 = this.sendRequest$default$3();
        this.sendRequest(x$23, x$24, x$26, x$25);
        Socket x$27 = socket$1;
        byte[] x$28 = requestBytes$1;
        boolean x$29 = true;
        Option<Object> x$30 = this.sendRequest$default$3();
        this.sendRequest(x$27, x$28, x$30, x$29);
        return this.receiveRequest(server$1.requestChannel(), this.receiveRequest$default$2());
    }

    public final long kafka$network$SocketServerTest$$totalTimeHistCount$1(RequestMetrics requestMetrics$1) {
        return requestMetrics$1.totalTimeHist().count();
    }

    public final long kafka$network$SocketServerTest$$totalTimeHistCount$2(RequestMetrics requestMetrics$2) {
        return requestMetrics$2.totalTimeHist().count();
    }

    public SocketServerTest() {
        int x$7 = 0;
        String x$8 = TestUtils$.MODULE$.MockZkConnect();
        int x$9 = 0;
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$12 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$13 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$14 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$21 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$22 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        this.props = TestUtils$.MODULE$.createBrokerConfig(x$7, x$8, x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        this.props().put("listeners", "PLAINTEXT://localhost:0,TRACE://localhost:0");
        this.props().put("num.network.threads", "1");
        this.props().put("socket.send.buffer.bytes", "300000");
        this.props().put("socket.receive.buffer.bytes", "300000");
        this.props().put("queued.max.requests", "50");
        this.props().put("socket.request.max.bytes", "50");
        this.props().put("max.connections.per.ip", "5");
        this.props().put("connections.max.idle.ms", "60000");
        this.config = KafkaConfig$.MODULE$.fromProps(this.props());
        this.metrics = new Metrics();
        this.credentialProvider = new CredentialProvider(this.config().saslEnabledMechanisms());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(com.yammer.metrics.core.MetricName metricName) {
                com.yammer.metrics.Metrics.defaultRegistry().removeMetric(metricName);
            }
        });
        this.server = new SocketServer(this.config(), this.metrics(), Time.SYSTEM, this.credentialProvider());
        this.server().startup();
        this.sockets = new ArrayBuffer();
    }
}

