/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012AAR5mK\"1\u0011\u0006\u0001Q\u0001\n\u0001\nq\u0001^7q\t&\u0014\b\u0005C\u0004,\u0001\t\u0007I\u0011A\u0010\u0002\r1|w\rR5s\u0011\u0019i\u0003\u0001)A\u0005A\u00059An\\4ESJ\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\tY><\u0007K]8qgV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025I\u0005!Q\u000f^5m\u0013\t14G\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u000f\u0001!\u0002\u0013\t\u0014!\u00037pOB\u0013x\u000e]:!\u0011\u001dQ\u0004A1A\u0005\u0002m\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003q\u0002\"\u0001H\u001f\n\u0005y\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006!A/[7f+\u0005!\u0005CA\nF\u0013\t1EC\u0001\u0005N_\u000e\\G+[7f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006)A/[7fA!)!\n\u0001C\u0001\u0017\u0006AA/Z1s\t><h\u000eF\u0001M!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0011)f.\u001b;)\u0005%\u001b\u0006C\u0001+W\u001b\u0005)&BA\u0006\u000f\u0013\t9VKA\u0003BMR,'\u000fC\u0003Z\u0001\u0011\u00051*\u0001#uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u0012+G.\u001a;f\u0019><7\u000f\u000b\u0002Y7B\u0011A\u000bX\u0005\u0003;V\u0013A\u0001V3ti\")q\f\u0001C\u0001\u0017\u0006AE/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGR$U\r\\3uK2{wm\u001d\u0015\u0003=nCQA\u0019\u0001\u0005\u0002-\u000bQ\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bFA1\\\u0011\u0015)\u0007\u0001\"\u0001L\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\u0012Am\u0017\u0005\u0006Q\u0002!\taS\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_J$\u0016.\\3)\u0005\u001d\\\u0006\"B6\u0001\t\u0003Y\u0015\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D#A[.\t\u000b9\u0004A\u0011A&\u0002UQ,7\u000f^+oI\u0016\u001c\u0017\u000eZ3e)J\fgn]1di&|g.\u00197ECR\fgj\u001c;DY\u0016\fg.\u00192mK\"\u0012Qn\u0017\u0005\u0006c\u0002!\taS\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD#\u0001].\t\u000bQ\u0004A\u0011A&\u0002!Q,7\u000f\u001e#p]\u0016$U\r\\3uS:<\u0007FA:\\\u0011\u00159\b\u0001\"\u0003y\u0003Q\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4feR\u0011\u0011\u0010 \t\u00039iL!a\u001f\u0002\u0003#1{wm\u00117fC:,'/T1oC\u001e,'\u000fC\u0003\u0004m\u0002\u0007Q\u0010\u0005\u0002\u001d}&\u0011qP\u0001\u0002\u0004\u0019><\u0007bBA\u0002\u0001\u0011%\u0011QA\u0001\nGJ,\u0017\r^3M_\u001e$R!`A\u0004\u0003#A\u0001\"!\u0003\u0002\u0002\u0001\u0007\u00111B\u0001\fg\u0016<W.\u001a8u'&TX\rE\u0002N\u0003\u001bI1!a\u0004O\u0005\rIe\u000e\u001e\u0005\u000b\u0003'\t\t\u0001%AA\u0002\u0005U\u0011!D2mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010\u0005\u0003\u0002\u0018\u0005uabA'\u0002\u001a%\u0019\u00111\u0004(\u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\r\tYB\u0014\u0005\b\u0003K\u0001A\u0011BA\u0014\u0003\u001di\u0017m[3M_\u001e$R!`A\u0015\u0003[A\u0011\"a\u000b\u0002$A\u0005\t\u0019\u0001\u0011\u0002\u0007\u0011L'\u000fC\u0005\u00020\u0005\r\u0002\u0013!a\u0001y\u000511m\u001c8gS\u001eDq!a\r\u0001\t\u0013\t)$A\u0004sK\u000e|'\u000fZ:\u0015\u0011\u0005]\u0012QJA)\u0003+\u0002B!!\u000f\u0002J5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005\u0015#bAA$\u001d\u00051\u0011\r]1dQ\u0016LA!a\u0013\u0002<\tiQ*Z7pef\u0014VmY8sIND\u0001\"a\u0014\u00022\u0001\u0007\u00111B\u0001\u0004W\u0016L\b\u0002CA*\u0003c\u0001\r!a\u0003\u0002\u000bY\fG.^3\t\u0011\u0005]\u0013\u0011\u0007a\u0001\u00033\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u00075\u000bY&C\u0002\u0002^9\u0013A\u0001T8oO\"I\u0011\u0011\r\u0001\u0012\u0002\u0013%\u00111M\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0003KRC!!\u0006\u0002h-\u0012\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003%)hn\u00195fG.,GMC\u0002\u0002t9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9(!\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002|\u0001\t\n\u0011\"\u0003\u0002~\u0005\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}$f\u0001\u0011\u0002h!I\u00111\u0011\u0001\u0012\u0002\u0013%\u0011QQ\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\u0012TCAADU\ra\u0014q\r")
public class LogCleanerManagerTest
extends JUnitSuite
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$10 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$11 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$11, x$10);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3());
        }
        TopicPartition topicPartition = new TopicPartition("log", 0);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$13 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$13, x$12);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3());
        }
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t1), 0, log2.appendAsLeader$default$3());
        }
        TopicPartition topicPartition = new TopicPartition("log", 0);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$14 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$15 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$15, x$14);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3());
        }
        this.time().sleep(compactionLag + 1);
        TopicPartition topicPartition = new TopicPartition("log", 0);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        TopicPartition topicPartition = new TopicPartition("log", 0);
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$16 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$17 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$17, x$16);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        log2.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log2.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false);
        log2.roll(log2.roll$default$1());
        log2.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$18 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$19 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$19, x$18);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        TopicPartition tp = new TopicPartition("log", 0);
        try {
            cleanerManager.doneCleaning(tp, log2.dir(), 1L);
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningPaused$.MODULE$);
            cleanerManager.doneCleaning(tp, log2.dir(), 1L);
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }
        catch (IllegalStateException illegalStateException) {}
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(tp, log2.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)tp).nonEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(tp, log2.dir(), 1L);
        Assert.assertEquals((Object)LogCleaningPaused$.MODULE$, (Object)cleanerManager.cleaningState(tp).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)tp).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log2 = this.createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
        LogCleanerManager cleanerManager = this.createCleanerManager(log2);
        TopicPartition tp = new TopicPartition("log", 0);
        try {
            cleanerManager.doneDeleting(tp);
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningPaused$.MODULE$);
            cleanerManager.doneDeleting(tp);
        }
        catch (Throwable throwable) {
            throw this.fail("Should have thrown IllegalStateException.", new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }
        catch (IllegalStateException illegalStateException) {}
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting(tp);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting(tp);
        Assert.assertEquals((Object)LogCleaningPaused$.MODULE$, (Object)cleanerManager.cleaningState(tp).get());
    }

    /*
     * WARNING - void declaration
     */
    private LogCleanerManager createCleanerManager(Log log2) {
        void var3_3;
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)new TopicPartition("log", 0), (Object)log2);
        LogCleanerManager cleanerManager = new LogCleanerManager((File[])((Object[])new File[]{this.logDir()}), logs);
        return var3_3;
    }

    private Log createLog(int segmentSize, String cleanupPolicy) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        LogConfig config = new LogConfig((Map)logProps);
        File x$20 = partitionDir = new File(this.logDir(), "log-0");
        LogConfig x$21 = config;
        long x$22 = 0L;
        long x$23 = 0L;
        MockScheduler x$24 = this.time().scheduler();
        MockTime x$25 = this.time();
        BrokerTopicStats x$26 = new BrokerTopicStats();
        int x$27 = Log$.MODULE$.apply$default$8();
        int x$28 = Log$.MODULE$.apply$default$9();
        Log log2 = Log$.MODULE$.apply(x$20, x$21, x$22, x$23, (Scheduler)x$24, x$26, (Time)x$25, x$27, x$28);
        return log2;
    }

    private String createLog$default$2() {
        return "delete";
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$1 = dir;
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = Log$.MODULE$.apply$default$8();
        int x$9 = Log$.MODULE$.apply$default$9();
        return Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public LogCleanerManagerTest() {
        Logging.class.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
    }
}

