/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.trogdor.common.StringExpander;
import org.apache.kafka.trogdor.rest.Message;
import org.apache.kafka.trogdor.workload.PartitionsSpec;

public class TopicsSpec
extends Message {
    public static final TopicsSpec EMPTY = new TopicsSpec().immutableCopy();
    private final Map<String, PartitionsSpec> map;

    @JsonCreator
    public TopicsSpec() {
        this.map = new HashMap<String, PartitionsSpec>();
    }

    private TopicsSpec(Map<String, PartitionsSpec> map) {
        this.map = map;
    }

    @JsonAnyGetter
    public Map<String, PartitionsSpec> get() {
        return this.map;
    }

    @JsonAnySetter
    public void set(String name, PartitionsSpec value) {
        this.map.put(name, value);
    }

    public TopicsSpec immutableCopy() {
        HashMap<String, PartitionsSpec> mapCopy = new HashMap<String, PartitionsSpec>();
        mapCopy.putAll(this.map);
        return new TopicsSpec(Collections.unmodifiableMap(mapCopy));
    }

    public Map<String, PartitionsSpec> materialize() {
        HashMap<String, PartitionsSpec> all = new HashMap<String, PartitionsSpec>();
        for (Map.Entry<String, PartitionsSpec> entry : this.map.entrySet()) {
            for (String topicName : StringExpander.expand(entry.getKey())) {
                all.put(topicName, entry.getValue());
            }
        }
        return all;
    }
}

