/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.ThreadUtils;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.PayloadIterator;
import org.apache.kafka.trogdor.workload.ProduceBenchSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceBenchWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ProduceBenchWorker.class);
    private static final int THROTTLE_PERIOD_MS = 100;
    private final String id;
    private final ProduceBenchSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;

    public ProduceBenchWorker(String id, ProduceBenchSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("ProducerBenchWorker is already running.");
        }
        log.info("{}: Activating ProduceBenchWorker with {}", (Object)this.id, (Object)this.spec);
        this.executor = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory("ProduceBenchWorkerThread%d", false));
        this.status = status;
        this.doneFuture = doneFuture;
        this.executor.submit(new Prepare());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("ProduceBenchWorker is not running.");
        }
        log.info("{}: Deactivating ProduceBenchWorker.", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public static class StatusData {
        private final long totalSent;
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p95LatencyMs;
        private final int p99LatencyMs;
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs) {
            this.totalSent = totalSent;
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p95LatencyMs = p95latencyMs;
            this.p99LatencyMs = p99latencyMs;
        }

        @JsonProperty
        public long totalSent() {
            return this.totalSent;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p95LatencyMs() {
            return this.p95LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;

        StatusUpdater(Histogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, (KafkaFutureImpl<String>)ProduceBenchWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(summary.numSamples(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value());
            ProduceBenchWorker.this.status.update(JsonUtil.JSON_SERDE.valueToTree((Object)statusData));
            return statusData;
        }
    }

    public class SendRecords
    implements Callable<Void> {
        private final HashSet<TopicPartition> activePartitions;
        private final Histogram histogram;
        private final Future<?> statusUpdaterFuture;
        private final KafkaProducer<byte[], byte[]> producer;
        private final PayloadIterator keys;
        private final PayloadIterator values;
        private final Throttle throttle;

        SendRecords(HashSet<TopicPartition> activePartitions) {
            this.activePartitions = activePartitions;
            this.histogram = new Histogram(5000);
            int perPeriod = WorkerUtils.perSecToPerPeriod(ProduceBenchWorker.this.spec.targetMessagesPerSec(), 100L);
            this.statusUpdaterFuture = ProduceBenchWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram), 30L, 30L, TimeUnit.SECONDS);
            Properties props = new Properties();
            props.put("bootstrap.servers", ProduceBenchWorker.this.spec.bootstrapServers());
            WorkerUtils.addConfigsToProperties(props, ProduceBenchWorker.this.spec.commonClientConf(), ProduceBenchWorker.this.spec.producerConf());
            this.producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
            this.keys = new PayloadIterator(ProduceBenchWorker.this.spec.keyGenerator());
            this.values = new PayloadIterator(ProduceBenchWorker.this.spec.valueGenerator());
            this.throttle = new SendRecordsThrottle(perPeriod, this.producer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long startTimeMs = Time.SYSTEM.milliseconds();
            try {
                Future future = null;
                try {
                    Iterator<TopicPartition> iter = this.activePartitions.iterator();
                    for (int m = 0; m < ProduceBenchWorker.this.spec.maxMessages(); ++m) {
                        if (!iter.hasNext()) {
                            iter = this.activePartitions.iterator();
                        }
                        TopicPartition partition = iter.next();
                        ProducerRecord record = new ProducerRecord(partition.topic(), Integer.valueOf(partition.partition()), (Object)this.keys.next(), (Object)this.values.next());
                        future = this.producer.send(record, (Callback)new SendRecordsCallback(this, Time.SYSTEM.milliseconds()));
                        this.throttle.increment();
                    }
                }
                finally {
                    if (future != null) {
                        future.get();
                    }
                    this.producer.close();
                }
                this.statusUpdaterFuture.cancel(false);
            }
            catch (Exception e) {
                try {
                    WorkerUtils.abort(log, "SendRecords", e, (KafkaFutureImpl<String>)ProduceBenchWorker.this.doneFuture);
                    this.statusUpdaterFuture.cancel(false);
                }
                catch (Throwable throwable) {
                    this.statusUpdaterFuture.cancel(false);
                    StatusData statusData = new StatusUpdater(this.histogram).update();
                    long curTimeMs = Time.SYSTEM.milliseconds();
                    log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
                    throw throwable;
                }
                StatusData statusData = new StatusUpdater(this.histogram).update();
                long curTimeMs = Time.SYSTEM.milliseconds();
                log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
            }
            StatusData statusData = new StatusUpdater(this.histogram).update();
            long curTimeMs = Time.SYSTEM.milliseconds();
            log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
            ProduceBenchWorker.this.doneFuture.complete((Object)"");
            return null;
        }

        void recordDuration(long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    private static class SendRecordsThrottle
    extends Throttle {
        private final KafkaProducer<?, ?> producer;

        SendRecordsThrottle(int maxPerPeriod, KafkaProducer<?, ?> producer) {
            super(maxPerPeriod, 100);
            this.producer = producer;
        }

        @Override
        protected synchronized void delay(long amount) throws InterruptedException {
            long startMs = this.time().milliseconds();
            this.producer.flush();
            long endMs = this.time().milliseconds();
            long delta = endMs - startMs;
            super.delay(amount - delta);
        }
    }

    private static class SendRecordsCallback
    implements Callback {
        private final SendRecords sendRecords;
        private final long startMs;

        SendRecordsCallback(SendRecords sendRecords, long startMs) {
            this.sendRecords = sendRecords;
            this.startMs = startMs;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = Time.SYSTEM.milliseconds();
            long durationMs = now - this.startMs;
            this.sendRecords.recordDuration(durationMs);
            if (exception != null) {
                log.error("SendRecordsCallback: error", (Throwable)exception);
            }
        }
    }

    public class Prepare
    implements Runnable {
        @Override
        public void run() {
            try {
                PartitionsSpec partSpec;
                String topicName;
                HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
                HashSet<TopicPartition> active = new HashSet<TopicPartition>();
                for (Map.Entry<String, PartitionsSpec> entry : ProduceBenchWorker.this.spec.activeTopics().materialize().entrySet()) {
                    topicName = entry.getKey();
                    partSpec = entry.getValue();
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                    for (Integer partitionNumber : partSpec.partitionNumbers()) {
                        active.add(new TopicPartition(topicName, partitionNumber.intValue()));
                    }
                }
                if (active.isEmpty()) {
                    throw new RuntimeException("You must specify at least one active topic.");
                }
                for (Map.Entry<String, PartitionsSpec> entry : ProduceBenchWorker.this.spec.inactiveTopics().materialize().entrySet()) {
                    topicName = entry.getKey();
                    partSpec = entry.getValue();
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                }
                ProduceBenchWorker.this.status.update((JsonNode)new TextNode("Creating " + newTopics.keySet().size() + " topic(s)"));
                WorkerUtils.createTopics(log, ProduceBenchWorker.this.spec.bootstrapServers(), ProduceBenchWorker.this.spec.commonClientConf(), ProduceBenchWorker.this.spec.adminClientConf(), newTopics, false);
                ProduceBenchWorker.this.status.update((JsonNode)new TextNode("Created " + newTopics.keySet().size() + " topic(s)"));
                ProduceBenchWorker.this.executor.submit(new SendRecords(active));
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, (KafkaFutureImpl<String>)ProduceBenchWorker.this.doneFuture);
            }
        }
    }
}

