/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.HashSet;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;

public class KTableKTableJoinMerger<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final KTableProcessorSupplier<K, ?, V> parent1;
    private final KTableProcessorSupplier<K, ?, V> parent2;
    private final String queryableName;
    private boolean sendOldValues = false;

    KTableKTableJoinMerger(KTableProcessorSupplier<K, ?, V> parent1, KTableProcessorSupplier<K, ?, V> parent2, String queryableName) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.queryableName = queryableName;
    }

    public String getQueryableName() {
        return this.queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableKTableJoinMergeProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return KTableKTableJoinMerger.this.parent1.view().get();
            }

            @Override
            public String[] storeNames() {
                String[] storeNames1 = KTableKTableJoinMerger.this.parent1.view().storeNames();
                String[] storeNames2 = KTableKTableJoinMerger.this.parent2.view().storeNames();
                HashSet stores = new HashSet(storeNames1.length + storeNames2.length);
                Collections.addAll(stores, storeNames1);
                Collections.addAll(stores, storeNames2);
                return stores.toArray(new String[0]);
            }
        };
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        this.parent1.enableSendingOldValues(true);
        this.parent2.enableSendingOldValues(true);
        this.sendOldValues = true;
        return true;
    }

    public static <K, V> KTableKTableJoinMerger<K, V> of(KTableProcessorSupplier<K, ?, V> parent1, KTableProcessorSupplier<K, ?, V> parent2) {
        return KTableKTableJoinMerger.of(parent1, parent2, null);
    }

    public static <K, V> KTableKTableJoinMerger<K, V> of(KTableProcessorSupplier<K, ?, V> parent1, KTableProcessorSupplier<K, ?, V> parent2, String queryableName) {
        return new KTableKTableJoinMerger<K, V>(parent1, parent2, queryableName);
    }

    private class KTableKTableJoinMergeProcessor
    extends AbstractProcessor<K, Change<V>> {
        private TimestampedKeyValueStore<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;

        private KTableKTableJoinMergeProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableKTableJoinMerger.this.queryableName != null) {
                this.store = (TimestampedKeyValueStore)context.getStateStore(KTableKTableJoinMerger.this.queryableName);
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new TimestampedCacheFlushListener(context), KTableKTableJoinMerger.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> value) {
            if (KTableKTableJoinMerger.this.queryableName != null) {
                this.store.put(key, ValueAndTimestamp.make(value.newValue, this.context().timestamp()));
                this.tupleForwarder.maybeForward(key, value.newValue, KTableKTableJoinMerger.this.sendOldValues ? (Object)value.oldValue : null);
            } else if (KTableKTableJoinMerger.this.sendOldValues) {
                this.context().forward(key, value);
            } else {
                this.context().forward(key, new Change<Object>(value.newValue, null));
            }
        }
    }
}

