/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;

public class RocksDBKeyValueStoreSupplier<K, V>
implements StateStoreSupplier {
    private final String name;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Time time;

    public RocksDBKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde) {
        this(name, keySerde, valueSerde, null);
    }

    public RocksDBKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        this.name = name;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public StateStore get() {
        RocksDBStore<K, V> store = new RocksDBStore<K, V>(this.name, this.keySerde, this.valueSerde);
        return new MeteredKeyValueStore<K, V>(store.enableLogging(), "rocksdb-state", this.time);
    }
}

