/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionInfo {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionInfo.class);
    private static final int CURRENT_VERSION = 1;
    public final int version;
    public final UUID processId;
    public final Set<TaskId> prevTasks;
    public final Set<TaskId> standbyTasks;

    public SubscriptionInfo(UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks) {
        this(1, processId, prevTasks, standbyTasks);
    }

    private SubscriptionInfo(int version, UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks) {
        this.version = version;
        this.processId = processId;
        this.prevTasks = prevTasks;
        this.standbyTasks = standbyTasks;
    }

    public ByteBuffer encode() {
        if (this.version == 1) {
            ByteBuffer buf = ByteBuffer.allocate(24 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8);
            buf.putInt(this.version);
            buf.putLong(this.processId.getMostSignificantBits());
            buf.putLong(this.processId.getLeastSignificantBits());
            buf.putInt(this.prevTasks.size());
            for (TaskId id : this.prevTasks) {
                id.writeTo(buf);
            }
            buf.putInt(this.standbyTasks.size());
            for (TaskId id : this.standbyTasks) {
                id.writeTo(buf);
            }
            buf.rewind();
            return buf;
        }
        TaskAssignmentException ex = new TaskAssignmentException("unable to encode subscription data: version=" + this.version);
        log.error(ex.getMessage(), (Throwable)((Object)ex));
        throw ex;
    }

    public static SubscriptionInfo decode(ByteBuffer data) {
        data.rewind();
        int version = data.getInt();
        if (version == 1) {
            UUID processId = new UUID(data.getLong(), data.getLong());
            HashSet<TaskId> prevTasks = new HashSet<TaskId>();
            int numPrevs = data.getInt();
            for (int i = 0; i < numPrevs; ++i) {
                TaskId id = TaskId.readFrom(data);
                prevTasks.add(id);
            }
            HashSet<TaskId> standbyTasks = new HashSet<TaskId>();
            int numCached = data.getInt();
            for (int i = 0; i < numCached; ++i) {
                standbyTasks.add(TaskId.readFrom(data));
            }
            return new SubscriptionInfo(version, processId, prevTasks, standbyTasks);
        }
        TaskAssignmentException ex = new TaskAssignmentException("unable to decode subscription data: version=" + version);
        log.error(ex.getMessage(), (Throwable)((Object)ex));
        throw ex;
    }

    public int hashCode() {
        return this.version ^ this.processId.hashCode() ^ this.prevTasks.hashCode() ^ this.standbyTasks.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SubscriptionInfo) {
            SubscriptionInfo other = (SubscriptionInfo)o;
            return this.version == other.version && this.processId.equals(other.processId) && this.prevTasks.equals(other.prevTasks) && this.standbyTasks.equals(other.standbyTasks);
        }
        return false;
    }
}

