/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security;

import java.security.AlgorithmParameters;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;
import org.apache.kafka.security.CipherParamsEncoder;
import org.apache.kafka.security.PasswordEncoder;

public class IvParamsEncoder
implements CipherParamsEncoder {
    @Override
    public Map<String, String> toMap(AlgorithmParameters cipherParams) throws InvalidParameterSpecException {
        if (cipherParams != null) {
            IvParameterSpec ivSpec = cipherParams.getParameterSpec(IvParameterSpec.class);
            return Collections.singletonMap("initializationVector", PasswordEncoder.base64Encode(ivSpec.getIV()));
        }
        throw new IllegalStateException("Could not determine initialization vector for cipher");
    }

    @Override
    public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
        return new IvParameterSpec(PasswordEncoder.base64Decode(paramMap.get("initializationVector")));
    }
}

