/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.deferred;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeMap;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.deferred.DeferredEvent;
import org.slf4j.Logger;

public class DeferredEventQueue {
    private final Logger log;
    private final TreeMap<Long, List<DeferredEvent>> pending = new TreeMap();

    public DeferredEventQueue(LogContext logContext) {
        this.log = logContext.logger(DeferredEventQueue.class);
    }

    public void completeUpTo(long offset) {
        Map.Entry<Long, List<DeferredEvent>> entry;
        Iterator<Map.Entry<Long, List<DeferredEvent>>> iter = this.pending.entrySet().iterator();
        int numCompleted = 0;
        while (iter.hasNext() && (entry = iter.next()).getKey() <= offset) {
            for (DeferredEvent event : entry.getValue()) {
                this.log.debug("completeUpTo({}): successfully completing {}", (Object)offset, (Object)event);
                event.complete(null);
                ++numCompleted;
            }
            iter.remove();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("completeUpTo({}): successfully completed {} deferred entries", (Object)offset, (Object)numCompleted);
        }
    }

    public void failAll(Exception exception) {
        Iterator<Map.Entry<Long, List<DeferredEvent>>> iter = this.pending.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, List<DeferredEvent>> entry = iter.next();
            for (DeferredEvent event : entry.getValue()) {
                this.log.info("failAll({}): failing {}.", (Object)exception.getClass().getSimpleName(), (Object)event);
                event.complete(exception);
            }
            iter.remove();
        }
    }

    public void add(long offset, DeferredEvent event) {
        long lastKey;
        if (!this.pending.isEmpty() && offset < (lastKey = this.pending.lastKey().longValue())) {
            throw new IllegalArgumentException("There is already a deferred event with offset " + lastKey + ". We should not add one with an offset of " + offset + " which is lower than that.");
        }
        List<DeferredEvent> events = this.pending.get(offset);
        if (events == null) {
            events = new ArrayList<DeferredEvent>();
            this.pending.put(offset, events);
        }
        events.add(event);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Adding deferred event {} at offset {}", (Object)event, (Object)offset);
        }
    }

    public OptionalLong highestPendingOffset() {
        if (this.pending.isEmpty()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(this.pending.lastKey());
    }
}

