/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectoryIdTest {
    @Test
    void testUnassignedIsReserved() {
        Assertions.assertTrue((boolean)DirectoryId.reserved((Uuid)DirectoryId.UNASSIGNED));
    }

    @Test
    void testLostIsReserved() {
        Assertions.assertTrue((boolean)DirectoryId.reserved((Uuid)DirectoryId.LOST));
    }

    @Test
    void testMigratingIsReserved() {
        Assertions.assertTrue((boolean)DirectoryId.reserved((Uuid)DirectoryId.MIGRATING));
    }

    @Test
    void testCreateAssignmentMap() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DirectoryId.createAssignmentMap((int[])new int[]{1, 2}, (Uuid[])DirectoryId.unassignedArray((int)3)));
        Assertions.assertEquals((Object)new HashMap<Integer, Uuid>(){
            {
                this.put(1, Uuid.fromString((String)"upjfkCrUR9GNn1i94ip1wg"));
                this.put(2, Uuid.fromString((String)"bCF3l0RIQjOKhUqgbivHZA"));
                this.put(3, Uuid.fromString((String)"Fg3mFhcVQlqCWRk4dZazxw"));
                this.put(4, Uuid.fromString((String)"bv9TEYi4TqOm52hLmrxT5w"));
            }
        }, (Object)DirectoryId.createAssignmentMap((int[])new int[]{1, 2, 3, 4}, (Uuid[])new Uuid[]{Uuid.fromString((String)"upjfkCrUR9GNn1i94ip1wg"), Uuid.fromString((String)"bCF3l0RIQjOKhUqgbivHZA"), Uuid.fromString((String)"Fg3mFhcVQlqCWRk4dZazxw"), Uuid.fromString((String)"bv9TEYi4TqOm52hLmrxT5w")}));
    }

    @Test
    void testIsOnline() {
        ArrayList<Uuid> sortedDirs = new ArrayList<Uuid>(List.of(Uuid.fromString((String)"imQKg2cXTVe8OUFNa3R9bg"), Uuid.fromString((String)"Mwy5wxTDQxmsZwGzjsaX7w"), Uuid.fromString((String)"s8rHMluuSDCnxt3FmKwiyw")));
        sortedDirs.sort(Uuid::compareTo);
        List emptySortedDirs = List.of();
        Assertions.assertTrue((boolean)DirectoryId.isOnline((Uuid)Uuid.fromString((String)"imQKg2cXTVe8OUFNa3R9bg"), sortedDirs));
        Assertions.assertTrue((boolean)DirectoryId.isOnline((Uuid)Uuid.fromString((String)"Mwy5wxTDQxmsZwGzjsaX7w"), sortedDirs));
        Assertions.assertTrue((boolean)DirectoryId.isOnline((Uuid)Uuid.fromString((String)"s8rHMluuSDCnxt3FmKwiyw"), sortedDirs));
        Assertions.assertTrue((boolean)DirectoryId.isOnline((Uuid)DirectoryId.MIGRATING, sortedDirs));
        Assertions.assertTrue((boolean)DirectoryId.isOnline((Uuid)DirectoryId.UNASSIGNED, sortedDirs));
        Assertions.assertFalse((boolean)DirectoryId.isOnline((Uuid)DirectoryId.LOST, sortedDirs));
        Assertions.assertFalse((boolean)DirectoryId.isOnline((Uuid)Uuid.fromString((String)"AMYchbMtS6yhtsXbca7DQg"), sortedDirs));
        Assertions.assertTrue((boolean)DirectoryId.isOnline((Uuid)Uuid.randomUuid(), emptySortedDirs));
    }
}

