/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.metadata.RemoveUserScramCredentialRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.server.common.MetadataVersion;

public final class ScramDelta {
    private final ScramImage image;
    private final Map<ScramMechanism, Map<String, Optional<ScramCredentialData>>> changes = new HashMap<ScramMechanism, Map<String, Optional<ScramCredentialData>>>();

    public ScramDelta(ScramImage image) {
        this.image = image;
    }

    public void finishSnapshot() {
        for (Map.Entry<ScramMechanism, Map<String, ScramCredentialData>> mechanismEntry : this.image.mechanisms().entrySet()) {
            Map userNameMap = this.changes.computeIfAbsent(mechanismEntry.getKey(), __ -> new HashMap());
            for (String userName : mechanismEntry.getValue().keySet()) {
                if (userNameMap.containsKey(userName)) continue;
                userNameMap.put(userName, Optional.empty());
            }
        }
    }

    public ScramImage image() {
        return this.image;
    }

    public Map<ScramMechanism, Map<String, Optional<ScramCredentialData>>> changes() {
        return this.changes;
    }

    public void replay(UserScramCredentialRecord record) {
        ScramMechanism mechanism = ScramMechanism.fromType((byte)record.mechanism());
        Map userChanges = this.changes.computeIfAbsent(mechanism, __ -> new HashMap());
        userChanges.put(record.name(), Optional.of(ScramCredentialData.fromRecord(record)));
    }

    public void replay(RemoveUserScramCredentialRecord record) {
        ScramMechanism mechanism = ScramMechanism.fromType((byte)record.mechanism());
        Map userChanges = this.changes.computeIfAbsent(mechanism, __ -> new HashMap());
        userChanges.put(record.name(), Optional.empty());
    }

    public void handleMetadataVersionChange(MetadataVersion changedMetadataVersion) {
    }

    public ScramImage apply() {
        HashMap<ScramMechanism, Map<String, ScramCredentialData>> newMechanisms = new HashMap<ScramMechanism, Map<String, ScramCredentialData>>();
        for (Map.Entry<ScramMechanism, Map<String, ScramCredentialData>> entry : this.image.mechanisms().entrySet()) {
            newMechanisms.put(entry.getKey(), new HashMap<String, ScramCredentialData>(entry.getValue()));
        }
        for (Map.Entry<ScramMechanism, Map<String, Object>> entry : this.changes.entrySet()) {
            Map userMap = newMechanisms.computeIfAbsent(entry.getKey(), __ -> new HashMap());
            for (Map.Entry<String, Object> userNameEntry : entry.getValue().entrySet()) {
                if (((Optional)userNameEntry.getValue()).isPresent()) {
                    userMap.put(userNameEntry.getKey(), (ScramCredentialData)((Optional)userNameEntry.getValue()).get());
                    continue;
                }
                userMap.remove(userNameEntry.getKey());
                if (!userMap.isEmpty()) continue;
                newMechanisms.remove(entry.getKey());
            }
        }
        return new ScramImage(newMechanisms);
    }

    public String toString() {
        return "ScramDelta(changes=" + String.valueOf(this.changes) + ")";
    }
}

