/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.PeriodicTaskFlag;

class PeriodicTask {
    private final String name;
    private final Supplier<ControllerResult<Boolean>> op;
    private final long immediatePeriodNs;
    private final long periodNs;
    private final EnumSet<PeriodicTaskFlag> flags;
    private static final long DEFAULT_IMMEDIATE_PERIOD_NS = TimeUnit.MILLISECONDS.toNanos(10L);

    PeriodicTask(String name, Supplier<ControllerResult<Boolean>> op, long periodNs, EnumSet<PeriodicTaskFlag> flags) {
        this.name = name;
        this.op = op;
        this.immediatePeriodNs = DEFAULT_IMMEDIATE_PERIOD_NS;
        this.periodNs = periodNs;
        this.flags = flags;
    }

    PeriodicTask(String name, Supplier<ControllerResult<Boolean>> op, long periodNs, EnumSet<PeriodicTaskFlag> flags, long immediatePeriodNs) {
        this.name = name;
        this.op = op;
        this.immediatePeriodNs = immediatePeriodNs;
        this.periodNs = periodNs;
        this.flags = flags;
    }

    String name() {
        return this.name;
    }

    Supplier<ControllerResult<Boolean>> op() {
        return this.op;
    }

    long immediatePeriodNs() {
        return this.immediatePeriodNs;
    }

    long periodNs() {
        return this.periodNs;
    }

    EnumSet<PeriodicTaskFlag> flags() {
        return this.flags;
    }
}

