/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Objects;
import org.apache.kafka.raft.OffsetAndEpoch;

public class ZkMigrationLeadershipState {
    public static final ZkMigrationLeadershipState EMPTY = new ZkMigrationLeadershipState(-1, -1, -1L, -1, -1L, -2, -1, -2);
    private final int kraftControllerId;
    private final int kraftControllerEpoch;
    private final long kraftMetadataOffset;
    private final int kraftMetadataEpoch;
    private final long lastUpdatedTimeMs;
    private final int migrationZkVersion;
    private final int zkControllerEpoch;
    private final int zkControllerEpochZkVersion;

    public ZkMigrationLeadershipState(int kraftControllerId, int kraftControllerEpoch, long kraftMetadataOffset, int kraftMetadataEpoch, long lastUpdatedTimeMs, int migrationZkVersion, int zkControllerEpoch, int zkControllerEpochZkVersion) {
        this.kraftControllerId = kraftControllerId;
        this.kraftControllerEpoch = kraftControllerEpoch;
        this.kraftMetadataOffset = kraftMetadataOffset;
        this.kraftMetadataEpoch = kraftMetadataEpoch;
        this.lastUpdatedTimeMs = lastUpdatedTimeMs;
        this.migrationZkVersion = migrationZkVersion;
        this.zkControllerEpoch = zkControllerEpoch;
        this.zkControllerEpochZkVersion = zkControllerEpochZkVersion;
    }

    public ZkMigrationLeadershipState withMigrationZkVersion(int zkVersion) {
        return new ZkMigrationLeadershipState(this.kraftControllerId, this.kraftControllerEpoch, this.kraftMetadataOffset, this.kraftMetadataEpoch, this.lastUpdatedTimeMs, zkVersion, this.zkControllerEpoch, this.zkControllerEpochZkVersion);
    }

    public ZkMigrationLeadershipState withZkController(int zkControllerEpoch, int zkControllerEpochZkVersion) {
        return new ZkMigrationLeadershipState(this.kraftControllerId, this.kraftControllerEpoch, this.kraftMetadataOffset, this.kraftMetadataEpoch, this.lastUpdatedTimeMs, this.migrationZkVersion, zkControllerEpoch, zkControllerEpochZkVersion);
    }

    public ZkMigrationLeadershipState withUnknownZkController() {
        return this.withZkController(ZkMigrationLeadershipState.EMPTY.zkControllerEpoch, ZkMigrationLeadershipState.EMPTY.zkControllerEpochZkVersion);
    }

    public ZkMigrationLeadershipState withNewKRaftController(int controllerId, int controllerEpoch) {
        return new ZkMigrationLeadershipState(controllerId, controllerEpoch, this.kraftMetadataOffset, this.kraftMetadataEpoch, this.lastUpdatedTimeMs, this.migrationZkVersion, this.zkControllerEpoch, this.zkControllerEpochZkVersion);
    }

    public ZkMigrationLeadershipState withKRaftMetadataOffsetAndEpoch(long metadataOffset, int metadataEpoch) {
        return new ZkMigrationLeadershipState(this.kraftControllerId, this.kraftControllerEpoch, metadataOffset, metadataEpoch, this.lastUpdatedTimeMs, this.migrationZkVersion, this.zkControllerEpoch, this.zkControllerEpochZkVersion);
    }

    public int kraftControllerId() {
        return this.kraftControllerId;
    }

    public int kraftControllerEpoch() {
        return this.kraftControllerEpoch;
    }

    public long kraftMetadataOffset() {
        return this.kraftMetadataOffset;
    }

    public long kraftMetadataEpoch() {
        return this.kraftMetadataEpoch;
    }

    public long lastUpdatedTimeMs() {
        return this.lastUpdatedTimeMs;
    }

    public int migrationZkVersion() {
        return this.migrationZkVersion;
    }

    public int zkControllerEpoch() {
        return this.zkControllerEpoch;
    }

    public int zkControllerEpochZkVersion() {
        return this.zkControllerEpochZkVersion;
    }

    public boolean zkMigrationComplete() {
        return this.kraftMetadataOffset > 0L;
    }

    public OffsetAndEpoch offsetAndEpoch() {
        return new OffsetAndEpoch(this.kraftMetadataOffset, this.kraftMetadataEpoch);
    }

    public String toString() {
        return "ZkMigrationLeadershipState{kraftControllerId=" + this.kraftControllerId + ", kraftControllerEpoch=" + this.kraftControllerEpoch + ", kraftMetadataOffset=" + this.kraftMetadataOffset + ", kraftMetadataEpoch=" + this.kraftMetadataEpoch + ", lastUpdatedTimeMs=" + this.lastUpdatedTimeMs + ", migrationZkVersion=" + this.migrationZkVersion + ", controllerZkEpoch=" + this.zkControllerEpoch + ", controllerZkVersion=" + this.zkControllerEpochZkVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZkMigrationLeadershipState that = (ZkMigrationLeadershipState)o;
        return this.kraftControllerId == that.kraftControllerId && this.kraftControllerEpoch == that.kraftControllerEpoch && this.kraftMetadataOffset == that.kraftMetadataOffset && this.kraftMetadataEpoch == that.kraftMetadataEpoch && this.lastUpdatedTimeMs == that.lastUpdatedTimeMs && this.migrationZkVersion == that.migrationZkVersion && this.zkControllerEpoch == that.zkControllerEpoch && this.zkControllerEpochZkVersion == that.zkControllerEpochZkVersion;
    }

    public int hashCode() {
        return Objects.hash(this.kraftControllerId, this.kraftControllerEpoch, this.kraftMetadataOffset, this.kraftMetadataEpoch, this.lastUpdatedTimeMs, this.migrationZkVersion, this.zkControllerEpoch, this.zkControllerEpochZkVersion);
    }
}

