/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Objects;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.raft.OffsetAndEpoch;

public final class MetadataImage {
    public static final MetadataImage EMPTY = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY);
    private final MetadataProvenance provenance;
    private final FeaturesImage features;
    private final ClusterImage cluster;
    private final TopicsImage topics;
    private final ConfigurationsImage configs;
    private final ClientQuotasImage clientQuotas;
    private final ProducerIdsImage producerIds;
    private final AclsImage acls;

    public MetadataImage(MetadataProvenance provenance, FeaturesImage features, ClusterImage cluster, TopicsImage topics, ConfigurationsImage configs, ClientQuotasImage clientQuotas, ProducerIdsImage producerIds, AclsImage acls) {
        this.provenance = provenance;
        this.features = features;
        this.cluster = cluster;
        this.topics = topics;
        this.configs = configs;
        this.clientQuotas = clientQuotas;
        this.producerIds = producerIds;
        this.acls = acls;
    }

    public boolean isEmpty() {
        return this.features.isEmpty() && this.cluster.isEmpty() && this.topics.isEmpty() && this.configs.isEmpty() && this.clientQuotas.isEmpty() && this.producerIds.isEmpty() && this.acls.isEmpty();
    }

    public MetadataProvenance provenance() {
        return this.provenance;
    }

    public OffsetAndEpoch highestOffsetAndEpoch() {
        return new OffsetAndEpoch(this.provenance.lastContainedOffset(), this.provenance.lastContainedEpoch());
    }

    public long offset() {
        return this.provenance.lastContainedOffset();
    }

    public FeaturesImage features() {
        return this.features;
    }

    public ClusterImage cluster() {
        return this.cluster;
    }

    public TopicsImage topics() {
        return this.topics;
    }

    public ConfigurationsImage configs() {
        return this.configs;
    }

    public ClientQuotasImage clientQuotas() {
        return this.clientQuotas;
    }

    public ProducerIdsImage producerIds() {
        return this.producerIds;
    }

    public AclsImage acls() {
        return this.acls;
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        this.features.write(writer, options);
        this.cluster.write(writer, options);
        this.topics.write(writer, options);
        this.configs.write(writer, options);
        this.clientQuotas.write(writer, options);
        this.producerIds.write(writer, options);
        this.acls.write(writer, options);
        writer.close(true);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MetadataImage other = (MetadataImage)o;
        return this.provenance.equals(other.provenance) && this.features.equals(other.features) && this.cluster.equals(other.cluster) && this.topics.equals(other.topics) && this.configs.equals(other.configs) && this.clientQuotas.equals(other.clientQuotas) && this.producerIds.equals(other.producerIds) && this.acls.equals(other.acls);
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.features, this.cluster, this.topics, this.configs, this.clientQuotas, this.producerIds, this.acls);
    }

    public String toString() {
        return "MetadataImage(provenance=" + this.provenance + ", features=" + this.features + ", cluster=" + this.cluster + ", topics=" + this.topics + ", configs=" + this.configs + ", clientQuotas=" + this.clientQuotas + ", producerIdsImage=" + this.producerIds + ", acls=" + this.acls + ")";
    }
}

